/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;

public class Sets {
    private Sets() {
    }

    public static <E, F> Set<Pair<E, F>> cross(Set<E> s1, Set<F> s2) {
        Set<Pair<Pair<E, F>, F>> s = Generics.newHashSet();
        for (E o1 : s1) {
            for (F o2 : s2) {
                s.add(new Pair<E, F>(o1, o2));
            }
        }
        return s;
    }

    public static <E> Set<E> diff(Set<E> s1, Set<E> s2) {
        Set<E> s = Generics.newHashSet();
        for (E o : s1) {
            if (s2.contains(o)) continue;
            s.add(o);
        }
        return s;
    }

    public static <E> Set<E> symmetricDiff(Set<E> s1, Set<E> s2) {
        Set<E> s = Generics.newHashSet();
        for (E o : s1) {
            if (s2.contains(o)) continue;
            s.add(o);
        }
        for (E o : s2) {
            if (s1.contains(o)) continue;
            s.add(o);
        }
        return s;
    }

    public static <E> Set<E> union(Set<E> s1, Set<E> s2) {
        Set<E> s = Generics.newHashSet();
        s.addAll(s1);
        s.addAll(s2);
        return s;
    }

    public static <E> Set<E> intersection(Set<E> s1, Set<E> s2) {
        Set<E> s = Generics.newHashSet();
        s.addAll(s1);
        s.retainAll(s2);
        return s;
    }

    public static <E> boolean intersects(Set<E> s1, Set<E> s2) {
        return !Collections.disjoint(s1, s2);
    }

    public static <E> Set<Set<E>> powerSet(Set<E> s) {
        if (s.isEmpty()) {
            Set h = Generics.newHashSet();
            Set h0 = Generics.newHashSet(0);
            h.add(h0);
            return h;
        }
        Iterator<E> i = s.iterator();
        E elt = i.next();
        s.remove(elt);
        Set<Set<Set<E>>> pow = Sets.powerSet(s);
        Set<Set<E>> pow1 = Sets.powerSet(s);
        for (Set<E> t : pow1) {
            t.add(elt);
            pow.add(t);
        }
        s.add(elt);
        return pow;
    }

    public static <E> void assertEquals(Set<E> first, Set<E> second, String firstName, String secondName, boolean outputShared, Supplier<String> errorMessage) {
        Set<E> shared;
        if (first.equals(second)) {
            return;
        }
        Set<E> firstExtras = Sets.diff(first, second);
        Set<E> secondExtras = Sets.diff(second, first);
        StringBuilder builder = new StringBuilder();
        builder.append(errorMessage.get());
        builder.append("\n");
        if (firstExtras.size() > 0) {
            builder.append("-- Extra results in " + firstName + ": --\n");
            for (E extra : firstExtras) {
                builder.append(extra == null ? "(null)" : extra.toString());
                builder.append("\n");
            }
        }
        if (secondExtras.size() > 0) {
            builder.append("-- Extra results in " + secondName + ": --\n");
            for (E extra : secondExtras) {
                builder.append(extra == null ? "(null)" : extra.toString());
                builder.append("\n");
            }
        }
        if (outputShared && (shared = Sets.intersection(first, second)).size() > 0) {
            builder.append("-- Common results in " + firstName + " and " + secondName + ": --\n");
            for (E extra : shared) {
                builder.append(extra == null ? "(null)" : extra.toString());
                builder.append("\n");
            }
        }
        throw new AssertionError((Object)builder.toString());
    }

    public static void main(String[] args) {
        Set<String> h = Generics.newHashSet();
        h.add("a");
        h.add("b");
        h.add("c");
        Set pow = Sets.powerSet(h);
        System.out.println(pow);
    }
}

