/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.ASBCunkDetector;
import edu.stanford.nlp.tagger.maxent.CTBunkDictDetector;
import edu.stanford.nlp.tagger.maxent.CaselessCompanyNameDetector;
import edu.stanford.nlp.tagger.maxent.CompanyNameDetector;
import edu.stanford.nlp.tagger.maxent.CtbPreDetector;
import edu.stanford.nlp.tagger.maxent.CtbSufDetector;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorAllCap;
import edu.stanford.nlp.tagger.maxent.ExtractorAllCapitalized;
import edu.stanford.nlp.tagger.maxent.ExtractorCNumber;
import edu.stanford.nlp.tagger.maxent.ExtractorCapDistLC;
import edu.stanford.nlp.tagger.maxent.ExtractorCapLCSeen;
import edu.stanford.nlp.tagger.maxent.ExtractorDash;
import edu.stanford.nlp.tagger.maxent.ExtractorDistsim;
import edu.stanford.nlp.tagger.maxent.ExtractorDistsimConjunction;
import edu.stanford.nlp.tagger.maxent.ExtractorFrenchAdjSuffix;
import edu.stanford.nlp.tagger.maxent.ExtractorFrenchAdvSuffix;
import edu.stanford.nlp.tagger.maxent.ExtractorFrenchNounSuffix;
import edu.stanford.nlp.tagger.maxent.ExtractorFrenchPluralSuffix;
import edu.stanford.nlp.tagger.maxent.ExtractorFrenchVerbSuffix;
import edu.stanford.nlp.tagger.maxent.ExtractorLetterDigitDash;
import edu.stanford.nlp.tagger.maxent.ExtractorMidSentenceCap;
import edu.stanford.nlp.tagger.maxent.ExtractorMidSentenceCapC;
import edu.stanford.nlp.tagger.maxent.ExtractorNonAlphanumeric;
import edu.stanford.nlp.tagger.maxent.ExtractorNumeric;
import edu.stanford.nlp.tagger.maxent.ExtractorSpanishConditionalSuffix;
import edu.stanford.nlp.tagger.maxent.ExtractorSpanishGender;
import edu.stanford.nlp.tagger.maxent.ExtractorSpanishImperfectErIrSuffix;
import edu.stanford.nlp.tagger.maxent.ExtractorStartSentenceCap;
import edu.stanford.nlp.tagger.maxent.ExtractorUCase;
import edu.stanford.nlp.tagger.maxent.ExtractorUpperDigitDash;
import edu.stanford.nlp.tagger.maxent.ExtractorWordPref;
import edu.stanford.nlp.tagger.maxent.ExtractorWordShapeClassifier;
import edu.stanford.nlp.tagger.maxent.ExtractorWordShapeConjunction;
import edu.stanford.nlp.tagger.maxent.ExtractorWordSuff;
import edu.stanford.nlp.tagger.maxent.ExtractorsConjunction;
import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExtractorFramesRare {
    private static final Extractor cWordSuff1 = new ExtractorWordSuff(1, 0);
    private static final Extractor cWordSuff2 = new ExtractorWordSuff(2, 0);
    private static final Extractor cWordSuff3 = new ExtractorWordSuff(3, 0);
    private static final Extractor cWordSuff4 = new ExtractorWordSuff(4, 0);
    private static final Extractor cWordUppCase = new ExtractorUCase();
    private static final Extractor cWordNumber = new ExtractorCNumber();
    private static final Extractor cWordDash = new ExtractorDash();
    private static final Extractor cNoLower = new ExtractorAllCap();
    private static final Extractor cAllCapitalized = new ExtractorAllCapitalized();
    private static final Extractor cCompany = new CompanyNameDetector();
    private static final Extractor cCaselessCompany = new CaselessCompanyNameDetector();
    private static final Extractor cLetterDigitDash = new ExtractorLetterDigitDash();
    private static final Extractor cUpperDigitDash = new ExtractorUpperDigitDash();
    private static final Extractor cCapDist = new ExtractorCapDistLC();
    private static final Extractor[] eFrames_motley_naacl2003 = new Extractor[]{cWordUppCase, cWordNumber, cWordDash, cNoLower, cLetterDigitDash, cCompany, cAllCapitalized, cUpperDigitDash};
    private static final Extractor[] eFrames_motley_naacl2003_left = new Extractor[]{cWordUppCase, cWordNumber, cWordDash, cNoLower, cLetterDigitDash, cAllCapitalized, cUpperDigitDash};
    private static final Extractor[] eFrames_motley_caseless_naacl2003 = new Extractor[]{cWordNumber, cWordDash, cLetterDigitDash, cCaselessCompany};
    private static final ExtractorFrenchNounSuffix cWordFrenchNounSuffix = new ExtractorFrenchNounSuffix();
    private static final ExtractorFrenchAdvSuffix cWordFrenchAdvSuffix = new ExtractorFrenchAdvSuffix();
    private static final ExtractorFrenchVerbSuffix cWordFrenchVerbSuffix = new ExtractorFrenchVerbSuffix();
    private static final ExtractorFrenchAdjSuffix cWordFrenchAdjSuffix = new ExtractorFrenchAdjSuffix();
    private static final ExtractorFrenchPluralSuffix cWordFrenchPluralSuffix = new ExtractorFrenchPluralSuffix();
    private static final Extractor[] french_unknown_extractors = new Extractor[]{cWordFrenchNounSuffix, cWordFrenchAdvSuffix, cWordFrenchVerbSuffix, cWordFrenchAdjSuffix, cWordFrenchPluralSuffix};

    private ExtractorFramesRare() {
    }

    private static void getNaaclExtractors(ArrayList<Extractor> extrs) {
        int i;
        extrs.add(new ExtractorStartSentenceCap());
        extrs.add(new ExtractorMidSentenceCapC());
        extrs.add(new ExtractorMidSentenceCap());
        for (i = 1; i <= 10; ++i) {
            extrs.add(new ExtractorWordSuff(i, 0));
        }
        for (i = 1; i <= 10; ++i) {
            extrs.add(new ExtractorWordPref(i, 0));
        }
    }

    private static void getCaselessNaaclExtractors(ArrayList<Extractor> extrs) {
        int i;
        for (i = 1; i <= 10; ++i) {
            extrs.add(new ExtractorWordSuff(i, 0));
        }
        for (i = 1; i <= 10; ++i) {
            extrs.add(new ExtractorWordPref(i, 0));
        }
    }

    protected static Extractor[] getExtractorFramesRare(String identifier, TTags ttags) {
        ArrayList<Extractor> extrs = new ArrayList<Extractor>();
        List<String> args = StringUtils.valueSplit(identifier, "[a-zA-Z0-9]*(?:\\([^)]*\\))?", "\\s*,\\s*");
        for (String arg : args) {
            int i;
            if ("naacl2003unknowns".equalsIgnoreCase(arg)) {
                extrs.addAll(Arrays.asList(eFrames_motley_naacl2003));
                ExtractorFramesRare.getNaaclExtractors(extrs);
                continue;
            }
            if ("lnaacl2003unknowns".equalsIgnoreCase(arg)) {
                extrs.addAll(Arrays.asList(eFrames_motley_naacl2003_left));
                ExtractorFramesRare.getNaaclExtractors(extrs);
                continue;
            }
            if ("caselessnaacl2003unknowns".equalsIgnoreCase(arg)) {
                extrs.addAll(Arrays.asList(eFrames_motley_caseless_naacl2003));
                ExtractorFramesRare.getCaselessNaaclExtractors(extrs);
                continue;
            }
            if ("naacl2003conjunctions".equalsIgnoreCase(arg)) {
                extrs.addAll(Arrays.asList(ExtractorFramesRare.naacl2003Conjunctions()));
                continue;
            }
            if ("frenchunknowns".equalsIgnoreCase(arg)) {
                extrs.addAll(Arrays.asList(french_unknown_extractors));
                continue;
            }
            if ("spanishunknowns".equalsIgnoreCase(arg)) {
                extrs.add(new ExtractorSpanishGender());
                extrs.add(new ExtractorSpanishConditionalSuffix());
                extrs.add(new ExtractorSpanishImperfectErIrSuffix());
                continue;
            }
            if (arg.startsWith("wordshapes(")) {
                int lWindow = Extractor.getParenthesizedNum(arg, 1);
                int rWindow = Extractor.getParenthesizedNum(arg, 2);
                String wsc = Extractor.getParenthesizedArg(arg, 3);
                if (wsc == null) {
                    wsc = "chris2";
                }
                for (i = lWindow; i <= rWindow; ++i) {
                    extrs.add(new ExtractorWordShapeClassifier(i, wsc));
                }
                continue;
            }
            if (arg.startsWith("wordshapeconjunction(")) {
                int lWindow = Extractor.getParenthesizedNum(arg, 1);
                int rWindow = Extractor.getParenthesizedNum(arg, 2);
                String wsc = Extractor.getParenthesizedArg(arg, 3);
                if (wsc == null) {
                    wsc = "chris2";
                }
                for (i = lWindow; i <= rWindow; ++i) {
                    extrs.add(new ExtractorWordShapeConjunction(lWindow, rWindow, wsc));
                }
                continue;
            }
            if (arg.startsWith("unicodeshapes(")) {
                int lWindow = Extractor.getParenthesizedNum(arg, 1);
                int rWindow = Extractor.getParenthesizedNum(arg, 2);
                for (int i2 = lWindow; i2 <= rWindow; ++i2) {
                    extrs.add(new ExtractorWordShapeClassifier(i2, "chris4"));
                }
                continue;
            }
            if (arg.startsWith("unicodeshapeconjunction(")) {
                int lWindow = Extractor.getParenthesizedNum(arg, 1);
                int rWindow = Extractor.getParenthesizedNum(arg, 2);
                extrs.add(new ExtractorWordShapeConjunction(lWindow, rWindow, "chris4"));
                continue;
            }
            if (arg.startsWith("chinesedictionaryfeatures(")) {
                throw new RuntimeException("These features are no longer supported.  The paths and data files associated with this material are out of date, and the classes used are not thread-safe.  Those problems would need to be fixed to use this feature.");
            }
            if (arg.equalsIgnoreCase("motleyUnknown")) {
                extrs.addAll(Arrays.asList(eFrames_motley_naacl2003));
                continue;
            }
            if (arg.startsWith("suffix(")) {
                int max = Extractor.getParenthesizedNum(arg, 1);
                int position = Extractor.getParenthesizedNum(arg, 2);
                for (int i3 = 1; i3 <= max; ++i3) {
                    extrs.add(new ExtractorWordSuff(i3, position));
                }
                continue;
            }
            if (arg.startsWith("prefix(")) {
                int max = Extractor.getParenthesizedNum(arg, 1);
                int position = Extractor.getParenthesizedNum(arg, 2);
                for (int i4 = 1; i4 <= max; ++i4) {
                    extrs.add(new ExtractorWordPref(i4, position));
                }
                continue;
            }
            if (arg.startsWith("prefixsuffix(")) {
                int max = Extractor.getParenthesizedNum(arg, 1);
                for (int i5 = 1; i5 <= max; ++i5) {
                    extrs.add(new ExtractorsConjunction(new ExtractorWordPref(i5, 0), new ExtractorWordSuff(i5, 0)));
                }
                continue;
            }
            if (arg.startsWith("capitalizationsuffix(")) {
                int max = Extractor.getParenthesizedNum(arg, 1);
                for (int i6 = 1; i6 <= max; ++i6) {
                    extrs.add(new ExtractorsConjunction(cWordUppCase, new ExtractorWordSuff(i6, 0)));
                }
                continue;
            }
            if (arg.startsWith("distsim(")) {
                String path = Extractor.getParenthesizedArg(arg, 1);
                int lWindow = Extractor.getParenthesizedNum(arg, 2);
                int rWindow = Extractor.getParenthesizedNum(arg, 3);
                for (i = lWindow; i <= rWindow; ++i) {
                    extrs.add(new ExtractorDistsim(path, i));
                }
                continue;
            }
            if (arg.startsWith("distsimconjunction(")) {
                String path = Extractor.getParenthesizedArg(arg, 1);
                int lWindow = Extractor.getParenthesizedNum(arg, 2);
                int rWindow = Extractor.getParenthesizedNum(arg, 3);
                extrs.add(new ExtractorDistsimConjunction(path, lWindow, rWindow));
                continue;
            }
            if (arg.equalsIgnoreCase("lctagfeatures")) {
                extrs.addAll(Arrays.asList(ExtractorFramesRare.lcTagFeatures(ttags)));
                continue;
            }
            if (arg.equalsIgnoreCase("nonalphanumeric)")) {
                extrs.add(new ExtractorNonAlphanumeric());
                continue;
            }
            if (arg.equalsIgnoreCase("numeric)")) {
                extrs.add(new ExtractorNumeric());
                continue;
            }
            if (!arg.startsWith("rareExtractor(")) continue;
            String className = Extractor.getParenthesizedArg(arg, 1);
            try {
                Extractor e = (Extractor)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                extrs.add(e);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't create POS tagger extractor class " + className, e);
            }
        }
        return extrs.toArray(Extractor.EMPTY_EXTRACTOR_ARRAY);
    }

    private static Extractor[] naacl2003Conjunctions() {
        Extractor[] newW = new Extractor[24];
        newW[0] = new ExtractorsConjunction(cWordUppCase, cWordSuff1);
        newW[1] = new ExtractorsConjunction(cWordUppCase, cWordSuff2);
        newW[2] = new ExtractorsConjunction(cWordUppCase, cWordSuff3);
        newW[3] = new ExtractorsConjunction(cWordUppCase, cWordSuff4);
        newW[4] = new ExtractorsConjunction(cNoLower, cWordSuff1);
        newW[5] = new ExtractorsConjunction(cNoLower, cWordSuff2);
        newW[6] = new ExtractorsConjunction(cNoLower, cWordSuff3);
        newW[7] = new ExtractorsConjunction(cNoLower, cWordSuff4);
        ExtractorMidSentenceCap cMidSentence = new ExtractorMidSentenceCap();
        newW[8] = new ExtractorsConjunction(cMidSentence, cWordSuff1);
        newW[9] = new ExtractorsConjunction(cMidSentence, cWordSuff2);
        newW[10] = new ExtractorsConjunction(cMidSentence, cWordSuff3);
        newW[11] = new ExtractorsConjunction(cMidSentence, cWordSuff4);
        ExtractorStartSentenceCap cWordStartUCase = new ExtractorStartSentenceCap();
        newW[12] = new ExtractorsConjunction(cWordStartUCase, cWordSuff1);
        newW[13] = new ExtractorsConjunction(cWordStartUCase, cWordSuff2);
        newW[14] = new ExtractorsConjunction(cWordStartUCase, cWordSuff3);
        newW[15] = new ExtractorsConjunction(cWordStartUCase, cWordSuff4);
        ExtractorMidSentenceCapC cWordMidUCase = new ExtractorMidSentenceCapC();
        newW[16] = new ExtractorsConjunction(cWordMidUCase, cWordSuff1);
        newW[17] = new ExtractorsConjunction(cWordMidUCase, cWordSuff2);
        newW[18] = new ExtractorsConjunction(cWordMidUCase, cWordSuff3);
        newW[19] = new ExtractorsConjunction(cWordMidUCase, cWordSuff4);
        newW[20] = new ExtractorsConjunction(cCapDist, cWordSuff1);
        newW[21] = new ExtractorsConjunction(cCapDist, cWordSuff2);
        newW[22] = new ExtractorsConjunction(cCapDist, cWordSuff3);
        newW[23] = new ExtractorsConjunction(cCapDist, cWordSuff4);
        return newW;
    }

    private static Extractor[] lcTagFeatures(TTags ttags) {
        Extractor[] newE = new Extractor[ttags.getSize()];
        for (int i = 0; i < ttags.getSize(); ++i) {
            String tag = ttags.getTag(i);
            newE[i] = new ExtractorCapLCSeen(tag);
        }
        return newE;
    }

    private static Extractor[] ctbPreFeatures(int n) {
        String[] tagsets = new String[]{"AD", "AS", "BA", "CC", "CD", "CS", "DEC", "DEG", "DER", "DEV", "DT", "ETC", "FW", "IJ", "JJ", "LB", "LC", "M", "MSP", "NN", "NP", "NR", "NT", "OD", "P", "PN", "PU", "SB", "SP", "VA", "VC", "VE", "VV"};
        Extractor[] newW = new Extractor[tagsets.length];
        for (int k = 0; k < tagsets.length; ++k) {
            newW[k] = new CtbPreDetector(tagsets[k], n);
        }
        return newW;
    }

    private static Extractor[] ctbSufFeatures(int n) {
        String[] tagsets = new String[]{"AD", "AS", "BA", "CC", "CD", "CS", "DEC", "DEG", "DER", "DEV", "DT", "ETC", "FW", "IJ", "JJ", "LB", "LC", "M", "MSP", "NN", "NP", "NR", "NT", "OD", "P", "PN", "PU", "SB", "SP", "VA", "VC", "VE", "VV"};
        Extractor[] newW = new Extractor[tagsets.length];
        for (int k = 0; k < tagsets.length; ++k) {
            newW[k] = new CtbSufDetector(tagsets[k], n);
        }
        return newW;
    }

    private static Extractor[] asbcUnkFeatures(int n) {
        String[] tagsets = new String[]{"A", "Caa", "Cab", "Cba", "Cbb", "D", "DE", "DK", "Da", "Dd", "De", "Des", "Dfa", "Dfb", "Di", "Dk", "FW", "I", " Na", "Nb", " Nc", "Ncb", "Ncd", " Nd", "Neaq", "Nep", "Neqa", "Neqb", "Nes", "Neu", "Nf", "Ng", "Nh", "P", "PU", "SHI", "T", "VA", "VAC", "VB", "VC", "VCL", "VD", "VE", "VF", "VG", "VH", "VHC", "VI", "VJ", "VK", "VL", "V_2"};
        Extractor[] newW = new Extractor[tagsets.length];
        for (int k = 0; k < tagsets.length; ++k) {
            newW[k] = new ASBCunkDetector(tagsets[k], n);
        }
        return newW;
    }

    private static Extractor[] ctbUnkDictFeatures(int n) {
        String[] tagsets = new String[]{"A", "Caa", "Cab", "Cba", "Cbb", "D", "DE", "DK", "Da", "Dd", "De", "Des", "Dfa", "Dfb", "Di", "Dk", "FW", "I", " Na", "Nb", " Nc", "Ncb", "Ncd", " Nd", "Neaq", "Nep", "Neqa", "Neqb", "Nes", "Neu", "Nf", "Ng", "Nh", "P", "PU", "SHI", "T", "VA", "VAC", "VB", "VC", "VCL", "VD", "VE", "VF", "VG", "VH", "VHC", "VI", "VJ", "VK", "VL", "V_2"};
        Extractor[] newW = new Extractor[tagsets.length];
        for (int k = 0; k < tagsets.length; ++k) {
            newW[k] = new CTBunkDictDetector(tagsets[k], n);
        }
        return newW;
    }
}

