/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import java.util.Map;

class IfExistsNode
extends TsurgeonPattern {
    final String name;
    final boolean invert;

    public IfExistsNode(String name, boolean invert, TsurgeonPattern ... children) {
        super("if " + (invert ? "not " : "") + "exists " + name, children);
        this.name = name;
        this.invert = invert;
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(IfExistsNode.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            if (IfExistsNode.this.invert ^ tregex.getNode(IfExistsNode.this.name) != null) {
                for (TsurgeonMatcher child : this.childMatcher) {
                    child.evaluate(tree, tregex);
                }
            }
            return tree;
        }
    }
}

