/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.DynamicAttributeNS;
import org.apache.tools.ant.DynamicElement;
import org.apache.tools.ant.DynamicElementNS;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.PreSetDef;
import org.apache.tools.ant.types.EnumeratedAttribute;

public final class IntrospectionHelper
implements BuildListener {
    private Hashtable attributeTypes = new Hashtable();
    private Hashtable attributeSetters = new Hashtable();
    private Hashtable nestedTypes = new Hashtable();
    private Hashtable nestedCreators = new Hashtable();
    private List addTypeMethods = new ArrayList();
    private Method addText = null;
    private Class bean;
    private static Hashtable helpers = new Hashtable();
    private static final Hashtable PRIMITIVE_TYPE_MAP = new Hashtable(8);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$TaskContainer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;
    static /* synthetic */ Class class$org$apache$tools$ant$Location;
    static /* synthetic */ Class class$org$apache$tools$ant$DynamicElement;
    static /* synthetic */ Class class$org$apache$tools$ant$DynamicElementNS;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$apache$tools$ant$types$EnumeratedAttribute;

    private IntrospectionHelper(Class bean) {
        this.bean = bean;
        Method[] methods = bean.getMethods();
        int i = 0;
        while (i < methods.length) {
            final Method m = methods[i];
            String name = m.getName();
            Class<?> returnType = m.getReturnType();
            Class<?>[] args = m.getParameterTypes();
            if (args.length == 1 && Void.TYPE.equals(returnType) && (name.equals("add") || name.equals("addConfigured"))) {
                this.insertAddTypeMethod(m);
            } else if (!((class$org$apache$tools$ant$Task == null ? IntrospectionHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).isAssignableFrom(bean) && args.length == 1 && this.isHiddenSetMethod(name, args[0]) || (class$org$apache$tools$ant$TaskContainer == null ? IntrospectionHelper.class$("org.apache.tools.ant.TaskContainer") : class$org$apache$tools$ant$TaskContainer).isAssignableFrom(bean) && args.length == 1 && "addTask".equals(name) && (class$org$apache$tools$ant$Task == null ? IntrospectionHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).equals(args[0]))) {
                String propName;
                Constructor<?> c;
                Constructor<?> constructor;
                String propName2;
                if ("addText".equals(name) && Void.TYPE.equals(returnType) && args.length == 1 && (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0])) {
                    this.addText = methods[i];
                } else if (name.startsWith("set") && Void.TYPE.equals(returnType) && args.length == 1 && !args[0].isArray()) {
                    AttributeSetter as;
                    propName2 = this.getPropertyName(name, "set");
                    if (!(this.attributeSetters.get(propName2) != null && (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) || (as = this.createAttributeSetter(m, args[0], propName2)) == null)) {
                        this.attributeTypes.put(propName2, args[0]);
                        this.attributeSetters.put(propName2, as);
                    }
                } else if (name.startsWith("create") && !returnType.isArray() && !returnType.isPrimitive() && args.length == 0) {
                    propName2 = this.getPropertyName(name, "create");
                    if (this.nestedCreators.get(propName2) == null) {
                        this.nestedTypes.put(propName2, returnType);
                        this.nestedCreators.put(propName2, new NestedCreator(){

                            public boolean isPolyMorphic() {
                                return false;
                            }

                            public Object getRealObject() {
                                return null;
                            }

                            public Class getElementClass() {
                                return null;
                            }

                            public Object create(Project project, Object parent, Object ignore) throws InvocationTargetException, IllegalAccessException {
                                return m.invoke(parent, new Object[0]);
                            }

                            public void store(Object parent, Object child) {
                            }
                        });
                    }
                } else if (name.startsWith("addConfigured") && Void.TYPE.equals(returnType) && args.length == 1 && !(class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) && !args[0].isArray() && !args[0].isPrimitive()) {
                    try {
                        constructor = null;
                        try {
                            constructor = args[0].getConstructor(new Class[0]);
                        }
                        catch (NoSuchMethodException ex) {
                            constructor = args[0].getConstructor(class$org$apache$tools$ant$Project == null ? IntrospectionHelper.class$("org.apache.tools.ant.Project") : class$org$apache$tools$ant$Project);
                        }
                        c = constructor;
                        propName = this.getPropertyName(name, "addConfigured");
                        this.nestedTypes.put(propName, args[0]);
                        this.nestedCreators.put(propName, new NestedCreator(){

                            public boolean isPolyMorphic() {
                                return true;
                            }

                            public Object getRealObject() {
                                return null;
                            }

                            public Class getElementClass() {
                                return c.getDeclaringClass();
                            }

                            public Object create(Project project, Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                                if (child == null) {
                                    child = c.getParameterTypes().length == 0 ? c.newInstance(new Object[0]) : c.newInstance(project);
                                }
                                if (child instanceof PreSetDef.PreSetDefinition) {
                                    child = ((PreSetDef.PreSetDefinition)child).createObject(project);
                                }
                                return child;
                            }

                            public void store(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                                m.invoke(parent, child);
                            }
                        });
                    }
                    catch (NoSuchMethodException nse) {}
                } else if (name.startsWith("add") && Void.TYPE.equals(returnType) && args.length == 1 && !(class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) && !args[0].isArray() && !args[0].isPrimitive()) {
                    try {
                        constructor = null;
                        try {
                            constructor = args[0].getConstructor(new Class[0]);
                        }
                        catch (NoSuchMethodException ex) {
                            constructor = args[0].getConstructor(class$org$apache$tools$ant$Project == null ? IntrospectionHelper.class$("org.apache.tools.ant.Project") : class$org$apache$tools$ant$Project);
                        }
                        c = constructor;
                        propName = this.getPropertyName(name, "add");
                        this.nestedTypes.put(propName, args[0]);
                        this.nestedCreators.put(propName, new NestedCreator(){

                            public boolean isPolyMorphic() {
                                return true;
                            }

                            public Object getRealObject() {
                                return null;
                            }

                            public Class getElementClass() {
                                return c.getDeclaringClass();
                            }

                            public Object create(Project project, Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                                if (child == null) {
                                    child = c.getParameterTypes().length == 0 ? c.newInstance(new Object[0]) : c.newInstance(project);
                                }
                                if (child instanceof PreSetDef.PreSetDefinition) {
                                    child = ((PreSetDef.PreSetDefinition)child).createObject(project);
                                }
                                m.invoke(parent, child);
                                return child;
                            }

                            public void store(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                            }
                        });
                    }
                    catch (NoSuchMethodException nse) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    private boolean isHiddenSetMethod(String name, Class type) {
        if ("setLocation".equals(name) && (class$org$apache$tools$ant$Location == null ? (class$org$apache$tools$ant$Location = IntrospectionHelper.class$("org.apache.tools.ant.Location")) : class$org$apache$tools$ant$Location).equals(type)) {
            return true;
        }
        return "setTaskType".equals(name) && (class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String).equals(type);
    }

    public static synchronized IntrospectionHelper getHelper(Class c) {
        IntrospectionHelper ih = (IntrospectionHelper)helpers.get(c);
        if (ih == null) {
            ih = new IntrospectionHelper(c);
            helpers.put(c, ih);
        }
        return ih;
    }

    public static synchronized IntrospectionHelper getHelper(Project p, Class c) {
        IntrospectionHelper ih = (IntrospectionHelper)helpers.get(c);
        if (ih == null) {
            ih = new IntrospectionHelper(c);
            helpers.put(c, ih);
            p.addBuildListener(ih);
        }
        return ih;
    }

    public void setAttribute(Project p, Object element, String attributeName, String value) throws BuildException {
        AttributeSetter as = (AttributeSetter)this.attributeSetters.get(attributeName.toLowerCase(Locale.US));
        if (as == null) {
            if (element instanceof DynamicAttributeNS) {
                DynamicAttributeNS dc = (DynamicAttributeNS)element;
                String uriPlusPrefix = ProjectHelper.extractUriFromComponentName(attributeName);
                String uri = ProjectHelper.extractUriFromComponentName(uriPlusPrefix);
                String localName = ProjectHelper.extractNameFromComponentName(attributeName);
                String qName = "".equals(uri) ? localName : uri + ":" + localName;
                dc.setDynamicAttribute(uri, localName, qName, value);
                return;
            }
            if (element instanceof DynamicAttribute) {
                DynamicAttribute dc = (DynamicAttribute)element;
                dc.setDynamicAttribute(attributeName.toLowerCase(Locale.US), value);
                return;
            }
            if (attributeName.indexOf(58) != -1) {
                return;
            }
            String msg = this.getElementName(p, element) + " doesn't support the \"" + attributeName + "\" attribute.";
            throw new BuildException(msg);
        }
        try {
            as.set(p, element, value);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public void addText(Project project, Object element, String text) throws BuildException {
        if (this.addText == null) {
            if (text.trim().length() == 0) {
                return;
            }
            String msg = project.getElementName(element) + " doesn't support nested text data.";
            throw new BuildException(msg);
        }
        try {
            this.addText.invoke(element, (Object[])new String[]{text});
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public void throwNotSupported(Project project, Object parent, String elementName) {
        String msg = project.getElementName(parent) + " doesn't support the nested \"" + elementName + "\" element.";
        throw new BuildException(msg);
    }

    private NestedCreator getNestedCreator(Project project, String parentUri, Object parent, String elementName, UnknownElement child) throws BuildException {
        Object nestedElement;
        String qName;
        Object dc;
        Object nestedElement2;
        String uri = ProjectHelper.extractUriFromComponentName(elementName);
        String name = ProjectHelper.extractNameFromComponentName(elementName);
        if (uri.equals("antlib:org.apache.tools.ant")) {
            uri = "";
        }
        if (parentUri.equals("antlib:org.apache.tools.ant")) {
            parentUri = "";
        }
        NestedCreator nc = null;
        if (uri.equals(parentUri) || uri.equals("")) {
            nc = (NestedCreator)this.nestedCreators.get(name.toLowerCase(Locale.US));
        }
        if (nc == null) {
            nc = this.createAddTypeCreator(project, parent, elementName);
        }
        if (nc == null && parent instanceof DynamicElementNS && (nestedElement2 = (dc = (DynamicElementNS)parent).createDynamicElement(child == null ? "" : child.getNamespace(), name, qName = child == null ? name : child.getQName())) != null) {
            nc = new NestedCreator(){

                public boolean isPolyMorphic() {
                    return false;
                }

                public Class getElementClass() {
                    return null;
                }

                public Object getRealObject() {
                    return null;
                }

                public Object create(Project project, Object parent, Object ignore) {
                    return nestedElement2;
                }

                public void store(Object parent, Object child) {
                }
            };
        }
        if (nc == null && parent instanceof DynamicElement && (nestedElement = (dc = (DynamicElement)parent).createDynamicElement(name.toLowerCase(Locale.US))) != null) {
            nc = new NestedCreator(){

                public boolean isPolyMorphic() {
                    return false;
                }

                public Class getElementClass() {
                    return null;
                }

                public Object getRealObject() {
                    return null;
                }

                public Object create(Project project, Object parent, Object ignore) {
                    return nestedElement;
                }

                public void store(Object parent, Object child) {
                }
            };
        }
        if (nc == null) {
            this.throwNotSupported(project, parent, elementName);
        }
        return nc;
    }

    public Object createElement(Project project, Object parent, String elementName) throws BuildException {
        NestedCreator nc = this.getNestedCreator(project, "", parent, elementName, null);
        try {
            Object nestedElement = nc.create(project, parent, null);
            if (project != null) {
                project.setProjectReference(nestedElement);
            }
            return nestedElement;
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InstantiationException ine) {
            throw new BuildException(ine);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public Creator getElementCreator(Project project, String parentUri, Object parent, String elementName, UnknownElement ue) {
        NestedCreator nc = this.getNestedCreator(project, parentUri, parent, elementName, ue);
        return new Creator(project, parent, nc);
    }

    public boolean supportsNestedElement(String elementName) {
        return this.nestedCreators.containsKey(elementName.toLowerCase(Locale.US)) || (class$org$apache$tools$ant$DynamicElement == null ? (class$org$apache$tools$ant$DynamicElement = IntrospectionHelper.class$("org.apache.tools.ant.DynamicElement")) : class$org$apache$tools$ant$DynamicElement).isAssignableFrom(this.bean) || (class$org$apache$tools$ant$DynamicElementNS == null ? (class$org$apache$tools$ant$DynamicElementNS = IntrospectionHelper.class$("org.apache.tools.ant.DynamicElementNS")) : class$org$apache$tools$ant$DynamicElementNS).isAssignableFrom(this.bean) || this.addTypeMethods.size() != 0;
    }

    public boolean supportsNestedElement(String parentUri, String elementName) {
        String name;
        String uri;
        if (parentUri.equals("antlib:org.apache.tools.ant")) {
            parentUri = "";
        }
        if ((uri = ProjectHelper.extractUriFromComponentName(elementName)).equals("antlib:org.apache.tools.ant")) {
            uri = "";
        }
        return this.nestedCreators.containsKey((name = ProjectHelper.extractNameFromComponentName(elementName)).toLowerCase(Locale.US)) && (uri.equals(parentUri) || uri.equals("")) || (class$org$apache$tools$ant$DynamicElement == null ? (class$org$apache$tools$ant$DynamicElement = IntrospectionHelper.class$("org.apache.tools.ant.DynamicElement")) : class$org$apache$tools$ant$DynamicElement).isAssignableFrom(this.bean) || (class$org$apache$tools$ant$DynamicElementNS == null ? (class$org$apache$tools$ant$DynamicElementNS = IntrospectionHelper.class$("org.apache.tools.ant.DynamicElementNS")) : class$org$apache$tools$ant$DynamicElementNS).isAssignableFrom(this.bean) || this.addTypeMethods.size() != 0;
    }

    public void storeElement(Project project, Object parent, Object child, String elementName) throws BuildException {
        if (elementName == null) {
            return;
        }
        NestedCreator ns = (NestedCreator)this.nestedCreators.get(elementName.toLowerCase(Locale.US));
        if (ns == null) {
            return;
        }
        try {
            ns.store(parent, child);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InstantiationException ine) {
            throw new BuildException(ine);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public Class getElementType(String elementName) throws BuildException {
        Class nt = (Class)this.nestedTypes.get(elementName);
        if (nt == null) {
            String msg = "Class " + this.bean.getName() + " doesn't support the nested \"" + elementName + "\" element.";
            throw new BuildException(msg);
        }
        return nt;
    }

    public Class getAttributeType(String attributeName) throws BuildException {
        Class at = (Class)this.attributeTypes.get(attributeName);
        if (at == null) {
            String msg = "Class " + this.bean.getName() + " doesn't support the \"" + attributeName + "\" attribute.";
            throw new BuildException(msg);
        }
        return at;
    }

    public boolean supportsCharacters() {
        return this.addText != null;
    }

    public Enumeration getAttributes() {
        return this.attributeSetters.keys();
    }

    public Enumeration getNestedElements() {
        return this.nestedTypes.keys();
    }

    private AttributeSetter createAttributeSetter(final Method m, Class arg, final String attrName) {
        boolean includeProject;
        Constructor c;
        Class reflectedArg;
        if ((class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String).equals(reflectedArg = PRIMITIVE_TYPE_MAP.containsKey(arg) ? (Class)PRIMITIVE_TYPE_MAP.get(arg) : arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new String[]{value});
                }
            };
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = IntrospectionHelper.class$("java.lang.Character")) : class$java$lang$Character).equals(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    if (value.length() == 0) {
                        throw new BuildException("The value \"\" is not a legal value for attribute \"" + attrName + "\"");
                    }
                    m.invoke(parent, (Object[])new Character[]{new Character(value.charAt(0))});
                }
            };
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntrospectionHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Boolean[]{Project.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE});
                }
            };
        }
        if ((class$java$lang$Class == null ? (class$java$lang$Class = IntrospectionHelper.class$("java.lang.Class")) : class$java$lang$Class).equals(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        m.invoke(parent, (Object[])new Class[]{Class.forName(value)});
                    }
                    catch (ClassNotFoundException ce) {
                        throw new BuildException(ce);
                    }
                }
            };
        }
        if ((class$java$io$File == null ? (class$java$io$File = IntrospectionHelper.class$("java.io.File")) : class$java$io$File).equals(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new File[]{p.resolveFile(value)});
                }
            };
        }
        if ((class$org$apache$tools$ant$types$EnumeratedAttribute == null ? (class$org$apache$tools$ant$types$EnumeratedAttribute = IntrospectionHelper.class$("org.apache.tools.ant.types.EnumeratedAttribute")) : class$org$apache$tools$ant$types$EnumeratedAttribute).isAssignableFrom(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        EnumeratedAttribute ea = (EnumeratedAttribute)reflectedArg.newInstance();
                        ea.setValue(value);
                        m.invoke(parent, (Object[])new EnumeratedAttribute[]{ea});
                    }
                    catch (InstantiationException ie) {
                        throw new BuildException(ie);
                    }
                }
            };
        }
        try {
            c = reflectedArg.getConstructor(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = IntrospectionHelper.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project, class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String);
            includeProject = true;
        }
        catch (NoSuchMethodException nme) {
            try {
                c = reflectedArg.getConstructor(class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String);
                includeProject = false;
            }
            catch (NoSuchMethodException nme2) {
                return null;
            }
        }
        final boolean finalIncludeProject = includeProject;
        final Constructor finalConstructor = c;
        return new AttributeSetter(){

            public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                try {
                    Object[] args = finalIncludeProject ? new Object[]{p, value} : new Object[]{value};
                    Object attribute = finalConstructor.newInstance(args);
                    if (p != null) {
                        p.setProjectReference(attribute);
                    }
                    m.invoke(parent, attribute);
                }
                catch (InstantiationException ie) {
                    throw new BuildException(ie);
                }
            }
        };
    }

    protected String getElementName(Project project, Object element) {
        return project.getElementName(element);
    }

    private String getPropertyName(String methodName, String prefix) {
        int start = prefix.length();
        return methodName.substring(start).toLowerCase(Locale.US);
    }

    public void buildFinished(BuildEvent event) {
        this.attributeTypes.clear();
        this.attributeSetters.clear();
        this.nestedTypes.clear();
        this.nestedCreators.clear();
        this.addText = null;
        helpers.clear();
    }

    public void buildStarted(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    private NestedCreator createAddTypeCreator(Project project, Object parent, String elementName) throws BuildException {
        if (this.addTypeMethods.size() == 0) {
            return null;
        }
        ComponentHelper helper = ComponentHelper.getComponentHelper(project);
        Object addedObject = null;
        Method addMethod = null;
        Class clazz = helper.getComponentClass(elementName);
        if (clazz == null) {
            return null;
        }
        addMethod = this.findMatchingMethod(clazz, this.addTypeMethods);
        if (addMethod == null) {
            return null;
        }
        addedObject = helper.createComponent(elementName);
        if (addedObject == null) {
            return null;
        }
        Object rObject = addedObject;
        if (addedObject instanceof PreSetDef.PreSetDefinition) {
            rObject = ((PreSetDef.PreSetDefinition)addedObject).createObject(project);
        }
        final Method method = addMethod;
        final Object nestedObject = addedObject;
        final Object realObject = rObject;
        return new NestedCreator(){

            public boolean isPolyMorphic() {
                return false;
            }

            public Class getElementClass() {
                return null;
            }

            public Object create(Project project, Object parent, Object ignore) throws InvocationTargetException, IllegalAccessException {
                if (!method.getName().endsWith("Configured")) {
                    method.invoke(parent, realObject);
                }
                return nestedObject;
            }

            public Object getRealObject() {
                return realObject;
            }

            public void store(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                if (method.getName().endsWith("Configured")) {
                    method.invoke(parent, realObject);
                }
            }
        };
    }

    private void insertAddTypeMethod(Method method) {
        Class<?> argClass = method.getParameterTypes()[0];
        int c = 0;
        while (c < this.addTypeMethods.size()) {
            Method current = (Method)this.addTypeMethods.get(c);
            if (current.getParameterTypes()[0].equals(argClass)) {
                return;
            }
            if (current.getParameterTypes()[0].isAssignableFrom(argClass)) {
                this.addTypeMethods.add(c, method);
                return;
            }
            ++c;
        }
        this.addTypeMethods.add(method);
    }

    private Method findMatchingMethod(Class paramClass, List methods) {
        Class<?> matchedClass = null;
        Method matchedMethod = null;
        int i = 0;
        while (i < methods.size()) {
            Method method = (Method)methods.get(i);
            Class<?> methodClass = method.getParameterTypes()[0];
            if (methodClass.isAssignableFrom(paramClass)) {
                if (matchedClass == null) {
                    matchedClass = methodClass;
                    matchedMethod = method;
                } else if (!methodClass.isAssignableFrom(matchedClass)) {
                    throw new BuildException("ambiguous: types " + matchedClass.getName() + " and " + methodClass.getName() + " match " + paramClass.getName());
                }
            }
            ++i;
        }
        return matchedMethod;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        Class[] wrappers = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntrospectionHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Byte == null ? (class$java$lang$Byte = IntrospectionHelper.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Character == null ? (class$java$lang$Character = IntrospectionHelper.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Short == null ? (class$java$lang$Short = IntrospectionHelper.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = IntrospectionHelper.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = IntrospectionHelper.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = IntrospectionHelper.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = IntrospectionHelper.class$("java.lang.Double")) : class$java$lang$Double};
        int i = 0;
        while (i < primitives.length) {
            PRIMITIVE_TYPE_MAP.put(primitives[i], wrappers[i]);
            ++i;
        }
    }

    private static interface AttributeSetter {
        public void set(Project var1, Object var2, String var3) throws InvocationTargetException, IllegalAccessException, BuildException;
    }

    private static interface NestedCreator {
        public boolean isPolyMorphic();

        public Class getElementClass();

        public Object getRealObject();

        public Object create(Project var1, Object var2, Object var3) throws InvocationTargetException, IllegalAccessException, InstantiationException;

        public void store(Object var1, Object var2) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }

    public static final class Creator {
        private NestedCreator nestedCreator;
        private Object parent;
        private Project project;
        private Object nestedObject;
        private String polyType;

        private Creator(Project project, Object parent, NestedCreator nestedCreator) {
            this.project = project;
            this.parent = parent;
            this.nestedCreator = nestedCreator;
        }

        public void setPolyType(String polyType) {
            this.polyType = polyType;
        }

        public Object create() {
            if (this.polyType != null) {
                if (!this.nestedCreator.isPolyMorphic()) {
                    throw new BuildException("Not allowed to use the polymorphic form for this element");
                }
                Class elementClass = this.nestedCreator.getElementClass();
                ComponentHelper helper = ComponentHelper.getComponentHelper(this.project);
                this.nestedObject = helper.createComponent(this.polyType);
                if (this.nestedObject == null) {
                    throw new BuildException("Unable to create object of type " + this.polyType);
                }
            }
            try {
                this.nestedObject = this.nestedCreator.create(this.project, this.parent, this.nestedObject);
                if (this.project != null) {
                    this.project.setProjectReference(this.nestedObject);
                }
                return this.nestedObject;
            }
            catch (IllegalAccessException ex) {
                throw new BuildException(ex);
            }
            catch (InstantiationException ex) {
                throw new BuildException(ex);
            }
            catch (IllegalArgumentException ex) {
                if (this.polyType != null) {
                    throw new BuildException("Invalid type used " + this.polyType);
                }
                throw ex;
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getTargetException();
                if (t instanceof BuildException) {
                    throw (BuildException)t;
                }
                throw new BuildException(t);
            }
        }

        public Object getRealObject() {
            return this.nestedCreator.getRealObject();
        }

        public void store() {
            try {
                this.nestedCreator.store(this.parent, this.nestedObject);
            }
            catch (IllegalAccessException ex) {
                throw new BuildException(ex);
            }
            catch (InstantiationException ex) {
                throw new BuildException(ex);
            }
            catch (IllegalArgumentException ex) {
                if (this.polyType != null) {
                    throw new BuildException("Invalid type used " + this.polyType);
                }
                throw ex;
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getTargetException();
                if (t instanceof BuildException) {
                    throw (BuildException)t;
                }
                throw new BuildException(t);
            }
        }
    }
}

