/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.properties.DefaultTaskProperties;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.execution.plan.FinalizerGroup;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.execution.plan.ResolveMutationsNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.service.ServiceRegistry;

public class LocalTaskNode
extends TaskNode {
    private final TaskInternal task;
    private final WorkValidationContext validationContext;
    private final ResolveMutationsNode resolveMutationsNode;
    private Set<Node> lifecycleSuccessors;
    private boolean isolated;
    private List<? extends ResourceLock> resourceLocks;
    private TaskProperties taskProperties;

    public LocalTaskNode(TaskInternal task, NodeValidator nodeValidator, WorkValidationContext workValidationContext) {
        this.task = task;
        this.validationContext = workValidationContext;
        this.resolveMutationsNode = new ResolveMutationsNode(this, nodeValidator);
    }

    public void isolated() {
        this.isolated = true;
    }

    public WorkValidationContext getValidationContext() {
        return this.validationContext;
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        if (this.isolated) {
            return null;
        }
        return ((ProjectInternal)this.task.getProject()).getOwner().getTaskExecutionLock();
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return (ProjectInternal)this.task.getProject();
    }

    @Override
    public List<? extends ResourceLock> getResourcesToLock() {
        if (this.resourceLocks == null) {
            this.resourceLocks = this.task.getSharedResources();
        }
        return this.resourceLocks;
    }

    @Override
    public TaskInternal getTask() {
        return this.task;
    }

    @Override
    public boolean isPublicNode() {
        return true;
    }

    @Override
    public boolean isCanCancel() {
        FinalizerGroup finalizerGroup = this.getFinalizerGroup();
        if (finalizerGroup != null) {
            for (Node node : finalizerGroup.getFinalizedNodes()) {
                if (!node.isExecuting() && !node.isExecuted()) continue;
                return false;
            }
        }
        return true;
    }

    public TaskProperties getTaskProperties() {
        return this.taskProperties;
    }

    @Override
    public Throwable getNodeFailure() {
        return this.task.getState().getFailure();
    }

    @Override
    public void prepareForExecution(Action<Node> monitor) {
        ((TaskContainerInternal)this.task.getProject().getTasks()).prepareForExecution(this.task);
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
        for (Node targetNode : this.getDependencies(dependencyResolver)) {
            this.addDependencySuccessor(targetNode);
        }
        this.lifecycleSuccessors = dependencyResolver.resolveDependenciesFor(this.task, this.task.getLifecycleDependencies());
        for (Node targetNode : this.getFinalizedBy(dependencyResolver)) {
            if (!(targetNode instanceof TaskNode)) {
                throw new IllegalStateException("Only tasks can be finalizers: " + targetNode);
            }
            this.addFinalizerNode((TaskNode)targetNode);
        }
        for (Node targetNode : this.getMustRunAfter(dependencyResolver)) {
            this.addMustSuccessor((TaskNode)targetNode);
        }
        for (Node targetNode : this.getShouldRunAfter(dependencyResolver)) {
            this.addShouldSuccessor(targetNode);
        }
    }

    private void addFinalizerNode(TaskNode finalizerNode) {
        this.deprecateLifecycleHookReferencingNonLocalTask("finalizedBy", finalizerNode);
        finalizerNode.addFinalizingSuccessor(this);
    }

    private Set<Node> getDependencies(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getTaskDependencies());
    }

    private Set<Node> getFinalizedBy(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getFinalizedBy());
    }

    private Set<Node> getMustRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getMustRunAfter());
    }

    private Set<Node> getShouldRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getShouldRunAfter());
    }

    @Override
    public int compareTo(Node other) {
        if (!(other instanceof LocalTaskNode)) {
            return -1;
        }
        LocalTaskNode localTask = (LocalTaskNode)other;
        return this.task.compareTo(localTask.task);
    }

    @Override
    public String toString() {
        return this.task.getIdentityPath().toString();
    }

    private void addOutputFilesToMutations(Set<OutputFilePropertySpec> outputFilePropertySpecs) {
        MutationInfo mutations = this.getMutationInfo();
        outputFilePropertySpecs.forEach(spec -> {
            File outputLocation = spec.getOutputFile();
            if (outputLocation != null) {
                mutations.outputPaths.add(outputLocation.getAbsolutePath());
            }
            mutations.hasOutputs = true;
        });
    }

    private void addLocalStateFilesToMutations(FileCollection localStateFiles) {
        MutationInfo mutations = this.getMutationInfo();
        localStateFiles.forEach(file -> {
            mutations.outputPaths.add(file.getAbsolutePath());
            mutations.hasLocalState = true;
        });
    }

    private void addDestroyablesToMutations(FileCollection destroyables) {
        destroyables.forEach(file -> this.getMutationInfo().destroyablePaths.add(file.getAbsolutePath()));
    }

    @Override
    public Node getPrepareNode() {
        return this.resolveMutationsNode;
    }

    public void resolveMutations() {
        LocalTaskNode taskNode = this;
        TaskInternal task = this.getTask();
        MutationInfo mutations = this.getMutationInfo();
        ProjectInternal project = (ProjectInternal)task.getProject();
        ServiceRegistry serviceRegistry = project.getServices();
        FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)serviceRegistry.get(FileCollectionFactory.class);
        PropertyWalker propertyWalker = (PropertyWalker)serviceRegistry.get(PropertyWalker.class);
        try {
            this.taskProperties = DefaultTaskProperties.resolve(propertyWalker, fileCollectionFactory, task);
            this.addOutputFilesToMutations((Set<OutputFilePropertySpec>)this.taskProperties.getOutputFileProperties());
            this.addLocalStateFilesToMutations(this.taskProperties.getLocalStateFiles());
            this.addDestroyablesToMutations(this.taskProperties.getDestroyableFiles());
            mutations.hasFileInputs = !this.taskProperties.getInputFileProperties().isEmpty();
        }
        catch (Exception e) {
            throw new TaskExecutionException(task, e);
        }
        if (!mutations.destroyablePaths.isEmpty()) {
            if (mutations.hasOutputs) {
                throw new IllegalStateException("Task " + taskNode + " has both outputs and destroyables defined.  A task can define either outputs or destroyables, but not both.");
            }
            if (mutations.hasFileInputs) {
                throw new IllegalStateException("Task " + taskNode + " has both inputs and destroyables defined.  A task can define either inputs or destroyables, but not both.");
            }
            if (mutations.hasLocalState) {
                throw new IllegalStateException("Task " + taskNode + " has both local state and destroyables defined.  A task can define either local state or destroyables, but not both.");
            }
        }
    }

    @Override
    public Set<Node> getLifecycleSuccessors() {
        return this.lifecycleSuccessors;
    }

    @Override
    public void setLifecycleSuccessors(Set<Node> lifecycleSuccessors) {
        this.lifecycleSuccessors = lifecycleSuccessors;
    }

    @Override
    protected boolean dependsOnOutcome(Node dependency) {
        return this.lifecycleSuccessors.contains(dependency);
    }
}

