/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import javax.annotation.Nullable;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.resources.ResourceLock;

public class ResolveMutationsNode
extends Node
implements SelfExecutingNode {
    private final LocalTaskNode node;
    private final NodeValidator nodeValidator;
    private Exception failure;

    public ResolveMutationsNode(LocalTaskNode node, NodeValidator nodeValidator) {
        this.node = node;
        this.nodeValidator = nodeValidator;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "Resolve mutations for " + this.node;
    }

    @Override
    public int compareTo(Node o) {
        return -1;
    }

    @Override
    @Nullable
    public Throwable getNodeFailure() {
        return this.failure;
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        return this.node.getProjectToLock();
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return this.node.getOwningProject();
    }

    @Override
    public void execute(NodeExecutionContext context) {
        try {
            MutationInfo mutations = this.node.getMutationInfo();
            this.node.resolveMutations();
            mutations.hasValidationProblem = this.nodeValidator.hasValidationProblems(this.node);
        }
        catch (Exception e) {
            this.failure = e;
        }
    }
}

