#import "WTFController.h"

@implementation WTFController

- (id)init
{
    if (self = [super init]) {
		acronyms = [NSMutableArray array];
		
		// Apply the defaults
		NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
		NSDictionary *appDefaults = [NSDictionary dictionaryWithObject:@"http://cvsweb.netbsd.org/bsdweb.cgi/~checkout~/src/share/misc/acronyms" forKey:@"acronymsURL"];
		[defaults registerDefaults:appDefaults];		
    }
    return self;
}

-(NSMutableArray *)parseAcronymsFromString:(NSString *)textToParse
{
	NSMutableArray *resultat = [NSMutableArray array];
	NSArray *lines = [textToParse componentsSeparatedByString:@"\n"];
	int i;
	for (i = 0; i < [lines count]; i++) {
		NSArray *parts = [[lines objectAtIndex:i] componentsSeparatedByString:@"\t"];
		if ([parts count] >= 2) {
			[resultat addObject:[NSMutableDictionary dictionaryWithObjectsAndKeys:[NSString stringWithString:[parts objectAtIndex:0]],@"acronym",[NSString stringWithString:[parts objectAtIndex:1]],@"translation",NULL]];
		}
	}
	
	return resultat;
}

-(void)awakeFromNib
{
	NSString *userAcronyms;
	
	[arrayController setContent:acronyms];
	
	// If the user didn't put his own acronyms yet, we use the provided acronyms file
	userAcronyms = [[NSUserDefaults standardUserDefaults] stringForKey:@"userAcronyms"];
	if (userAcronyms == nil) {
		path = [[NSBundle mainBundle] pathForResource:@"acronyms" ofType:nil];
		userAcronyms = [NSString stringWithContentsOfFile:path];		
	}
	
	[self addAcronyms:[self parseAcronymsFromString:userAcronyms]];
	
	[arrayController rearrangeObjects];
	[tableView selectRowIndexes:[NSIndexSet indexSetWithIndex:0] byExtendingSelection:FALSE];
	[tableView scrollRowToVisible:0];
}

// Takes a list of acronyms and adds the unique ones to the mainlist. Gives back the
// number of added acronyms
-(int)addAcronyms:(NSMutableArray *)newAcronyms {
	int counter = 0;
	NSEnumerator *acronymEnumerator = [newAcronyms objectEnumerator];
	NSMutableDictionary *newAcronym;
	
	while (newAcronym = [acronymEnumerator nextObject]) {
		if (![acronyms containsObject:newAcronym]) {
			counter++;
			[arrayController addObject:newAcronym];
		}
	}
	
	[arrayController rearrangeObjects];
	return counter;
}

-(IBAction)testMe:(id)sender {
	/*int resultat;
	
	path = [[NSBundle mainBundle] pathForResource:@"acronyms2" ofType:nil];
	NSString *fileContent = [NSString stringWithContentsOfFile:path];
	resultat = [self addAcronyms:[self parseAcronymsFromString:fileContent]];
	[arrayController rearrangeObjects];
	NSLog(@"Hinzugefgte Elemente: %d", resultat);*/
	//NSLog(@"Elemente: %d", [[arrayController arrangedObjects] count]);
	NSBeginInformationalAlertSheet(@"TITLE No Result Informational Alert Sheet", @"OK", nil, nil, listWindow, nil, nil, nil, nil, @"MSG No result found for this search");
}

// This is the method invoked if the user uses the "Lookup Acronym" service
- (void)searchService:(NSPasteboard *)pboard userData:(NSString *)userData error:(NSString **)error
{
    NSString *pboardString;
	NSArray *types;
    types = [pboard types];
	
    if (![types containsObject:NSStringPboardType]) {
        *error = NSLocalizedString(@"Error: couldn't search acronym.", @"pboard couldn't give string.");
        return;
    }
	
    pboardString = [pboard stringForType:NSStringPboardType];
	
    if (!pboardString) {
        *error = NSLocalizedString(@"Error: couldn't search acronym.", @"pboard couldn't give string.");
        return;
    }
	
	[arrayController searchForString:pboardString];
	int numberOfResults = [[arrayController arrangedObjects] count];
	if (numberOfResults == 0) {
		NSBeginInformationalAlertSheet(@"No result found", @"OK", nil, nil, listWindow, nil, nil, nil, nil, [NSString stringWithFormat:@"There was no acronym found including \"%@\"",pboardString]);
	}
}

// We fetch the acronyms from the URL in the preferences and add the unique ones to our list
- (IBAction)updateAcronymsFromInternet:(id)sender
{
	NSURL *acronymsURL = [NSURL URLWithString:[[NSUserDefaults standardUserDefaults] stringForKey:@"acronymsURL"]];
	NSString *fetchedAcronyms = [NSString stringWithContentsOfURL:acronymsURL];
	if ((fetchedAcronyms == nil) || ([fetchedAcronyms isEqual:@""])) {
		NSBeginAlertSheet(@"Couldn't download acronyms", @"OK", nil, nil, listWindow, nil, nil, nil, nil, @"There was a problem with the internet connection to fetch the new acronyms");
		return;
	}
	int numberOfAddedAcronyms = [self addAcronyms:[self parseAcronymsFromString:fetchedAcronyms]];
	if (numberOfAddedAcronyms > 0) {
		NSBeginAlertSheet(@"New acronyms added", @"OK", nil, nil, listWindow, nil, nil, nil, nil, [NSString stringWithFormat:@"There were %d new acronyms added to the list", numberOfAddedAcronyms]);
	} 
	else {
		NSBeginAlertSheet(@"No new acronyms found", @"OK", nil, nil, listWindow, nil, nil, nil, nil, @"There were no new acronyms to be found online");		
	}
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification {
	[NSApp setServicesProvider:self];
}

// Makes sure that the application finishes after the list window closes
- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication {
	return TRUE;
}

// Let's save the acronyms before we close, so we don't lose what the user entered
- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender {	
	NSMutableString *userAcronyms = [NSMutableString string];
	
	// Let's sort the acronyms so they will be in the right order when we start the program next time
	[acronyms sortUsingDescriptors:[NSArray arrayWithObject:[[NSSortDescriptor alloc] initWithKey:@"acronym" ascending:TRUE]]];
	
	NSEnumerator *acronymEnumerator = [acronyms objectEnumerator];
	NSMutableDictionary *newAcronym;
	
	
	while (newAcronym = [acronymEnumerator nextObject]) {
		[userAcronyms appendString:[NSString stringWithFormat:@"%@\t%@\n",[newAcronym valueForKey:@"acronym"],[newAcronym valueForKey:@"translation"]]];
	}
	
	[[NSUserDefaults standardUserDefaults] setObject:userAcronyms forKey:@"userAcronyms"];
	
	return YES;
}

@end
