/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ta extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CNH = "CNH";
        final Object[][] data = new Object[][] {
            { "mwk", "\u0bae\u0bb2\u0bbe\u0bb5\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bc1\u0bb5\u0bbe\u0b9a\u0bcd\u0b9a\u0bbe" },
            { "FJD", "FJD" },
            { "STD", "STD" },
            { "LVL", "LVL" },
            { "SCR", "SCR" },
            { "CDF", "CDF" },
            { "BBD", "BBD" },
            { "mga", "\u0bae\u0bb2\u0b95\u0bbe\u0b9a\u0bbf \u0b8f\u0bb0\u0bbf\u0baf\u0bb0\u0bbf" },
            { "HNL", "HNL" },
            { "UGX", "UGX" },
            { "ZAR", "ZAR" },
            { "bam", "\u0baa\u0bcb\u0bb8\u0bcd\u0ba9\u0bbf\u0baf\u0bbe-\u0bb9\u0bc6\u0bb0\u0bcd\u0bb8\u0bc7\u0b95\u0bcb\u0bb5\u0bbf\u0ba9\u0bbe \u0b95\u0ba9\u0bcd\u0bb5\u0bc6\u0bb0\u0bcd\u0b9f\u0bbf\u0baa\u0bbf\u0bb2\u0bcd \u0bae\u0bbe\u0bb0\u0bcd\u0b95\u0bcd" },
            { "egp", "\u0b8e\u0b95\u0bbf\u0baa\u0bcd\u0ba4\u0bbf\u0baf \u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bc1" },
            { "CUC", "CUC" },
            { "ssp", "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b9a\u0bc2\u0b9f\u0bbe\u0ba9\u0bc0\u0bb8\u0bcd \u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bc1" },
            { "BSD", "BSD" },
            { "nio", "\u0ba8\u0bbf\u0b95\u0bb0\u0b95\u0bc1\u0bb5\u0ba9\u0bcd \u0b95\u0bcb\u0bb0\u0bcd\u0b9f\u0bcb\u0baa\u0bbe" },
            { "SDG", "SDG" },
            { "nzd", "\u0ba8\u0bbf\u0baf\u0bc2\u0b9a\u0bbf\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "IQD", "IQD" },
            { "brl", "\u0baa\u0bbf\u0bb0\u0bc7\u0b9a\u0bbf\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0bb0\u0bbf\u0baf\u0bbe\u0bb2\u0bcd" },
            { "CUP", "CUP" },
            { "GMD", "GMD" },
            { "fjd", "\u0b83\u0baa\u0bbf\u0b9c\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "RSD", "RSD" },
            { "mxn", "\u0bae\u0bc6\u0b95\u0bcd\u0bb8\u0bbf\u0b95\u0ba9\u0bcd \u0baa\u0bc6\u0b9a\u0bcb" },
            { "std", "\u0b9a\u0bbe\u0bb5\u0bcd \u0b9f\u0bcb\u0bae\u0bbf \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0baa\u0bbf\u0bb0\u0bbf\u0ba9\u0bcd\u0bb8\u0bcd\u0baa\u0bbf \u0b9f\u0bcb\u0baa\u0bcd\u0bb0\u0bbe (1977\u20132017)" },
            { "lvl", "\u0bb2\u0ba4\u0bcd\u0bb5\u0bbf\u0baf\u0ba9\u0bcd \u0bb2\u0bbe\u0b9f\u0bcd\u0bb8\u0bcd" },
            { "scr", "\u0b9a\u0bbf\u0b9a\u0bc0\u0bb2\u0bcb\u0baf\u0bbf\u0bb8\u0bcd \u0bb0\u0bc1\u0baa\u0bc0" },
            { "cdf", "\u0b95\u0bbe\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bc0\u0bb8\u0bcd \u0b83\u0baa\u0bcd\u0bb0\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "bbd", "\u0baa\u0bbe\u0bb0\u0bcd\u0baa\u0bc7\u0b9f\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "MYR", "MYR" },
            { "hnl", "\u0bb9\u0bcb\u0ba9\u0bcd\u0b9f\u0bc2\u0bb0\u0ba9\u0bcd \u0bb2\u0bc6\u0bae\u0bcd\u0baa\u0bc0\u0bb0\u0bbe" },
            { "ugx", "\u0b89\u0b95\u0bbe\u0ba3\u0bcd\u0b9f\u0ba9\u0bcd \u0bb7\u0bbf\u0bb2\u0bcd\u0bb2\u0bbf\u0b99\u0bcd" },
            { "FKP", "FKP" },
            { "zar", "\u0ba4\u0bc6\u0ba9\u0bcd \u0b86\u0baa\u0bcd\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0bb0\u0bbe\u0ba3\u0bcd\u0b9f\u0bcd" },
            { "stn", "\u0b9a\u0bbe\u0bb5\u0bcd \u0b9f\u0bcb\u0bae\u0bbf \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0baa\u0bbf\u0bb0\u0bbf\u0ba9\u0bcd\u0bb8\u0bcd\u0baa\u0bbf \u0b9f\u0bcb\u0baa\u0bcd\u0bb0\u0bbe" },
            { "UYU", "UYU" },
            { "cuc", "\u0b95\u0bbf\u0baf\u0bc2\u0baa\u0ba9\u0bcd \u0b95\u0ba9\u0bcd\u0bb5\u0bc6\u0bb0\u0bcd\u0b9f\u0bbf\u0baa\u0bbf\u0bb2\u0bcd \u0baa\u0bc6\u0b9a\u0bcb" },
            { "bsd", "\u0baa\u0bb9\u0bbe\u0bae\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "CVE", "CVE" },
            { "OMR", "OMR" },
            { "sdg", "\u0b9a\u0bc2\u0b9f\u0bbe\u0ba9\u0bc0\u0bb8\u0bcd \u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bc1" },
            { "KES", "KES" },
            { "SEK", "SEK" },
            { "BTN", "BTN" },
            { "iqd", "\u0b88\u0bb0\u0bbe\u0b95\u0bcd\u0b95\u0bbf \u0ba4\u0bbf\u0ba9\u0bbe\u0bb0\u0bcd" },
            { "GNF", "GNF" },
            { "cup", "\u0b95\u0bbf\u0baf\u0bc2\u0baa\u0ba9\u0bcd \u0baa\u0bc6\u0b9a\u0bcb" },
            { "gmd", "\u0b95\u0bc7\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0ba4\u0bb2\u0bbe\u0b9a\u0bbf" },
            { "MZN", "MZN" },
            { "twd", "\u0baa\u0bc1\u0ba4\u0bbf\u0baf \u0ba4\u0bc8\u0bb5\u0bbe\u0ba9\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "ARS", "ARS" },
            { "rsd", "\u0b9a\u0bc6\u0bb0\u0bcd\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0ba4\u0bbf\u0ba9\u0bbe\u0bb0\u0bcd" },
            { "QAR", "QAR" },
            { "myr", "\u0bae\u0bb2\u0bc7\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0bb0\u0bbf\u0b99\u0bcd\u0b95\u0bbf\u0b9f\u0bcd" },
            { "IRR", "IRR" },
            { "fkp", "\u0b83\u0baa\u0bbe\u0b95\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bc1" },
            { "xof", "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b86\u0baa\u0bcd\u0baa\u0bbf\u0bb0\u0bbf\u0b95\u0bcd\u0b95 CFA \u0b83\u0baa\u0bcd\u0bb0\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "THB", "\u0e3f" },
            { "UZS", "UZS" },
            { "uyu", "\u0b89\u0bb0\u0bc1\u0b95\u0bc1\u0bb5\u0bc7\u0baf\u0ba9\u0bcd \u0baa\u0bc6\u0b9a\u0bcb" },
            { "BDT", "BDT" },
            { "cve", "\u0b95\u0bc7\u0baa\u0bcd \u0bb5\u0bc6\u0bb0\u0bcd\u0b9f\u0bbf\u0baf\u0ba9\u0bcd \u0b8e\u0bb8\u0bcd\u0b95\u0bc1\u0b9f\u0bcb" },
            { "omr", "\u0b93\u0bae\u0bbe\u0ba9\u0bbf \u0bb0\u0bbf\u0baf\u0bbe\u0bb2\u0bcd" },
            { "LYD", "LYD" },
            { "kes", "\u0b95\u0bc6\u0ba9\u0bcd\u0baf\u0ba9\u0bcd \u0bb7\u0bbf\u0bb2\u0bcd\u0bb2\u0bbf\u0b99\u0bcd" },
            { "sek", "\u0bb8\u0bcd\u0bb5\u0bc0\u0b9f\u0bbf\u0bb7\u0bcd \u0b95\u0bcd\u0bb0\u0bcb\u0ba9\u0bbe" },
            { "KWD", "KWD" },
            { "btn", "\u0baa\u0bc2\u0b9f\u0bcd\u0b9f\u0bbe\u0ba9\u0bc0\u0bb8\u0bcd \u0b95\u0bc1\u0bb2\u0bcd\u0b9f\u0bcd\u0bb0\u0bae\u0bcd" },
            { "RUB", "RUB" },
            { "gnf", "\u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0b83\u0baa\u0bcd\u0bb0\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "ISK", "ISK" },
            { "mzn", "\u0bae\u0bca\u0b9a\u0bbe\u0bae\u0bcd\u0baa\u0bbf\u0b95\u0ba9\u0bcd \u0bae\u0bc6\u0b9f\u0bbf\u0b95\u0bb2\u0bcd" },
            { "ars", "\u0b85\u0bb0\u0bcd\u0b9c\u0bc6\u0ba9\u0bcd\u0b9f\u0bc8\u0ba9\u0bcd \u0baa\u0bc6\u0b9a\u0bcb" },
            { "qar", "\u0b95\u0ba4\u0bcd\u0ba4\u0bbe\u0bb0\u0bbf \u0bb0\u0bbf\u0baf\u0bbe\u0bb2\u0bcd" },
            { "MKD", "MKD" },
            { "irr", "\u0b88\u0bb0\u0bbe\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0bb0\u0bbf\u0baf\u0bbe\u0bb2\u0bcd" },
            { "DZD", "DZD" },
            { "thb", "\u0ba4\u0bbe\u0baf\u0bcd \u0baa\u0bbe\u0b9f\u0bcd" },
            { "uzs", "\u0b89\u0bb8\u0bcd\u0baa\u0bc6\u0b95\u0bcd\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bbf \u0b9a\u0bcb\u0bae\u0bcd" },
            { "xpf", "\u0b83\u0baa\u0bcd\u0bb0\u0bbe\u0b99\u0bcd\u0b95\u0bcd (CFP)" },
            { "PAB", "PAB" },
            { "SGD", "SGD" },
            { "bdt", "\u0baa\u0b99\u0bcd\u0b95\u0bb3\u0bbe\u0ba4\u0bc7\u0bb7\u0bbf \u0b9f\u0bbe\u0b95\u0bbe" },
            { "KGS", "KGS" },
            { "lyd", "\u0bb2\u0bbf\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0ba4\u0bbf\u0ba9\u0bbe\u0bb0\u0bcd" },
            { "kwd", "\u0b95\u0bc1\u0bb5\u0bc8\u0ba4\u0bcd\u0ba4\u0bbf \u0ba4\u0bbf\u0ba9\u0bbe\u0bb0\u0bcd" },
            { "rub", "\u0bb0\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0bb0\u0bc2\u0baa\u0bbf\u0bb3\u0bcd" },
            { "CHF", "CHF" },
            { "HRK", "HRK" },
            { "isk", "\u0b90\u0bb8\u0bcd\u0bb2\u0bbe\u0ba3\u0bcd\u0b9f\u0bbf\u0b95\u0bcd \u0b95\u0bcd\u0bb0\u0bcb\u0ba9\u0bbe" },
            { "DJF", "DJF" },
            { "mkd", "\u0bae\u0bbe\u0b9a\u0bbf\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bc7\u0ba9\u0bbe\u0bb0\u0bcd" },
            { "TZS", "TZS" },
            { "dzd", "\u0b85\u0bb2\u0bcd\u0b9c\u0bc0\u0bb0\u0bbf\u0baf\u0ba9\u0bcd \u0ba4\u0bbf\u0ba9\u0bbe\u0bb0\u0bcd" },
            { "pab", "\u0baa\u0ba9\u0bbe\u0bae\u0bbe\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0baa\u0bbe\u0bb2\u0bcd\u0baa\u0bcb\u0bb5\u0bbe" },
            { "sgd", "\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "KHR", "KHR" },
            { "IDR", "IDR" },
            { "kgs", "\u0b95\u0bbf\u0bb0\u0bcd\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bbf \u0b9a\u0bcb\u0bae\u0bcd" },
            { "KYD", "KYD" },
            { "BWP", "BWP" },
            { "SHP", "SHP" },
            { "TJS", "TJS" },
            { "xaf", "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b86\u0baa\u0bcd\u0baa\u0bbf\u0bb0\u0bbf\u0b95\u0bcd\u0b95 CFA \u0b83\u0baa\u0bcd\u0bb0\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "AED", "AED" },
            { "RWF", "RWF" },
            { "chf", "\u0b9a\u0bc1\u0bb5\u0bbf\u0bb8\u0bcd \u0b83\u0baa\u0bcd\u0bb0\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "hrk", "\u0b95\u0bc1\u0bb0\u0bcb\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bc1\u0ba9\u0bbe" },
            { "djf", "\u0b9c\u0bbf\u0baa\u0bb5\u0bcd\u0b9f\u0bbf\u0baf\u0bc6\u0ba9\u0bcd \u0b83\u0baa\u0bcd\u0bb0\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "DKK", "DKK" },
            { "BGN", "BGN" },
            { "MMK", "MMK" },
            { "NOK", "NOK" },
            { "SYP", "SYP" },
            { "tzs", "\u0ba4\u0bbe\u0ba9\u0bcd\u0b9a\u0bbe\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0bb7\u0bbf\u0bb2\u0bcd\u0bb2\u0bbf\u0b99\u0bcd" },
            { "vnd", "\u0bb5\u0bbf\u0baf\u0b9f\u0bcd\u0ba8\u0bbe\u0bae\u0bc0\u0bb8\u0bcd \u0b9f\u0bbe\u0b99\u0bcd" },
            { "aud", "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "LKR", "LKR" },
            { "khr", "\u0b95\u0bae\u0bcd\u0baa\u0bcb\u0b9f\u0bbf\u0baf\u0ba9\u0bcd \u0bb0\u0bbf\u0baf\u0bc6\u0bb2\u0bcd" },
            { "CZK", "CZK" },
            { "idr", "\u0b87\u0ba8\u0bcd\u0ba4\u0bcb\u0ba9\u0bc7\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0bb0\u0bc1\u0baa\u0bbf\u0baf\u0bbe" },
            { "kyd", "\u0b95\u0bc7\u0bae\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "HTG", "HTG" },
            { "bwp", "\u0baa\u0bcb\u0b9f\u0bcd\u0bb8\u0bcd\u0bb5\u0bbe\u0ba9\u0ba9\u0bcd \u0baa\u0bc1\u0bb2\u0bbe" },
            { "shp", "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0bb9\u0bc6\u0bb2\u0bc7\u0ba9\u0bbe \u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bc1" },
            { "tjs", "\u0ba4\u0b9c\u0bbf\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bbf \u0b9a\u0bcb\u0bae\u0bcb\u0ba9\u0bbf" },
            { "BHD", "BHD" },
            { "rwf", "\u0bb0\u0bc1\u0bb5\u0bbe\u0ba3\u0bcd\u0b9f\u0ba9\u0bcd \u0b83\u0baa\u0bcd\u0bb0\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "aed", "\u0b90\u0b95\u0bcd\u0b95\u0bbf\u0baf \u0b85\u0bb0\u0baa\u0bc1 \u0b8e\u0bae\u0bbf\u0bb0\u0bc7\u0b9f\u0bcd\u0bb8\u0bcd \u0ba4\u0bbf\u0bb0\u0bcd\u0bb9\u0bbe\u0bae\u0bcd" },
            { "KZT", "KZT" },
            { "SZL", "SZL" },
            { "dkk", "\u0b9f\u0bc7\u0ba9\u0bbf\u0bb7\u0bcd \u0b95\u0bcd\u0bb0\u0bcb\u0ba9\u0bcd" },
            { "YER", "YER" },
            { "bgn", "\u0baa\u0bb2\u0bcd\u0b95\u0bc7\u0bb0\u0bbf\u0baf\u0ba9\u0bcd \u0bb2\u0bc7\u0bb5\u0bcd" },
            { "AFN", "AFN" },
            { "mmk", "\u0bae\u0bbf\u0baf\u0bbe\u0ba9\u0bcd\u0bae\u0bb0\u0bcd \u0b95\u0bbf\u0baf\u0bbe\u0ba4\u0bcd" },
            { "nok", "\u0ba8\u0bbe\u0bb0\u0bcd\u0bb5\u0bc7\u0b9c\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bcd\u0bb0\u0bcb\u0ba9\u0bcd" },
            { "syp", "\u0b9a\u0bbf\u0bb0\u0bbf\u0baf\u0ba9\u0bcd \u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bc1" },
            { "AWG", "AWG" },
            { "NPR", "NPR" },
            { "MNT", "MNT" },
            { "lkr", "\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8 \u0bb0\u0bc2\u0baa\u0bbe\u0baf\u0bcd" },
            { "czk", "\u0b9a\u0bc6\u0b95\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1 \u0b95\u0bca\u0bb0\u0bc1\u0ba9\u0bbe" },
            { "BYN", "BYN" },
            { "HUF", "HUF" },
            { "xcd", "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b95\u0bb0\u0bc0\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "BYR", "BYR" },
            { "htg", "\u0bb9\u0bc8\u0b9f\u0bcd\u0b9f\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bcb\u0bb0\u0bcd\u0b9f\u0bc7" },
            { "BIF", "BIF" },
            { "bhd", "\u0baa\u0bb9\u0bcd\u0bb0\u0bc8\u0ba9\u0bbf \u0ba4\u0bbf\u0ba9\u0bbe\u0bb0\u0bcd" },
            { "kzt", "\u0b95\u0bb8\u0b95\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bbf \u0b9f\u0bc6\u0ba9\u0bcd\u0b95\u0bc7" },
            { "szl", "\u0b9a\u0bc1\u0bb5\u0bbe\u0bb8\u0bbf \u0bb2\u0bbf\u0bb2\u0bbe\u0b99\u0bcd\u0b95\u0ba9\u0bbf" },
            { "yer", "\u0b8f\u0bae\u0ba9\u0bbf \u0bb0\u0bbf\u0baf\u0bbe\u0bb2\u0bcd" },
            { "afn", "\u0b86\u0b83\u0baa\u0bcd\u0b95\u0bbe\u0ba9\u0bcd \u0b86\u0b83\u0baa\u0bcd\u0b95\u0bbe\u0ba9\u0bbf" },
            { "BZD", "BZD" },
            { "MOP", "MOP" },
            { "NAD", "NAD" },
            { "awg", "\u0b85\u0bb0\u0bc1\u0baa\u0ba9\u0bcd \u0b83\u0baa\u0bcd\u0bb3\u0bcb\u0bb0\u0bbf\u0ba9\u0bcd" },
            { "npr", "\u0ba8\u0bc7\u0baa\u0bbe\u0bb3\u0bc0\u0bb8\u0bcd \u0bb0\u0bc2\u0baa\u0bbe\u0baf\u0bcd" },
            { "mnt", "\u0bae\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bc1\u0b95\u0bcd\u0bb0\u0bbf\u0b95\u0bcd" },
            { "gbp", "\u0baa\u0bbf\u0bb0\u0bbf\u0b9f\u0bcd\u0b9f\u0bbf\u0bb7\u0bcd \u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bc1" },
            { "byn", "\u0baa\u0bc6\u0bb2\u0bb0\u0bc1\u0b9a\u0bbf\u0baf\u0ba9\u0bcd \u0bb0\u0bc2\u0baa\u0bbf\u0bb3\u0bcd" },
            { "PEN", "PEN" },
            { "huf", "\u0bb9\u0b99\u0bcd\u0b95\u0bc7\u0bb0\u0bbf\u0baf\u0ba9\u0bcd \u0b83\u0baa\u0bcb\u0bb0\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd" },
            { "WST", "WST" },
            { "TMT", "TMT" },
            { "byr", "\u0baa\u0bc6\u0bb2\u0bb0\u0bc1\u0b9a\u0bbf\u0baf\u0ba9\u0bcd \u0bb0\u0bc2\u0baa\u0bbf\u0bb3\u0bcd (2000\u20132016)" },
            { "bif", "\u0baa\u0bc1\u0bb0\u0bc1\u0ba3\u0bcd\u0b9f\u0bbf\u0baf\u0ba9\u0bcd \u0b83\u0baa\u0bcd\u0bb0\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "GTQ", "GTQ" },
            { "CLP", "CLP" },
            { "TND", "TND" },
            { "bzd", "\u0baa\u0bc6\u0bb2\u0bc0\u0bb8\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "mop", "\u0bae\u0bc6\u0b95\u0ba9\u0bc0\u0bb8\u0bcd \u0baa\u0b9f\u0bbe\u0b95\u0bbe" },
            { "nad", "\u0ba8\u0bae\u0bc0\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "SLL", "SLL" },
            { "pen", "\u0baa\u0bc6\u0bb0\u0bc2\u0bb5\u0bbf\u0baf\u0ba9\u0bcd \u0b9a\u0bcb\u0bb2\u0bcd" },
            { "wst", "\u0b9a\u0bae\u0bcb\u0bb5\u0bbe\u0ba9\u0bcd \u0ba4\u0bbe\u0bb2\u0bbe" },
            { "tmt", "\u0ba4\u0bc1\u0bb0\u0bcd\u0b95\u0bcd\u0bae\u0bc6\u0ba9\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bbf \u0bae\u0ba9\u0ba4\u0bcd" },
            { "DOP", "DOP" },
            { "KMF", "KMF" },
            { "gtq", "\u0b95\u0bc1\u0bb5\u0bbe\u0ba4\u0bc6\u0bae\u0bbe\u0bb2\u0ba9\u0bcd \u0b95\u0bcd\u0baf\u0bc1\u0b9f\u0bcd\u0bb8\u0bb2\u0bcd" },
            { "clp", "\u0b9a\u0bbf\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0baa\u0bc6\u0b9a\u0bcb" },
            { "tnd", "\u0ba4\u0bc1\u0ba9\u0bbf\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0ba4\u0bbf\u0ba9\u0bbe\u0bb0\u0bcd" },
            { "GEL", "GEL" },
            { "MAD", "MAD" },
            { "sll", "\u0b9a\u0bbf\u0baf\u0bbe\u0bb0\u0bbe \u0bb2\u0bbf\u0baf\u0bcb\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0bb2\u0bbf\u0baf\u0bcb\u0ba9\u0bcd" },
            { "TOP", "TOP" },
            { "AZN", "AZN" },
            { "PGK", "PGK" },
            { "CNH", metaValue_CNH },
            { "UAH", "UAH" },
            { "ERN", "ERN" },
            { "dop", "\u0b9f\u0bca\u0bae\u0bbf\u0ba9\u0bbf\u0b95\u0bcd\u0b95\u0ba9\u0bcd \u0baa\u0bc6\u0b9a\u0bcb" },
            { "kmf", "\u0b95\u0bae\u0bcb\u0bb0\u0bbf\u0baf\u0ba9\u0bcd \u0b83\u0baa\u0bcd\u0bb0\u0bbe\u0b99\u0bcd\u0b95\u0bcd" },
            { "MRO", "MRO" },
            { "gel", "\u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0ba9\u0bcd \u0bb2\u0bbe\u0bb0\u0bbf" },
            { "mad", "\u0bae\u0bca\u0bb0\u0bbe\u0b95\u0bcd\u0b95\u0ba9\u0bcd \u0ba4\u0bbf\u0bb0\u0bcd\u0bb9\u0bbe\u0bae\u0bcd" },
            { "azn", "\u0b85\u0b9a\u0bb0\u0bcd\u0baa\u0bc8\u0b9c\u0bbe\u0ba9\u0bbf \u0bae\u0ba9\u0ba4\u0bcd" },
            { "top", "\u0ba4\u0bca\u0b99\u0bcd\u0b95\u0bbe\u0ba9\u0bcd \u0baa\u0b99\u0bcd\u0b95\u0bbe" },
            { "pgk", "\u0baa\u0baa\u0bc1\u0bb5\u0bbe \u0ba8\u0bbf\u0baf\u0bc2 \u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bbf\u0ba9\u0bbe" },
            { "BMD", "BMD" },
            { "PHP", "PHP" },
            { "cnh", metaValue_CNH },
            { "uah", "\u0b89\u0b95\u0bcd\u0bb0\u0bc8\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0bb9\u0bbf\u0bb0\u0bc8\u0bb5\u0bcd\u0ba9\u0bbf\u0baf\u0bbe" },
            { "PYG", "PYG" },
            { "JMD", "JMD" },
            { "ern", "\u0b8e\u0bb0\u0bbf\u0ba4\u0bcd\u0bb0\u0bbf\u0baf\u0ba9\u0bcd \u0ba8\u0b95\u0bcd\u0b83\u0baa\u0bbe" },
            { "COP", "COP" },
            { "USD", "$" },
            { "mro", "\u0bae\u0bca\u0bb0\u0bbf\u0bb7\u0bbe\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0b92\u0b95\u0bc1\u0baf\u0bbe (1973\u20132017)" },
            { "cny", "\u0b9a\u0bc0\u0ba9 \u0baf\u0bc1\u0bb5\u0bbe\u0ba9\u0bcd" },
            { "mru", "\u0bae\u0bca\u0bb0\u0bbf\u0bb7\u0bbe\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0b92\u0b95\u0bc1\u0baf\u0bbe" },
            { "ETB", "ETB" },
            { "SOS", "SOS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "LAK", "LAK" },
            { "bmd", "\u0baa\u0bc6\u0bb0\u0bcd\u0bae\u0bc1\u0b9f\u0ba9\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "BND", "BND" },
            { "php", "\u0baa\u0bbf\u0bb2\u0bbf\u0baa\u0bcd\u0baa\u0bc8\u0ba9\u0bcd \u0baa\u0bc6\u0b9a\u0bcb" },
            { "xxx", "\u0ba4\u0bc6\u0bb0\u0bbf\u0baf\u0bbe\u0ba4 \u0ba8\u0bbe\u0ba3\u0baf\u0bae\u0bcd" },
            { "LRD", "LRD" },
            { "pyg", "\u0baa\u0bb0\u0bbe\u0b95\u0bc1\u0bb5\u0ba9\u0bcd \u0b95\u0bc1\u0bb5\u0bbe\u0bb0\u0bbe\u0ba9\u0bbf" },
            { "jmd", "\u0b9c\u0bae\u0bc8\u0b95\u0bcd\u0b95\u0ba9\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "ALL", "ALL" },
            { "ZMW", "ZMW" },
            { "cop", "\u0b95\u0bca\u0bb2\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0baa\u0bc6\u0b9a\u0bcb" },
            { "usd", "\u0b85\u0bae\u0bc6\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "etb", "\u0b8e\u0ba4\u0bcd\u0ba4\u0bbf\u0baf\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0baa\u0bbf\u0bb0\u0bcd" },
            { "GHS", "GHS" },
            { "GYD", "GYD" },
            { "KPW", "KPW" },
            { "BOB", "BOB" },
            { "MDL", "MDL" },
            { "sos", "\u0b9a\u0bcb\u0bae\u0bbe\u0bb2\u0bbf \u0bb7\u0bbf\u0bb2\u0bcd\u0bb2\u0bbf\u0b99\u0bcd" },
            { "vef", "\u0bb5\u0bc6\u0ba9\u0bbf\u0b9a\u0bc1\u0bb2\u0ba9\u0bcd \u0baa\u0bcb\u0bb2\u0bbf\u0bb5\u0bb0\u0bcd" },
            { "vuv", "\u0bb5\u0ba9\u0bc1\u0bb5\u0bbe\u0b9f\u0bcd\u0b9f\u0bc1 \u0bb5\u0bbe\u0b9f\u0bcd\u0b9f\u0bc1" },
            { "lak", "\u0bb2\u0bb5\u0bcb\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bbf\u0baa\u0bcd" },
            { "AMD", "AMD" },
            { "bnd", "\u0baa\u0bc1\u0bb0\u0bc2\u0ba9\u0bc7 \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "zmk", "\u0bb8\u0bbe\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bc1\u0bb5\u0bbe\u0b9a\u0bbe (1968\u20132012)" },
            { "TRY", "TRY" },
            { "LBP", "LBP" },
            { "JOD", "JOD" },
            { "lrd", "\u0bb2\u0bc8\u0baa\u0bc0\u0bb0\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "all", "\u0b85\u0bb2\u0bcd\u0baa\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0bb2\u0bc6\u0b95\u0bcd" },
            { "zmw", "\u0bb8\u0bbe\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bc1\u0bb5\u0bbe\u0b9a\u0bcd\u0b9a\u0bbe" },
            { "MUR", "MUR" },
            { "GIP", "GIP" },
            { "RON", "RON" },
            { "ils", "\u0b87\u0bb8\u0bcd\u0bb0\u0bc7\u0bb2\u0bbf \u0ba8\u0bbf\u0baf\u0bc2 \u0bb7\u0bbf\u0b95\u0bc7\u0bb2\u0bcd" },
            { "ghs", "\u0b95\u0bbe\u0ba9\u0baf\u0ba9\u0bcd \u0b9a\u0bc7\u0b9f\u0bbf" },
            { "gyd", "\u0b95\u0baf\u0bbe\u0ba9\u0bc0\u0bb8\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "kpw", "\u0bb5\u0b9f \u0b95\u0bca\u0bb0\u0bbf\u0baf \u0bb5\u0bbe\u0ba9\u0bcd" },
            { "NGN", "NGN" },
            { "bob", "\u0baa\u0bca\u0bb2\u0bbf\u0bb5\u0bbf\u0baf\u0ba9\u0bcd \u0baa\u0bca\u0bb2\u0bbf\u0bb5\u0bbf\u0baf\u0bbe\u0ba9\u0bcb" },
            { "mdl", "\u0bae\u0bbe\u0bb2\u0bcd\u0b9f\u0bcb\u0bb5\u0ba9\u0bcd \u0bb2\u0bbf\u0baf\u0bc2" },
            { "CRC", "CRC" },
            { "PKR", "PKR" },
            { "amd", "\u0b86\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bcd\u0bb0\u0bbe\u0bae\u0bcd" },
            { "ANG", "ANG" },
            { "try", "\u0ba4\u0bc1\u0bb0\u0bc1\u0b95\u0bcd\u0b95\u0bbf\u0bb7\u0bcd \u0bb2\u0bc0\u0bb0\u0bbe" },
            { "lbp", "\u0bb2\u0bc6\u0baa\u0ba9\u0bc0\u0bb8\u0bcd \u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bc1" },
            { "jod", "\u0b9c\u0bcb\u0bb0\u0bcd\u0b9f\u0bbe\u0ba9\u0bbf\u0baf \u0ba4\u0bbf\u0ba9\u0bbe\u0bb0\u0bcd" },
            { "hkd", "\u0bb9\u0bbe\u0b99\u0bcd\u0b95\u0bbe\u0b99\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "eur", "\u0baf\u0bc2\u0bb0\u0bcb" },
            { "SRD", "SRD" },
            { "lsl", "\u0bb2\u0bc6\u0b9a\u0bcb\u0ba4\u0bcb \u0bb2\u0bcb\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "LTL", "LTL" },
            { "SAR", "SAR" },
            { "TTD", "TTD" },
            { "cad", "\u0b95\u0ba9\u0b9f\u0bbf\u0baf\u0ba9\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "MVR", "MVR" },
            { "mur", "\u0bae\u0bca\u0bb0\u0bc0\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0bb0\u0bc1\u0baa\u0bc0" },
            { "gip", "\u0b9c\u0bbf\u0baa\u0bcd\u0bb0\u0bbe\u0bb2\u0bcd\u0b9f\u0bb0\u0bcd \u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bc1" },
            { "ron", "\u0bb0\u0bcb\u0bae\u0bbe\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0bb2\u0bbf\u0baf\u0bc2" },
            { "JPY", "\u00a5" },
            { "AOA", "AOA" },
            { "PLN", "PLN" },
            { "SBD", "SBD" },
            { "ngn", "\u0ba8\u0bc8\u0b9c\u0bc0\u0bb0\u0bbf\u0baf\u0ba9\u0bcd \u0ba8\u0bc8\u0bb0\u0bbe" },
            { "crc", "\u0b95\u0bcb\u0bb8\u0bcd\u0b9f\u0bbe \u0bb0\u0bbf\u0b95\u0ba9\u0bcd \u0b95\u0bca\u0bb2\u0bcb\u0ba9\u0bcd" },
            { "pkr", "\u0baa\u0bbe\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bbf \u0bb0\u0bc2\u0baa\u0bbe\u0baf\u0bcd" },
            { "ang", "\u0ba8\u0bc6\u0ba4\u0bb0\u0bcd\u0bb2\u0bc7\u0ba3\u0bcd\u0b9f\u0bcd\u0bb8\u0bcd \u0b85\u0ba9\u0bcd\u0b9f\u0bbf\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bbf\u0bb2\u0bcd\u0b9f\u0bb0\u0bcd" },
            { "MWK", "MWK" },
            { "srd", "\u0b9a\u0bc1\u0bb0\u0bbf\u0ba9\u0bbe\u0bae\u0bc0\u0bb8\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "ltl", "\u0bb2\u0bbf\u0ba4\u0bc1\u0bb5\u0bc7\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0bb2\u0bbf\u0b9f\u0bb8\u0bcd" },
            { "sar", "\u0b9a\u0bb5\u0bc1\u0ba4\u0bbf \u0bb0\u0bbf\u0baf\u0bbe\u0bb2\u0bcd" },
            { "ttd", "\u0b9f\u0bbf\u0bb0\u0bbf\u0ba9\u0bbf\u0b9f\u0bbe\u0b9f\u0bcd \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0b9f\u0bcb\u0baa\u0bbe\u0b95\u0bcb \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "MGA", "MGA" },
            { "mvr", "\u0bae\u0bbe\u0bb2\u0ba4\u0bcd\u0ba4\u0bc0\u0bb5\u0bc1 \u0bb0\u0bc1\u0b83\u0baa\u0bbf\u0baf\u0bbe" },
            { "inr", "\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf \u0bb0\u0bc2\u0baa\u0bbe\u0baf\u0bcd" },
            { "BAM", "BAM" },
            { "EGP", "EGP" },
            { "SSP", "SSP" },
            { "krw", "\u0ba4\u0bc6\u0ba9\u0bcd \u0b95\u0bca\u0bb0\u0bbf\u0baf \u0bb5\u0bbe\u0ba9\u0bcd" },
            { "aoa", "\u0b85\u0b99\u0bcd\u0b95\u0bcb\u0bb2\u0ba9\u0bcd \u0b95\u0bcd\u0bb5\u0bbe\u0ba9\u0bcd\u0bb8\u0bbe" },
            { "jpy", "\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bbf\u0baf \u0baf\u0bc6\u0ba9\u0bcd" },
            { "pln", "\u0baa\u0bcb\u0bb2\u0bbf\u0bb7\u0bcd \u0bb8\u0bcd\u0bb2\u0bbe\u0b9f\u0bcd\u0b9f\u0bbf" },
            { "sbd", "\u0b9a\u0bbe\u0bb2\u0bae\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0b9f\u0bbe\u0bb2\u0bb0\u0bcd" },
            { "NIO", "NIO" },
        };
        return data;
    }
}
