/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.util.HttpMethodAuthenticator;
import org.keycloak.authorization.client.util.HttpMethodResponse;
import org.keycloak.authorization.client.util.HttpResponseException;
import org.keycloak.authorization.client.util.HttpResponseProcessor;
import org.keycloak.protocol.oidc.client.authentication.ClientCredentialsProvider;

public class HttpMethod<R> {
    private static final Logger logger = Logger.getLogger(HttpMethod.class.getName());
    private final HttpClient httpClient;
    final RequestBuilder builder;
    final Configuration configuration;
    final Map<String, String> headers;
    final Map<String, List<String>> params;
    private final ClientCredentialsProvider authenticator;
    private HttpMethodResponse<R> response;

    public HttpMethod(Configuration configuration, ClientCredentialsProvider authenticator, RequestBuilder builder) {
        this(configuration, authenticator, builder, new HashMap<String, List<String>>(), new HashMap<String, String>());
    }

    public HttpMethod(Configuration configuration, ClientCredentialsProvider authenticator, RequestBuilder builder, Map<String, List<String>> params, Map<String, String> headers) {
        this.configuration = configuration;
        this.httpClient = configuration.getHttpClient();
        this.authenticator = authenticator;
        this.builder = builder;
        this.params = params;
        this.headers = headers;
    }

    public void execute() {
        this.execute(new HttpResponseProcessor<R>(){

            @Override
            public R process(byte[] entity) {
                return null;
            }
        });
    }

    public R execute(HttpResponseProcessor<R> responseProcessor) {
        byte[] bytes = null;
        try {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                this.builder.setHeader(header.getKey(), header.getValue());
            }
            this.preExecute(this.builder);
            HttpResponse response = this.httpClient.execute(this.builder.build());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                bytes = EntityUtils.toByteArray((HttpEntity)entity);
            }
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Response from server: " + statusCode + " / " + statusLine.getReasonPhrase() + " / Body : " + new String(bytes != null ? bytes : new byte[]{}));
            }
            if (statusCode < 200 || statusCode >= 300) {
                throw new HttpResponseException("Unexpected response from server: " + statusCode + " / " + statusLine.getReasonPhrase(), statusCode, statusLine.getReasonPhrase(), bytes);
            }
            if (bytes == null) {
                return null;
            }
            return responseProcessor.process(bytes);
        }
        catch (HttpResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing http method [" + this.builder.getMethod() + "]. Response : " + String.valueOf(bytes), e);
        }
    }

    protected void preExecute(RequestBuilder builder) {
        for (Map.Entry<String, List<String>> param : this.params.entrySet()) {
            for (String value : param.getValue()) {
                builder.addParameter(param.getKey(), value);
            }
        }
    }

    public HttpMethod<R> authorizationBearer(String bearer) {
        this.builder.addHeader("Authorization", "Bearer " + bearer);
        return this;
    }

    public HttpMethodResponse<R> response() {
        this.response = new HttpMethodResponse(this);
        return this.response;
    }

    public HttpMethodAuthenticator<R> authentication() {
        return new HttpMethodAuthenticator(this, this.authenticator);
    }

    public HttpMethod<R> param(String name, String value) {
        if (value != null) {
            List<String> values = this.params.get(name);
            if (values == null || !values.isEmpty()) {
                values = new ArrayList<String>();
                this.params.put(name, values);
            }
            values.add(value);
        }
        return this;
    }

    public HttpMethod<R> params(String name, String value) {
        if (value != null) {
            List<String> values = this.params.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.params.put(name, values);
            }
            values.add(value);
        }
        return this;
    }

    public HttpMethod<R> json(byte[] entity) {
        this.builder.addHeader("Content-Type", "application/json");
        this.builder.setEntity((HttpEntity)new ByteArrayEntity(entity));
        return this;
    }

    public HttpMethod<R> form() {
        return new HttpMethod<R>(this.configuration, this.authenticator, this.builder, this.params, this.headers){

            @Override
            protected void preExecute(RequestBuilder builder) {
                if (this.params != null) {
                    ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry param : this.params.entrySet()) {
                        for (String value : (List)param.getValue()) {
                            formparams.add(new BasicNameValuePair((String)param.getKey(), value));
                        }
                    }
                    try {
                        builder.setEntity((HttpEntity)new UrlEncodedFormEntity(formparams, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Error creating form parameters");
                    }
                }
            }
        };
    }
}

