/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.util.Assert;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.support.VaultToken;

public class SimpleSessionManager
implements SessionManager {
    private final ClientAuthentication clientAuthentication;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile Optional<VaultToken> token = Optional.empty();

    public SimpleSessionManager(ClientAuthentication clientAuthentication) {
        Assert.notNull((Object)clientAuthentication, (String)"ClientAuthentication must not be null");
        this.clientAuthentication = clientAuthentication;
    }

    @Override
    public VaultToken getSessionToken() {
        if (!this.token.isPresent()) {
            this.lock.lock();
            try {
                if (!this.token.isPresent()) {
                    this.token = Optional.of(this.clientAuthentication.login());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.token.orElseThrow(() -> new IllegalStateException("Cannot obtain VaultToken"));
    }
}

