/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied. See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

// source: src/main/proto/CredentialStoreService.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = require('google-protobuf');
var goog = jspb;
var global = Function('return this')();

goog.exportSymbol('proto.org.apache.custos.credential.store.service.CredentialMetadata', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.Credentials', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.DeleteCredentialRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.GetCredentialRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.GetOwnerIdResponse', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.OperationMetadata', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.OperationStatus', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.TokenRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.credential.store.service.Type', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.CredentialMetadata, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.CredentialMetadata.displayName = 'proto.org.apache.custos.credential.store.service.CredentialMetadata';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.GetCredentialRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.GetCredentialRequest.displayName = 'proto.org.apache.custos.credential.store.service.GetCredentialRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.displayName = 'proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.repeatedFields_, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.displayName = 'proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.OperationStatus = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.OperationStatus, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.OperationStatus.displayName = 'proto.org.apache.custos.credential.store.service.OperationStatus';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.DeleteCredentialRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.displayName = 'proto.org.apache.custos.credential.store.service.DeleteCredentialRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.displayName = 'proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.OperationMetadata = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.OperationMetadata, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.OperationMetadata.displayName = 'proto.org.apache.custos.credential.store.service.OperationMetadata';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.repeatedFields_, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.displayName = 'proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.displayName = 'proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.displayName = 'proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.TokenRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.TokenRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.TokenRequest.displayName = 'proto.org.apache.custos.credential.store.service.TokenRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.GetOwnerIdResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.GetOwnerIdResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.displayName = 'proto.org.apache.custos.credential.store.service.GetOwnerIdResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.credential.store.service.Credentials = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.credential.store.service.Credentials, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.credential.store.service.Credentials.displayName = 'proto.org.apache.custos.credential.store.service.Credentials';
}



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.CredentialMetadata.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.CredentialMetadata} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.toObject = function(includeInstance, msg) {
  var f, obj = {
    ownerid: jspb.Message.getFieldWithDefault(msg, 1, 0),
    id: jspb.Message.getFieldWithDefault(msg, 2, ""),
    secret: jspb.Message.getFieldWithDefault(msg, 3, ""),
    clientsecretexpiredat: jspb.Message.getFieldWithDefault(msg, 4, 0),
    clientidissuedat: jspb.Message.getFieldWithDefault(msg, 5, 0),
    type: jspb.Message.getFieldWithDefault(msg, 6, 0),
    superTenant: jspb.Message.getBooleanFieldWithDefault(msg, 7, false),
    superAdmin: jspb.Message.getBooleanFieldWithDefault(msg, 8, false),
    internalSec: jspb.Message.getFieldWithDefault(msg, 11, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.CredentialMetadata;
  return proto.org.apache.custos.credential.store.service.CredentialMetadata.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.CredentialMetadata} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setOwnerid(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setId(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setSecret(value);
      break;
    case 4:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setClientsecretexpiredat(value);
      break;
    case 5:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setClientidissuedat(value);
      break;
    case 6:
      var value = /** @type {!proto.org.apache.custos.credential.store.service.Type} */ (reader.readEnum());
      msg.setType(value);
      break;
    case 7:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setSuperTenant(value);
      break;
    case 8:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setSuperAdmin(value);
      break;
    case 11:
      var value = /** @type {string} */ (reader.readString());
      msg.setInternalSec(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.CredentialMetadata.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.CredentialMetadata} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOwnerid();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
  f = message.getId();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getSecret();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getClientsecretexpiredat();
  if (f !== 0) {
    writer.writeInt64(
      4,
      f
    );
  }
  f = message.getClientidissuedat();
  if (f !== 0) {
    writer.writeInt64(
      5,
      f
    );
  }
  f = message.getType();
  if (f !== 0.0) {
    writer.writeEnum(
      6,
      f
    );
  }
  f = message.getSuperTenant();
  if (f) {
    writer.writeBool(
      7,
      f
    );
  }
  f = message.getSuperAdmin();
  if (f) {
    writer.writeBool(
      8,
      f
    );
  }
  f = message.getInternalSec();
  if (f.length > 0) {
    writer.writeString(
      11,
      f
    );
  }
};


/**
 * optional int64 ownerId = 1;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.getOwnerid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.setOwnerid = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string id = 2;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.getId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.setId = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string secret = 3;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.getSecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.setSecret = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional int64 clientSecretExpiredAt = 4;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.getClientsecretexpiredat = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.setClientsecretexpiredat = function(value) {
  return jspb.Message.setProto3IntField(this, 4, value);
};


/**
 * optional int64 clientIdIssuedAt = 5;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.getClientidissuedat = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 5, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.setClientidissuedat = function(value) {
  return jspb.Message.setProto3IntField(this, 5, value);
};


/**
 * optional Type type = 6;
 * @return {!proto.org.apache.custos.credential.store.service.Type}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.getType = function() {
  return /** @type {!proto.org.apache.custos.credential.store.service.Type} */ (jspb.Message.getFieldWithDefault(this, 6, 0));
};


/**
 * @param {!proto.org.apache.custos.credential.store.service.Type} value
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.setType = function(value) {
  return jspb.Message.setProto3EnumField(this, 6, value);
};


/**
 * optional bool super_tenant = 7;
 * @return {boolean}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.getSuperTenant = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 7, false));
};


/**
 * @param {boolean} value
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.setSuperTenant = function(value) {
  return jspb.Message.setProto3BooleanField(this, 7, value);
};


/**
 * optional bool super_admin = 8;
 * @return {boolean}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.getSuperAdmin = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 8, false));
};


/**
 * @param {boolean} value
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.setSuperAdmin = function(value) {
  return jspb.Message.setProto3BooleanField(this, 8, value);
};


/**
 * optional string internal_sec = 11;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.getInternalSec = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 11, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.CredentialMetadata.prototype.setInternalSec = function(value) {
  return jspb.Message.setProto3StringField(this, 11, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.GetCredentialRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.GetCredentialRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    ownerid: jspb.Message.getFieldWithDefault(msg, 1, 0),
    id: jspb.Message.getFieldWithDefault(msg, 2, ""),
    type: jspb.Message.getFieldWithDefault(msg, 3, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.GetCredentialRequest}
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.GetCredentialRequest;
  return proto.org.apache.custos.credential.store.service.GetCredentialRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.GetCredentialRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.GetCredentialRequest}
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setOwnerid(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setId(value);
      break;
    case 3:
      var value = /** @type {!proto.org.apache.custos.credential.store.service.Type} */ (reader.readEnum());
      msg.setType(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.GetCredentialRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.GetCredentialRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOwnerid();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
  f = message.getId();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getType();
  if (f !== 0.0) {
    writer.writeEnum(
      3,
      f
    );
  }
};


/**
 * optional int64 ownerId = 1;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.prototype.getOwnerid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.GetCredentialRequest} returns this
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.prototype.setOwnerid = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string id = 2;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.prototype.getId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.GetCredentialRequest} returns this
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.prototype.setId = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional Type type = 3;
 * @return {!proto.org.apache.custos.credential.store.service.Type}
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.prototype.getType = function() {
  return /** @type {!proto.org.apache.custos.credential.store.service.Type} */ (jspb.Message.getFieldWithDefault(this, 3, 0));
};


/**
 * @param {!proto.org.apache.custos.credential.store.service.Type} value
 * @return {!proto.org.apache.custos.credential.store.service.GetCredentialRequest} returns this
 */
proto.org.apache.custos.credential.store.service.GetCredentialRequest.prototype.setType = function(value) {
  return jspb.Message.setProto3EnumField(this, 3, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    ownerid: jspb.Message.getFieldWithDefault(msg, 1, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest;
  return proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setOwnerid(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOwnerid();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
};


/**
 * optional int64 ownerId = 1;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.prototype.getOwnerid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest} returns this
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsRequest.prototype.setOwnerid = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
    secretlistList: jspb.Message.toObjectList(msg.getSecretlistList(),
    proto.org.apache.custos.credential.store.service.CredentialMetadata.toObject, includeInstance),
    requesteruseremail: jspb.Message.getFieldWithDefault(msg, 2, ""),
    requesterusername: jspb.Message.getFieldWithDefault(msg, 3, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse;
  return proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.org.apache.custos.credential.store.service.CredentialMetadata;
      reader.readMessage(value,proto.org.apache.custos.credential.store.service.CredentialMetadata.deserializeBinaryFromReader);
      msg.addSecretlist(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setRequesteruseremail(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setRequesterusername(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSecretlistList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.org.apache.custos.credential.store.service.CredentialMetadata.serializeBinaryToWriter
    );
  }
  f = message.getRequesteruseremail();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getRequesterusername();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
};


/**
 * repeated CredentialMetadata secretList = 1;
 * @return {!Array<!proto.org.apache.custos.credential.store.service.CredentialMetadata>}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.prototype.getSecretlistList = function() {
  return /** @type{!Array<!proto.org.apache.custos.credential.store.service.CredentialMetadata>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.org.apache.custos.credential.store.service.CredentialMetadata, 1));
};


/**
 * @param {!Array<!proto.org.apache.custos.credential.store.service.CredentialMetadata>} value
 * @return {!proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse} returns this
*/
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.prototype.setSecretlistList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.org.apache.custos.credential.store.service.CredentialMetadata=} opt_value
 * @param {number=} opt_index
 * @return {!proto.org.apache.custos.credential.store.service.CredentialMetadata}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.prototype.addSecretlist = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.org.apache.custos.credential.store.service.CredentialMetadata, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse} returns this
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.prototype.clearSecretlistList = function() {
  return this.setSecretlistList([]);
};


/**
 * optional string requesterUserEmail = 2;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.prototype.getRequesteruseremail = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse} returns this
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.prototype.setRequesteruseremail = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string requesterUsername = 3;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.prototype.getRequesterusername = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse} returns this
 */
proto.org.apache.custos.credential.store.service.GetAllCredentialsResponse.prototype.setRequesterusername = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.OperationStatus.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.OperationStatus.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.OperationStatus} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.OperationStatus.toObject = function(includeInstance, msg) {
  var f, obj = {
    state: jspb.Message.getBooleanFieldWithDefault(msg, 1, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.OperationStatus}
 */
proto.org.apache.custos.credential.store.service.OperationStatus.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.OperationStatus;
  return proto.org.apache.custos.credential.store.service.OperationStatus.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.OperationStatus} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.OperationStatus}
 */
proto.org.apache.custos.credential.store.service.OperationStatus.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setState(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.OperationStatus.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.OperationStatus.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.OperationStatus} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.OperationStatus.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getState();
  if (f) {
    writer.writeBool(
      1,
      f
    );
  }
};


/**
 * optional bool state = 1;
 * @return {boolean}
 */
proto.org.apache.custos.credential.store.service.OperationStatus.prototype.getState = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 1, false));
};


/**
 * @param {boolean} value
 * @return {!proto.org.apache.custos.credential.store.service.OperationStatus} returns this
 */
proto.org.apache.custos.credential.store.service.OperationStatus.prototype.setState = function(value) {
  return jspb.Message.setProto3BooleanField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.DeleteCredentialRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    ownerid: jspb.Message.getFieldWithDefault(msg, 1, 0),
    type: jspb.Message.getFieldWithDefault(msg, 2, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.DeleteCredentialRequest}
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.DeleteCredentialRequest;
  return proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.DeleteCredentialRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.DeleteCredentialRequest}
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setOwnerid(value);
      break;
    case 2:
      var value = /** @type {!proto.org.apache.custos.credential.store.service.Type} */ (reader.readEnum());
      msg.setType(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.DeleteCredentialRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOwnerid();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
  f = message.getType();
  if (f !== 0.0) {
    writer.writeEnum(
      2,
      f
    );
  }
};


/**
 * optional int64 ownerId = 1;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.prototype.getOwnerid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.DeleteCredentialRequest} returns this
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.prototype.setOwnerid = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional Type type = 2;
 * @return {!proto.org.apache.custos.credential.store.service.Type}
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.prototype.getType = function() {
  return /** @type {!proto.org.apache.custos.credential.store.service.Type} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {!proto.org.apache.custos.credential.store.service.Type} value
 * @return {!proto.org.apache.custos.credential.store.service.DeleteCredentialRequest} returns this
 */
proto.org.apache.custos.credential.store.service.DeleteCredentialRequest.prototype.setType = function(value) {
  return jspb.Message.setProto3EnumField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    traceid: jspb.Message.getFieldWithDefault(msg, 1, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest;
  return proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTraceid(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getTraceid();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
};


/**
 * optional int64 traceId = 1;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.prototype.getTraceid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest} returns this
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataRequest.prototype.setTraceid = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.OperationMetadata.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.OperationMetadata} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.toObject = function(includeInstance, msg) {
  var f, obj = {
    event: jspb.Message.getFieldWithDefault(msg, 1, ""),
    status: jspb.Message.getFieldWithDefault(msg, 2, ""),
    timestamp: jspb.Message.getFieldWithDefault(msg, 3, ""),
    performedby: jspb.Message.getFieldWithDefault(msg, 4, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.OperationMetadata}
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.OperationMetadata;
  return proto.org.apache.custos.credential.store.service.OperationMetadata.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.OperationMetadata} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.OperationMetadata}
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setEvent(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setStatus(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setTimestamp(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setPerformedby(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.OperationMetadata.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.OperationMetadata} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getEvent();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getStatus();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getTimestamp();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getPerformedby();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
};


/**
 * optional string event = 1;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.prototype.getEvent = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.OperationMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.prototype.setEvent = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string status = 2;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.prototype.getStatus = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.OperationMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.prototype.setStatus = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string timeStamp = 3;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.prototype.getTimestamp = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.OperationMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.prototype.setTimestamp = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string performedBy = 4;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.prototype.getPerformedby = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.OperationMetadata} returns this
 */
proto.org.apache.custos.credential.store.service.OperationMetadata.prototype.setPerformedby = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
    metadataList: jspb.Message.toObjectList(msg.getMetadataList(),
    proto.org.apache.custos.credential.store.service.OperationMetadata.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse;
  return proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.org.apache.custos.credential.store.service.OperationMetadata;
      reader.readMessage(value,proto.org.apache.custos.credential.store.service.OperationMetadata.deserializeBinaryFromReader);
      msg.addMetadata(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getMetadataList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.org.apache.custos.credential.store.service.OperationMetadata.serializeBinaryToWriter
    );
  }
};


/**
 * repeated OperationMetadata metadata = 1;
 * @return {!Array<!proto.org.apache.custos.credential.store.service.OperationMetadata>}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.prototype.getMetadataList = function() {
  return /** @type{!Array<!proto.org.apache.custos.credential.store.service.OperationMetadata>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.org.apache.custos.credential.store.service.OperationMetadata, 1));
};


/**
 * @param {!Array<!proto.org.apache.custos.credential.store.service.OperationMetadata>} value
 * @return {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse} returns this
*/
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.prototype.setMetadataList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.org.apache.custos.credential.store.service.OperationMetadata=} opt_value
 * @param {number=} opt_index
 * @return {!proto.org.apache.custos.credential.store.service.OperationMetadata}
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.prototype.addMetadata = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.org.apache.custos.credential.store.service.OperationMetadata, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse} returns this
 */
proto.org.apache.custos.credential.store.service.GetOperationsMetadataResponse.prototype.clearMetadataList = function() {
  return this.setMetadataList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    ownerid: jspb.Message.getFieldWithDefault(msg, 1, 0),
    performedby: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest;
  return proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setOwnerid(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setPerformedby(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOwnerid();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
  f = message.getPerformedby();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional int64 ownerId = 1;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.prototype.getOwnerid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest} returns this
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.prototype.setOwnerid = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string performedBy = 2;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.prototype.getPerformedby = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest} returns this
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialRequest.prototype.setPerformedby = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
    clientid: jspb.Message.getFieldWithDefault(msg, 1, ""),
    clientsecret: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse;
  return proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientid(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientsecret(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getClientid();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getClientsecret();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string clientId = 1;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.prototype.getClientid = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse} returns this
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.prototype.setClientid = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string clientSecret = 2;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.prototype.getClientsecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse} returns this
 */
proto.org.apache.custos.credential.store.service.GetNewCustosCredentialResponse.prototype.setClientsecret = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.TokenRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.TokenRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.TokenRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.TokenRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    token: jspb.Message.getFieldWithDefault(msg, 1, ""),
    parentclientid: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.TokenRequest}
 */
proto.org.apache.custos.credential.store.service.TokenRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.TokenRequest;
  return proto.org.apache.custos.credential.store.service.TokenRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.TokenRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.TokenRequest}
 */
proto.org.apache.custos.credential.store.service.TokenRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setToken(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setParentclientid(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.TokenRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.TokenRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.TokenRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.TokenRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getToken();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getParentclientid();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string token = 1;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.TokenRequest.prototype.getToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.TokenRequest} returns this
 */
proto.org.apache.custos.credential.store.service.TokenRequest.prototype.setToken = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string parentClientId = 2;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.TokenRequest.prototype.getParentclientid = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.TokenRequest} returns this
 */
proto.org.apache.custos.credential.store.service.TokenRequest.prototype.setParentclientid = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.GetOwnerIdResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
    ownerid: jspb.Message.getFieldWithDefault(msg, 2, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.GetOwnerIdResponse}
 */
proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.GetOwnerIdResponse;
  return proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.GetOwnerIdResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.GetOwnerIdResponse}
 */
proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 2:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setOwnerid(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.GetOwnerIdResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOwnerid();
  if (f !== 0) {
    writer.writeInt64(
      2,
      f
    );
  }
};


/**
 * optional int64 ownerId = 2;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.prototype.getOwnerid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.GetOwnerIdResponse} returns this
 */
proto.org.apache.custos.credential.store.service.GetOwnerIdResponse.prototype.setOwnerid = function(value) {
  return jspb.Message.setProto3IntField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.credential.store.service.Credentials.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.credential.store.service.Credentials} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.Credentials.toObject = function(includeInstance, msg) {
  var f, obj = {
    iamClientId: jspb.Message.getFieldWithDefault(msg, 1, ""),
    iamClientSecret: jspb.Message.getFieldWithDefault(msg, 2, ""),
    ciLogonClientId: jspb.Message.getFieldWithDefault(msg, 3, ""),
    ciLogonClientSecret: jspb.Message.getFieldWithDefault(msg, 4, ""),
    custosClientId: jspb.Message.getFieldWithDefault(msg, 5, ""),
    custosClientSecret: jspb.Message.getFieldWithDefault(msg, 6, ""),
    custosClientIdIssuedAt: jspb.Message.getFloatingPointFieldWithDefault(msg, 7, 0.0),
    custosClientSecretExpiredAt: jspb.Message.getFloatingPointFieldWithDefault(msg, 8, 0.0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.credential.store.service.Credentials}
 */
proto.org.apache.custos.credential.store.service.Credentials.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.credential.store.service.Credentials;
  return proto.org.apache.custos.credential.store.service.Credentials.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.credential.store.service.Credentials} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.credential.store.service.Credentials}
 */
proto.org.apache.custos.credential.store.service.Credentials.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamClientId(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamClientSecret(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setCiLogonClientId(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setCiLogonClientSecret(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setCustosClientId(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setCustosClientSecret(value);
      break;
    case 7:
      var value = /** @type {number} */ (reader.readDouble());
      msg.setCustosClientIdIssuedAt(value);
      break;
    case 8:
      var value = /** @type {number} */ (reader.readDouble());
      msg.setCustosClientSecretExpiredAt(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.credential.store.service.Credentials.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.credential.store.service.Credentials} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.credential.store.service.Credentials.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getIamClientId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getIamClientSecret();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getCiLogonClientId();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getCiLogonClientSecret();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
  f = message.getCustosClientId();
  if (f.length > 0) {
    writer.writeString(
      5,
      f
    );
  }
  f = message.getCustosClientSecret();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
  f = message.getCustosClientIdIssuedAt();
  if (f !== 0.0) {
    writer.writeDouble(
      7,
      f
    );
  }
  f = message.getCustosClientSecretExpiredAt();
  if (f !== 0.0) {
    writer.writeDouble(
      8,
      f
    );
  }
};


/**
 * optional string iam_client_id = 1;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.getIamClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.Credentials} returns this
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.setIamClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string iam_client_secret = 2;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.getIamClientSecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.Credentials} returns this
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.setIamClientSecret = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string ci_logon_client_id = 3;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.getCiLogonClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.Credentials} returns this
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.setCiLogonClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string ci_logon_client_secret = 4;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.getCiLogonClientSecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.Credentials} returns this
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.setCiLogonClientSecret = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


/**
 * optional string custos_client_id = 5;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.getCustosClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.Credentials} returns this
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.setCustosClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 5, value);
};


/**
 * optional string custos_client_secret = 6;
 * @return {string}
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.getCustosClientSecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.credential.store.service.Credentials} returns this
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.setCustosClientSecret = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * optional double custos_client_id_issued_at = 7;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.getCustosClientIdIssuedAt = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 7, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.Credentials} returns this
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.setCustosClientIdIssuedAt = function(value) {
  return jspb.Message.setProto3FloatField(this, 7, value);
};


/**
 * optional double custos_client_secret_expired_at = 8;
 * @return {number}
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.getCustosClientSecretExpiredAt = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 8, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.credential.store.service.Credentials} returns this
 */
proto.org.apache.custos.credential.store.service.Credentials.prototype.setCustosClientSecretExpiredAt = function(value) {
  return jspb.Message.setProto3FloatField(this, 8, value);
};


/**
 * @enum {number}
 */
proto.org.apache.custos.credential.store.service.Type = {
  CUSTOS: 0,
  IAM: 1,
  CILOGON: 2,
  INDIVIDUAL: 3,
  AGENT_CLIENT: 4,
  AGENT: 5
};

goog.object.extend(exports, proto.org.apache.custos.credential.store.service);
