/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied. See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

// source: src/main/proto/IdentityManagementService.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = require('google-protobuf');
var goog = jspb;
var global = Function('return this')();


var IdentityService_pb = require('../../core-services/identity-service/IdentityService_pb');
goog.object.extend(proto, IdentityService_pb);
var google_protobuf_struct_pb = require('google-protobuf/google/protobuf/struct_pb.js');
goog.object.extend(proto, google_protobuf_struct_pb);
var google_protobuf_any_pb = require('google-protobuf/google/protobuf/any_pb.js');
goog.object.extend(proto, google_protobuf_any_pb);
var CredentialStoreService_pb = require('../../core-services/credential-store-service/CredentialStoreService_pb.js');
goog.object.extend(proto, CredentialStoreService_pb);
goog.exportSymbol('proto.org.apache.custos.identity.management.service.AuthorizationRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.identity.management.service.AuthorizationResponse', null, global);
goog.exportSymbol('proto.org.apache.custos.identity.management.service.EndSessionRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.identity.management.service.GetAgentTokenRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.identity.management.service.GetCredentialsRequest', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.identity.management.service.AuthorizationRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.identity.management.service.AuthorizationRequest.displayName = 'proto.org.apache.custos.identity.management.service.AuthorizationRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.identity.management.service.AuthorizationResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.identity.management.service.AuthorizationResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.identity.management.service.AuthorizationResponse.displayName = 'proto.org.apache.custos.identity.management.service.AuthorizationResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.identity.management.service.GetCredentialsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.identity.management.service.GetCredentialsRequest.displayName = 'proto.org.apache.custos.identity.management.service.GetCredentialsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.identity.management.service.GetAgentTokenRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.displayName = 'proto.org.apache.custos.identity.management.service.GetAgentTokenRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.identity.management.service.EndSessionRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.identity.management.service.EndSessionRequest.displayName = 'proto.org.apache.custos.identity.management.service.EndSessionRequest';
}



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.identity.management.service.AuthorizationRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.identity.management.service.AuthorizationRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    tenantId: jspb.Message.getFieldWithDefault(msg, 1, 0),
    clientId: jspb.Message.getFieldWithDefault(msg, 2, ""),
    clientSecret: jspb.Message.getFieldWithDefault(msg, 3, ""),
    redirectUri: jspb.Message.getFieldWithDefault(msg, 4, ""),
    responseType: jspb.Message.getFieldWithDefault(msg, 5, ""),
    scope: jspb.Message.getFieldWithDefault(msg, 6, ""),
    state: jspb.Message.getFieldWithDefault(msg, 7, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationRequest}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.identity.management.service.AuthorizationRequest;
  return proto.org.apache.custos.identity.management.service.AuthorizationRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.identity.management.service.AuthorizationRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationRequest}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantId(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientId(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientSecret(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setRedirectUri(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setResponseType(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setScope(value);
      break;
    case 7:
      var value = /** @type {string} */ (reader.readString());
      msg.setState(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.identity.management.service.AuthorizationRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.identity.management.service.AuthorizationRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getTenantId();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
  f = message.getClientId();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getClientSecret();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getRedirectUri();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
  f = message.getResponseType();
  if (f.length > 0) {
    writer.writeString(
      5,
      f
    );
  }
  f = message.getScope();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
  f = message.getState();
  if (f.length > 0) {
    writer.writeString(
      7,
      f
    );
  }
};


/**
 * optional int64 tenant_id = 1;
 * @return {number}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.getTenantId = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationRequest} returns this
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.setTenantId = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string client_id = 2;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.getClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationRequest} returns this
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.setClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string client_secret = 3;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.getClientSecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationRequest} returns this
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.setClientSecret = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string redirect_uri = 4;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.getRedirectUri = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationRequest} returns this
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.setRedirectUri = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


/**
 * optional string response_type = 5;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.getResponseType = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationRequest} returns this
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.setResponseType = function(value) {
  return jspb.Message.setProto3StringField(this, 5, value);
};


/**
 * optional string scope = 6;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.getScope = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationRequest} returns this
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.setScope = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * optional string state = 7;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.getState = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 7, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationRequest} returns this
 */
proto.org.apache.custos.identity.management.service.AuthorizationRequest.prototype.setState = function(value) {
  return jspb.Message.setProto3StringField(this, 7, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.identity.management.service.AuthorizationResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.identity.management.service.AuthorizationResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.identity.management.service.AuthorizationResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.identity.management.service.AuthorizationResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
    loginuri: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationResponse}
 */
proto.org.apache.custos.identity.management.service.AuthorizationResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.identity.management.service.AuthorizationResponse;
  return proto.org.apache.custos.identity.management.service.AuthorizationResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.identity.management.service.AuthorizationResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationResponse}
 */
proto.org.apache.custos.identity.management.service.AuthorizationResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLoginuri(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.identity.management.service.AuthorizationResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.identity.management.service.AuthorizationResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.identity.management.service.AuthorizationResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.identity.management.service.AuthorizationResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLoginuri();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string loginURI = 1;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.AuthorizationResponse.prototype.getLoginuri = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.AuthorizationResponse} returns this
 */
proto.org.apache.custos.identity.management.service.AuthorizationResponse.prototype.setLoginuri = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.identity.management.service.GetCredentialsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.identity.management.service.GetCredentialsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    clientId: jspb.Message.getFieldWithDefault(msg, 1, ""),
    credentials: (f = msg.getCredentials()) && CredentialStoreService_pb.Credentials.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.identity.management.service.GetCredentialsRequest}
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.identity.management.service.GetCredentialsRequest;
  return proto.org.apache.custos.identity.management.service.GetCredentialsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.identity.management.service.GetCredentialsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.identity.management.service.GetCredentialsRequest}
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientId(value);
      break;
    case 2:
      var value = new CredentialStoreService_pb.Credentials;
      reader.readMessage(value,CredentialStoreService_pb.Credentials.deserializeBinaryFromReader);
      msg.setCredentials(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.identity.management.service.GetCredentialsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.identity.management.service.GetCredentialsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getClientId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getCredentials();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      CredentialStoreService_pb.Credentials.serializeBinaryToWriter
    );
  }
};


/**
 * optional string client_id = 1;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.prototype.getClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.GetCredentialsRequest} returns this
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.prototype.setClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional org.apache.custos.credential.store.service.Credentials credentials = 2;
 * @return {?proto.org.apache.custos.credential.store.service.Credentials}
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.prototype.getCredentials = function() {
  return /** @type{?proto.org.apache.custos.credential.store.service.Credentials} */ (
    jspb.Message.getWrapperField(this, CredentialStoreService_pb.Credentials, 2));
};


/**
 * @param {?proto.org.apache.custos.credential.store.service.Credentials|undefined} value
 * @return {!proto.org.apache.custos.identity.management.service.GetCredentialsRequest} returns this
*/
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.prototype.setCredentials = function(value) {
  return jspb.Message.setWrapperField(this, 2, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.identity.management.service.GetCredentialsRequest} returns this
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.prototype.clearCredentials = function() {
  return this.setCredentials(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.identity.management.service.GetCredentialsRequest.prototype.hasCredentials = function() {
  return jspb.Message.getField(this, 2) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    tenantId: jspb.Message.getFieldWithDefault(msg, 1, 0),
    agentClientId: jspb.Message.getFieldWithDefault(msg, 2, ""),
    agentClientSecret: jspb.Message.getFieldWithDefault(msg, 3, ""),
    agentid: jspb.Message.getFieldWithDefault(msg, 4, ""),
    agentpassword: jspb.Message.getFieldWithDefault(msg, 5, ""),
    clientId: jspb.Message.getFieldWithDefault(msg, 6, ""),
    grantType: jspb.Message.getFieldWithDefault(msg, 7, ""),
    refreshToken: jspb.Message.getFieldWithDefault(msg, 8, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.identity.management.service.GetAgentTokenRequest;
  return proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantId(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setAgentClientId(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setAgentClientSecret(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setAgentid(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setAgentpassword(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientId(value);
      break;
    case 7:
      var value = /** @type {string} */ (reader.readString());
      msg.setGrantType(value);
      break;
    case 8:
      var value = /** @type {string} */ (reader.readString());
      msg.setRefreshToken(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getTenantId();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
  f = message.getAgentClientId();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getAgentClientSecret();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getAgentid();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
  f = message.getAgentpassword();
  if (f.length > 0) {
    writer.writeString(
      5,
      f
    );
  }
  f = message.getClientId();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
  f = message.getGrantType();
  if (f.length > 0) {
    writer.writeString(
      7,
      f
    );
  }
  f = message.getRefreshToken();
  if (f.length > 0) {
    writer.writeString(
      8,
      f
    );
  }
};


/**
 * optional int64 tenant_id = 1;
 * @return {number}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.getTenantId = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} returns this
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.setTenantId = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string agent_client_id = 2;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.getAgentClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} returns this
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.setAgentClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string agent_client_secret = 3;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.getAgentClientSecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} returns this
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.setAgentClientSecret = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string agentId = 4;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.getAgentid = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} returns this
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.setAgentid = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


/**
 * optional string agentPassword = 5;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.getAgentpassword = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} returns this
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.setAgentpassword = function(value) {
  return jspb.Message.setProto3StringField(this, 5, value);
};


/**
 * optional string client_id = 6;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.getClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} returns this
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.setClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * optional string grant_type = 7;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.getGrantType = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 7, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} returns this
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.setGrantType = function(value) {
  return jspb.Message.setProto3StringField(this, 7, value);
};


/**
 * optional string refresh_token = 8;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.getRefreshToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 8, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.GetAgentTokenRequest} returns this
 */
proto.org.apache.custos.identity.management.service.GetAgentTokenRequest.prototype.setRefreshToken = function(value) {
  return jspb.Message.setProto3StringField(this, 8, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.identity.management.service.EndSessionRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.identity.management.service.EndSessionRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    clientId: jspb.Message.getFieldWithDefault(msg, 1, ""),
    body: (f = msg.getBody()) && IdentityService_pb.EndSessionRequest.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.identity.management.service.EndSessionRequest}
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.identity.management.service.EndSessionRequest;
  return proto.org.apache.custos.identity.management.service.EndSessionRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.identity.management.service.EndSessionRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.identity.management.service.EndSessionRequest}
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientId(value);
      break;
    case 2:
      var value = new IdentityService_pb.EndSessionRequest;
      reader.readMessage(value,IdentityService_pb.EndSessionRequest.deserializeBinaryFromReader);
      msg.setBody(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.identity.management.service.EndSessionRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.identity.management.service.EndSessionRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getClientId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getBody();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      IdentityService_pb.EndSessionRequest.serializeBinaryToWriter
    );
  }
};


/**
 * optional string client_id = 1;
 * @return {string}
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.prototype.getClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.identity.management.service.EndSessionRequest} returns this
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.prototype.setClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional org.apache.custos.identity.service.EndSessionRequest body = 2;
 * @return {?proto.org.apache.custos.identity.service.EndSessionRequest}
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.prototype.getBody = function() {
  return /** @type{?proto.org.apache.custos.identity.service.EndSessionRequest} */ (
    jspb.Message.getWrapperField(this, IdentityService_pb.EndSessionRequest, 2));
};


/**
 * @param {?proto.org.apache.custos.identity.service.EndSessionRequest|undefined} value
 * @return {!proto.org.apache.custos.identity.management.service.EndSessionRequest} returns this
*/
proto.org.apache.custos.identity.management.service.EndSessionRequest.prototype.setBody = function(value) {
  return jspb.Message.setWrapperField(this, 2, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.identity.management.service.EndSessionRequest} returns this
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.prototype.clearBody = function() {
  return this.setBody(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.identity.management.service.EndSessionRequest.prototype.hasBody = function() {
  return jspb.Message.getField(this, 2) != null;
};


goog.object.extend(exports, proto.org.apache.custos.identity.management.service);
