/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import org.apache.hadoop.ipc.ProtocolMetaInfoPB;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.protobuf.ProtocolInfoProtos;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;

public class ProtocolMetaInfoServerSideTranslatorPB
implements ProtocolMetaInfoPB {
    RPC.Server server;

    public ProtocolMetaInfoServerSideTranslatorPB(RPC.Server server) {
        this.server = server;
    }

    @Override
    public ProtocolInfoProtos.GetProtocolVersionsResponseProto getProtocolVersions(RpcController controller, ProtocolInfoProtos.GetProtocolVersionsRequestProto request) throws ServiceException {
        String protocol = request.getProtocol();
        ProtocolInfoProtos.GetProtocolVersionsResponseProto.Builder builder = ProtocolInfoProtos.GetProtocolVersionsResponseProto.newBuilder();
        for (RPC.RpcKind r : RPC.RpcKind.values()) {
            long[] versions;
            try {
                versions = this.getProtocolVersionForRpcKind(r, protocol);
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException(e);
            }
            ProtocolInfoProtos.ProtocolVersionProto.Builder b = ProtocolInfoProtos.ProtocolVersionProto.newBuilder();
            if (versions != null) {
                b.setRpcKind(r.toString());
                for (long v : versions) {
                    b.addVersions(v);
                }
            }
            builder.addProtocolVersions(b.build());
        }
        return builder.build();
    }

    @Override
    public ProtocolInfoProtos.GetProtocolSignatureResponseProto getProtocolSignature(RpcController controller, ProtocolInfoProtos.GetProtocolSignatureRequestProto request) throws ServiceException {
        long[] versions;
        ProtocolInfoProtos.GetProtocolSignatureResponseProto.Builder builder = ProtocolInfoProtos.GetProtocolSignatureResponseProto.newBuilder();
        String protocol = request.getProtocol();
        String rpcKind = request.getRpcKind();
        try {
            versions = this.getProtocolVersionForRpcKind(RPC.RpcKind.valueOf(rpcKind), protocol);
        }
        catch (ClassNotFoundException e1) {
            throw new ServiceException(e1);
        }
        if (versions == null) {
            return builder.build();
        }
        for (long v : versions) {
            ProtocolInfoProtos.ProtocolSignatureProto.Builder sigBuilder = ProtocolInfoProtos.ProtocolSignatureProto.newBuilder();
            sigBuilder.setVersion(v);
            try {
                ProtocolSignature signature = ProtocolSignature.getProtocolSignature(protocol, v);
                for (int m3 : signature.getMethods()) {
                    sigBuilder.addMethods(m3);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException(e);
            }
            builder.addProtocolSignature(sigBuilder.build());
        }
        return builder.build();
    }

    private long[] getProtocolVersionForRpcKind(RPC.RpcKind rpcKind, String protocol) throws ClassNotFoundException {
        Class<?> protocolClass = Class.forName(protocol);
        String protocolName = RPC.getProtocolName(protocolClass);
        RPC.Server.VerProtocolImpl[] vers = this.server.getSupportedProtocolVersions(rpcKind, protocolName);
        if (vers == null) {
            return null;
        }
        long[] versions = new long[vers.length];
        for (int i = 0; i < versions.length; ++i) {
            versions[i] = vers[i].version;
        }
        return versions;
    }
}

