/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ppolicy_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyResponse;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyResponseImpl;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyResponseContainer;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyTags;
import org.apache.directory.api.ldap.model.message.Control;

public class PasswordPolicyResponseFactory
extends AbstractControlFactory<PasswordPolicyResponse> {
    public PasswordPolicyResponseFactory(LdapApiService codec) {
        super(codec, "1.3.6.1.4.1.42.2.27.8.5.1");
    }

    @Override
    public PasswordPolicyResponse newControl() {
        return new PasswordPolicyResponseImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        int start = buffer.getPos();
        PasswordPolicyResponse ppResponse = (PasswordPolicyResponse)control;
        if (ppResponse.getTimeBeforeExpiration() >= 0 || ppResponse.getGraceAuthNRemaining() >= 0 || ppResponse.getPasswordPolicyError() != null) {
            if (ppResponse.getPasswordPolicyError() != null) {
                BerValue.encodeEnumerated(buffer, (byte)PasswordPolicyTags.PPOLICY_ERROR_TAG.getValue(), ppResponse.getPasswordPolicyError().getValue());
            }
            boolean warning = false;
            int startWarning = buffer.getPos();
            if (ppResponse.getGraceAuthNRemaining() >= 0) {
                BerValue.encodeInteger(buffer, (byte)PasswordPolicyTags.GRACE_AUTHNS_REMAINING_TAG.getValue(), ppResponse.getGraceAuthNRemaining());
                warning = true;
            } else if (ppResponse.getTimeBeforeExpiration() >= 0) {
                BerValue.encodeInteger(buffer, (byte)PasswordPolicyTags.TIME_BEFORE_EXPIRATION_TAG.getValue(), ppResponse.getTimeBeforeExpiration());
                warning = true;
            }
            if (warning) {
                BerValue.encodeSequence(buffer, (byte)PasswordPolicyTags.PPOLICY_WARNING_TAG.getValue(), startWarning);
            }
        }
        BerValue.encodeSequence(buffer, start);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new PasswordPolicyResponseContainer(control), control, controlBytes);
    }
}

