/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import java.util.Iterator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.evaluator.LeafEvaluator;

public class ApproximateEvaluator<T>
extends LeafEvaluator<T> {
    public ApproximateEvaluator(ApproximateNode<T> node, Store db, SchemaManager schemaManager) throws LdapException {
        super(node, db, schemaManager);
        if (db.hasIndexOn(this.attributeType)) {
            try {
                this.idx = db.getIndex(this.attributeType);
            }
            catch (IndexNotFoundException infe) {
                throw new LdapOtherException(infe.getMessage(), infe);
            }
            this.normalizer = null;
            this.ldapComparator = null;
        } else {
            this.idx = null;
            MatchingRule mr = this.attributeType.getEquality();
            if (mr == null) {
                throw new IllegalStateException(I18n.err(I18n.ERR_709, node));
            }
            this.normalizer = mr.getNormalizer();
            this.ldapComparator = mr.getLdapComparator();
        }
    }

    @Override
    public ApproximateNode<T> getExpression() {
        return (ApproximateNode)this.node;
    }

    @Override
    public boolean evaluate(Entry entry) throws LdapException {
        Attribute attr = entry.get(this.attributeType);
        if (attr != null && this.evaluate(attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(attr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean evaluate(PartitionTxn partitionTxn, IndexEntry<?, String> indexEntry) throws LdapException {
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.fetch(partitionTxn, indexEntry.getId());
            if (null == entry) {
                return false;
            }
            indexEntry.setEntry(entry);
        }
        return this.evaluate(entry);
    }

    private boolean evaluate(Attribute attribute) {
        for (Value value : attribute) {
            if (value.compareTo(this.node.getValue()) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("ApproximateEvaluator : ").append(super.toString()).append("\n");
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

