/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.Properties;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.impl.AdminRoleDAO;
import org.apache.directory.fortress.core.impl.GroupDAO;
import org.apache.directory.fortress.core.impl.PermObjDAO;
import org.apache.directory.fortress.core.impl.PermOpDAO;
import org.apache.directory.fortress.core.impl.PropertyDAO;
import org.apache.directory.fortress.core.impl.PropertyProvider;
import org.apache.directory.fortress.core.impl.RoleDAO;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Role;

final class PropertyP {
    private PropertyDAO propDAO = new PropertyDAO();
    private RoleDAO rDAO = new RoleDAO();
    private AdminRoleDAO arDAO = new AdminRoleDAO();
    private GroupDAO gDAO = new GroupDAO();
    private PermOpDAO popDAO = new PermOpDAO();
    private PermObjDAO pobjDAO = new PermObjDAO();

    PropertyP() {
    }

    FortEntity addProperties(FortEntity entity, Properties props) throws UpdateException, FinderException {
        return this.propDAO.addProperties(entity, props, this.getPropertyProvider(entity));
    }

    FortEntity updateProperties(FortEntity entity, Properties props) throws UpdateException, FinderException {
        return this.propDAO.updateProperties(entity, props, this.getPropertyProvider(entity));
    }

    void deleteProperties(FortEntity entity, Properties props) throws UpdateException, FinderException {
        this.propDAO.deleteProperties(entity, props, this.getPropertyProvider(entity));
    }

    Properties getProperties(FortEntity entity) throws FinderException {
        return this.propDAO.getProperties(entity, this.getPropertyProvider(entity));
    }

    private PropertyProvider getPropertyProvider(FortEntity entity) {
        if (entity instanceof AdminRole) {
            return this.arDAO;
        }
        if (entity instanceof Role) {
            return this.rDAO;
        }
        if (entity instanceof Group) {
            return this.gDAO;
        }
        if (entity instanceof PermObj) {
            return this.pobjDAO;
        }
        if (entity instanceof Permission) {
            return this.popDAO;
        }
        throw new IllegalArgumentException("Provided entity does not have an associated property provider DAO");
    }
}

