/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Props;

@XmlRootElement(name="fortPermission")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="permission", propOrder={"objName", "opName", "objId", "description", "abstractName", "internalId", "type", "users", "roles", "props", "dn", "admin", "paSets"})
public class Permission
extends FortEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean admin;
    private String internalId;
    private String opName;
    private String objName;
    private String objId;
    private String abstractName;
    private String type;
    private String dn;
    private String description;
    @XmlElement(nillable=true)
    private Props props = new Props();
    @XmlElement(nillable=true)
    private Set<String> roles;
    @XmlElement(nillable=true)
    private Set<String> users;
    private Set<String> paSets;

    public Permission(String objName, String opName) {
        this.objName = objName;
        this.opName = opName;
    }

    public Permission() {
    }

    public Permission(String objName) {
        this.objName = objName;
    }

    public Permission(String objName, String opName, String objId) {
        this.objName = objName;
        this.opName = opName;
        this.objId = objId;
    }

    public Permission(String objName, String opName, boolean admin) {
        this.objName = objName;
        this.opName = opName;
        this.admin = admin;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public void setInternalId() {
        UUID uuid = UUID.randomUUID();
        this.internalId = uuid.toString();
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public String getOpName() {
        return this.opName;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getAbstractName() {
        return this.abstractName;
    }

    public void setAbstractName(String abstractName) {
        this.abstractName = abstractName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getObjId() {
        return this.objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public void setRole(String role) {
        if (this.roles == null) {
            this.roles = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.roles.add(role);
    }

    public void delRole(String role) {
        if (this.roles != null) {
            this.roles.remove(role);
        }
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setUser(String user) {
        if (this.users == null) {
            this.users = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.users.add(user);
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public void setUsers(Set<String> users) {
        this.users = users;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Props getProps() {
        return this.props;
    }

    public void setProps(Props value) {
        this.props = value;
    }

    public void addProperty(String key, String value) {
        Props.Entry entry = new Props.Entry();
        entry.setKey(key);
        entry.setValue(value);
        this.props.getEntry().add(entry);
    }

    public String getProperty(String key) {
        List<Props.Entry> props = this.props.getEntry();
        Props.Entry keyObj = new Props.Entry();
        keyObj.setKey(key);
        String value = null;
        int indx = props.indexOf(keyObj);
        if (indx != -1) {
            Props.Entry entry = props.get(props.indexOf(keyObj));
            value = entry.getValue();
        }
        return value;
    }

    public void addProperties(Properties props) {
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = props.getProperty(key);
                this.addProperty(key, val);
            }
        }
    }

    public Properties getProperties() {
        Properties properties = null;
        List<Props.Entry> props = this.props.getEntry();
        if (props.size() > 0) {
            properties = new Properties();
            for (Props.Entry entry : props) {
                String key = entry.getKey();
                String val = entry.getValue();
                properties.setProperty(key, val);
            }
        }
        return properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permission that = (Permission)o;
        if (StringUtils.isNotEmpty((CharSequence)this.objId) ? !this.objId.equalsIgnoreCase(that.objId) : StringUtils.isNotEmpty((CharSequence)that.objId)) {
            return false;
        }
        if (this.objName != null ? !this.objName.equalsIgnoreCase(that.objName) : that.objName != null) {
            return false;
        }
        return !(this.opName != null ? !this.opName.equalsIgnoreCase(that.opName) : that.opName != null);
    }

    public int hashCode() {
        int result = this.admin ? 1 : 0;
        result = 31 * result + (this.internalId != null ? this.internalId.hashCode() : 0);
        result = 31 * result + (this.opName != null ? this.opName.hashCode() : 0);
        result = 31 * result + (this.objName != null ? this.objName.hashCode() : 0);
        result = 31 * result + (this.objId != null ? this.objId.hashCode() : 0);
        result = 31 * result + (this.abstractName != null ? this.abstractName.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.dn != null ? this.dn.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.props != null ? this.props.hashCode() : 0);
        result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
        result = 31 * result + (this.users != null ? this.users.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Permission{objName='" + this.objName + "', opName='" + this.opName + "', objId='" + this.objId + "'}";
    }

    public Set<String> getPaSets() {
        if (this.paSets == null) {
            this.paSets = new HashSet<String>();
        }
        return this.paSets;
    }

    public void setPaSets(Set<String> paSets) {
        this.paSets = paSets;
    }

    public void setPaSetName(String paSet) {
        if (this.paSets == null) {
            this.paSets = new HashSet<String>();
        }
        this.paSets.add(paSet);
    }
}

