/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.AMap;

public class OperationMap
extends TreeMap<String, Operation> {
    private static final long serialVersionUID = 1L;
    private static final Comparator<String> OP_SORTER = new Comparator<String>(){
        private final Map<String, String> methods = new AMap().append((Object)"get", (Object)"0").append((Object)"put", (Object)"1").append((Object)"post", (Object)"2").append((Object)"delete", (Object)"3").append((Object)"options", (Object)"4").append((Object)"head", (Object)"5").append((Object)"patch", (Object)"6");

        @Override
        public int compare(String o1, String o2) {
            String s1 = this.methods.get(o1);
            String s2 = this.methods.get(o2);
            if (s1 == null) {
                s1 = o1;
            }
            if (s2 == null) {
                s2 = o2;
            }
            return StringUtils.compare((String)s1, (String)s2);
        }
    };

    public OperationMap() {
        super(OP_SORTER);
    }

    public OperationMap append(String httpMethodName, Operation operation) {
        this.put(StringUtils.emptyIfNull((String)httpMethodName).toLowerCase(), operation);
        return this;
    }
}

