/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;

public class BasicCsvArrayPart
extends BasicPart {
    private static final String[] EMPTY = new String[0];
    private final String[] value;
    private final Supplier<String[]> supplier;
    private String stringValue;

    public static BasicCsvArrayPart of(String name, String ... value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicCsvArrayPart(name, value);
    }

    public static BasicCsvArrayPart of(String name, Supplier<String[]> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicCsvArrayPart(name, value);
    }

    public BasicCsvArrayPart(String name, String ... value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
        this.stringValue = null;
    }

    public BasicCsvArrayPart(String name, Supplier<String[]> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
        this.stringValue = null;
    }

    public BasicCsvArrayPart(String name, String value) {
        super(name, value);
        this.value = StringUtils.split(value);
        this.supplier = null;
        this.stringValue = value;
    }

    @Override
    public String getValue() {
        if (this.supplier != null) {
            return StringUtils.join((Object[])this.supplier.get(), ',');
        }
        if (this.stringValue != null) {
            this.stringValue = StringUtils.join((Object[])this.value, ',');
        }
        return this.stringValue;
    }

    public boolean contains(String val) {
        if (val != null) {
            for (String v : this.value()) {
                if (!StringUtils.eq(v, val)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsIgnoreCase(String val) {
        if (val != null) {
            for (String v : this.value()) {
                if (!StringUtils.eqic(v, val)) continue;
                return true;
            }
        }
        return false;
    }

    public FluentListAssertion<String, BasicCsvArrayPart> assertList() {
        return new FluentListAssertion<String, BasicCsvArrayPart>(CollectionUtils.ulist(this.value()), this);
    }

    public List<String> toList() {
        return CollectionUtils.ulist(this.value());
    }

    public Optional<List<String>> asList() {
        return CollectionUtils.optional(this.toList());
    }

    public String[] toArray() {
        return ArrayUtils.copyOf(this.value());
    }

    public Optional<String[]> asArray() {
        return CollectionUtils.optional(ArrayUtils.copyOf(this.value()));
    }

    public String[] orElse(String[] other) {
        String[] x = this.value();
        return x != null ? x : other;
    }

    private String[] value() {
        if (this.supplier != null) {
            String[] v = this.supplier.get();
            return v != null ? v : EMPTY;
        }
        return this.value;
    }
}

