/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.juneau.UriResolver;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.serializer.SerializeException;

@FluentSetters
public class SerializerWriter
extends Writer {
    protected final Writer out;
    protected final boolean useWhitespace;
    protected final int maxIndent;
    protected final boolean trimStrings;
    protected final char quoteChar;
    protected final UriResolver uriResolver;

    public SerializerWriter(Writer out, boolean useWhitespace, int maxIndent, boolean trimStrings, char quoteChar, UriResolver uriResolver) {
        this.out = out;
        this.useWhitespace = useWhitespace;
        this.maxIndent = maxIndent;
        this.trimStrings = trimStrings;
        this.quoteChar = quoteChar;
        this.uriResolver = uriResolver;
    }

    @FluentSetter
    public SerializerWriter cr(int depth) {
        if (this.useWhitespace && depth <= this.maxIndent) {
            return this.nl(depth).i(depth);
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter cre(int depth) {
        if (this.useWhitespace && depth <= this.maxIndent - 1) {
            return this.nl(depth).i(depth);
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter appendln(int indent, String value) {
        return this.append(indent, true, value);
    }

    @FluentSetter
    public SerializerWriter appendln(String value) {
        return this.append(0, true, value);
    }

    @FluentSetter
    public SerializerWriter append(int indent, String value) {
        return this.append(indent, false, value);
    }

    @FluentSetter
    public SerializerWriter append(int indent, char value) {
        return this.i(indent).w(value);
    }

    private SerializerWriter append(int indent, boolean newline, String value) {
        if (value == null) {
            return this;
        }
        if (value.indexOf(10) != -1 && this.useWhitespace && indent <= this.maxIndent) {
            StringTokenizer st = new StringTokenizer(value, "\n");
            while (st.hasMoreTokens()) {
                this.i(indent).w(st.nextToken()).w("\n");
            }
        } else {
            this.i(indent).w(value);
        }
        if (newline) {
            this.nl(indent);
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter appendUri(Object value) {
        this.uriResolver.append(this, value);
        return this;
    }

    @FluentSetter
    public SerializerWriter append(char[] value) {
        for (char c : value) {
            this.w(c);
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter s() {
        if (this.useWhitespace) {
            this.w(' ');
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter q() {
        this.w(this.quoteChar);
        return this;
    }

    @FluentSetter
    public SerializerWriter i(int indent) {
        if (this.useWhitespace && indent <= this.maxIndent) {
            for (int i = 0; i < indent; ++i) {
                this.w('\t');
            }
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter ie(int indent) {
        if (this.useWhitespace && indent <= this.maxIndent - 1) {
            for (int i = 0; i < indent; ++i) {
                this.w('\t');
            }
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter nl(int indent) {
        if (this.useWhitespace && indent <= this.maxIndent) {
            this.w('\n');
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter sIf(boolean flag) {
        if (flag && !this.useWhitespace) {
            this.w(' ');
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter nlIf(boolean flag, int indent) {
        if (flag && this.useWhitespace && indent <= this.maxIndent) {
            this.w('\n');
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter append(Object value) {
        this.w(value == null ? null : value.toString());
        return this;
    }

    @FluentSetter
    public SerializerWriter append(String value) {
        if (value != null) {
            this.w(value);
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter appendIf(boolean flag, String value) {
        if (flag) {
            this.w(value);
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter appendIf(boolean flag, char value) {
        if (flag) {
            this.w(value);
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter w(char value) {
        try {
            this.out.write(value);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return this;
    }

    @FluentSetter
    public SerializerWriter w(String value) {
        try {
            this.out.write(value);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return this;
    }

    @Override
    public SerializerWriter append(char c) {
        try {
            this.out.write(c);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        try {
            this.out.write(cbuf, off, len);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

