/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.MediaType;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.AsciiSet;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParserSession;
import org.apache.juneau.swap.BuilderSwap;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonReader;

public class UonParserSession
extends ReaderParserSession
implements HttpPartParserSession {
    private static final AsciiSet escapedChars = AsciiSet.create((String)"~'\u0001\u0002");
    private static final char AMP = '\u0001';
    private static final char EQ = '\u0002';
    private final UonParser ctx;
    private final boolean decoding;
    private static final AsciiSet endCharsParam = AsciiSet.create((String)"\u0001");
    private static final AsciiSet endCharsNormal = AsciiSet.create((String)",)\u0001");

    public static Builder create(UonParser ctx) {
        return new Builder(ctx);
    }

    protected UonParserSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.decoding = builder.decoding;
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        try (UonReader r = this.getUonReader(pipe, this.decoding);){
            T o = this.parseAnything(type, r, this.getOuter(), true, null);
            this.validateEnd(r);
            T t = o;
            return t;
        }
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        try (UonReader r = this.getUonReader(pipe, this.decoding);){
            m = this.parseIntoMap(r, m, this.getClassMeta(keyType, new Type[0]), this.getClassMeta(valueType, new Type[0]), null);
            this.validateEnd(r);
            Map<K, V> map = m;
            return map;
        }
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws Exception {
        try (UonReader r = this.getUonReader(pipe, this.decoding);){
            c = this.parseIntoCollection(r, c, this.getClassMeta(elementType, new Type[0]), false, null);
            this.validateEnd(r);
            Collection<E> collection = c;
            return collection;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T parse(HttpPartType partType, HttpPartSchema schema, String in, ClassMeta<T> toType) throws ParseException, SchemaValidationException {
        if (in == null) {
            return null;
        }
        if (toType.isString() && in.length() > 0) {
            char x = StringUtils.firstNonWhitespaceChar((String)in);
            if (x != '\'' && x != 'n' && in.indexOf(126) == -1) {
                return (T)in;
            }
            if (x == 'n' && "null".equals(in)) {
                return null;
            }
        }
        try (ParserPipe pipe = this.createPipe(in);){
            T t;
            block19: {
                UonReader r = this.getUonReader(pipe, false);
                try {
                    t = this.parseAnything(toType, r, null, true, null);
                    if (r == null) break block19;
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                r.close();
            }
            return t;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T parseAnything(ClassMeta<?> eType, UonReader r, Object outer, boolean isUrlParamValue, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        if (eType == null) {
            eType = this.object();
        }
        ObjectSwap<Object, ?> swap = eType.getSwap(this);
        BuilderSwap<Object, Object> builder = eType.getBuilderSwap(this);
        ClassMeta<Object> sType = null;
        sType = builder != null ? builder.getBuilderClassMeta(this) : (swap != null ? swap.getSwapClassMeta(this) : eType);
        if (sType.isOptional()) {
            return (T)CollectionUtils.optional(this.parseAnything(eType.getElementType(), r, outer, isUrlParamValue, pMeta));
        }
        this.setCurrentClass(sType);
        Object o = null;
        int c = r.peekSkipWs();
        if (c == -1 || c == 1) {
            if (sType.isCollectionOrArray()) {
                o = sType.newInstance();
            } else if (sType.isString() || sType.isObject()) {
                o = "";
            } else if (sType.isPrimitive()) {
                o = sType.getPrimitiveDefault();
            }
        } else if (sType.isVoid()) {
            String string = this.parseString(r, isUrlParamValue);
            if (string != null) {
                throw new ParseException((ParserSession)this, "Expected ''null'' for void value, but was ''{0}''.", string);
            }
        } else if (sType.isObject()) {
            if (c == 40) {
                JsonMap jsonMap = new JsonMap(this);
                this.parseIntoMap(r, jsonMap, this.string(), this.object(), pMeta);
                o = this.cast(jsonMap, pMeta, eType);
            } else if (c == 64) {
                JsonList jsonList = new JsonList(this);
                o = this.parseIntoCollection(r, jsonList, sType, isUrlParamValue, pMeta);
            } else {
                String string = this.parseString(r, isUrlParamValue);
                if (c != 39) {
                    if ("true".equals(string) || "false".equals(string)) {
                        o = Boolean.valueOf(string);
                    } else if (!"null".equals(string)) {
                        o = StringUtils.isNumeric((String)string) ? StringUtils.parseNumber((String)string, Number.class) : string;
                    }
                } else {
                    o = string;
                }
            }
        } else if (sType.isBoolean()) {
            o = this.parseBoolean(r);
        } else if (sType.isCharSequence()) {
            o = this.parseString(r, isUrlParamValue);
        } else if (sType.isChar()) {
            o = StringUtils.parseCharacter((Object)this.parseString(r, isUrlParamValue));
        } else if (sType.isNumber()) {
            o = this.parseNumber(r, sType.getInnerClass());
        } else if (sType.isMap()) {
            Map map = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : this.newGenericMap(sType);
            o = this.parseIntoMap(r, map, sType.getKeyType(), sType.getValueType(), pMeta);
        } else if (sType.isCollection()) {
            if (c == 40) {
                JsonMap jsonMap = new JsonMap(this);
                this.parseIntoMap(r, jsonMap, this.string(), this.object(), pMeta);
                if (jsonMap.containsKey(this.getBeanTypePropertyName(sType))) {
                    o = this.cast(jsonMap, pMeta, eType);
                } else {
                    Collection<Object> l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new JsonList(this);
                    l.add(jsonMap.cast(sType.getElementType()));
                    o = l;
                }
            } else {
                Collection<Object> collection = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new JsonList(this);
                o = this.parseIntoCollection(r, collection, sType, isUrlParamValue, pMeta);
            }
        } else if (builder != null) {
            BeanMap<?> beanMap2 = this.toBeanMap(builder.create(this, eType));
            beanMap2 = this.parseIntoBeanMap(r, beanMap2);
            o = beanMap2 == null ? null : builder.build(this, beanMap2.getBean(), eType);
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap<Object> beanMap3 = this.newBeanMap(outer, sType.getInnerClass());
            beanMap3 = this.parseIntoBeanMap(r, beanMap3);
            o = beanMap3 == null ? null : beanMap3.getBean();
        } else if (sType.canCreateNewInstanceFromString(outer)) {
            String string = this.parseString(r, isUrlParamValue);
            if (string != null) {
                o = sType.newInstanceFromString(outer, string);
            }
        } else if (sType.isArray() || sType.isArgs()) {
            if (c == 40) {
                JsonMap jsonMap = new JsonMap(this);
                this.parseIntoMap(r, jsonMap, this.string(), this.object(), pMeta);
                if (jsonMap.containsKey(this.getBeanTypePropertyName(sType))) {
                    o = this.cast(jsonMap, pMeta, eType);
                } else {
                    ArrayList<?> l = CollectionUtils.list(1);
                    l.add(jsonMap.cast(sType.getElementType()));
                    o = this.toArray(sType, l);
                }
            } else {
                ArrayList arrayList = (ArrayList)this.parseIntoCollection(r, CollectionUtils.list(new Object[0]), sType, isUrlParamValue, pMeta);
                o = this.toArray(sType, arrayList);
            }
        } else if (c == 40) {
            JsonMap jsonMap = new JsonMap(this);
            this.parseIntoMap(r, jsonMap, this.string(), this.object(), pMeta);
            if (jsonMap.containsKey(this.getBeanTypePropertyName(sType))) {
                o = this.cast(jsonMap, pMeta, eType);
            } else {
                if (sType.getProxyInvocationHandler() == null) throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
                o = this.newBeanMap(outer, sType.getInnerClass()).load(jsonMap).getBean();
            }
        } else {
            if (c != 110) throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
            r.read();
            this.parseNull(r);
        }
        if (o == null && sType.isPrimitive()) {
            o = sType.getPrimitiveDefault();
        }
        if (swap != null && o != null) {
            o = this.unswap(swap, o, eType);
        }
        if (outer == null) return (T)o;
        UonParserSession.setParent(eType, o, outer);
        return (T)o;
    }

    private <K, V> Map<K, V> parseIntoMap(UonReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        int c;
        if (keyType == null) {
            keyType = this.string();
        }
        if ((c = r.read()) == -1 || c == 1) {
            return null;
        }
        if (c == 110) {
            return (Map)this.parseNull(r);
        }
        if (c != 40) {
            throw new ParseException((ParserSession)this, "Expected '(' at beginning of object.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        Object currAttr = null;
        while (c != -1 && c != 1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == 41) {
                        return m;
                    }
                    if (Character.isWhitespace(c)) {
                        UonParserSession.skipSpace(r);
                    } else {
                        r.unread();
                        Object attr = this.parseAttr(r, this.decoding);
                        currAttr = attr == null ? null : (Object)this.convertAttrToType(m, this.trim(attr.toString()), keyType);
                        state = 2;
                        c = 0;
                    }
                } else if (state == 2) {
                    if (c == 2 || c == 61) {
                        state = 3;
                    } else if (c == -1 || c == 44 || c == 41 || c == 1) {
                        if (currAttr == null) {
                            r.unread();
                            return null;
                        }
                        m.put(currAttr, null);
                        if (c == 41 || c == -1 || c == 1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    Object value;
                    if (c == -1 || c == 44 || c == 41 || c == 1) {
                        value = this.convertAttrToType(m, "", valueType);
                        m.put(currAttr, value);
                        if (c == -1 || c == 41 || c == 1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        value = this.parseAnything(valueType, r.unread(), m, false, pMeta);
                        UonParserSession.setName(valueType, value, currAttr);
                        m.put(currAttr, value);
                        state = 4;
                        c = 0;
                    }
                } else if (state == 4) {
                    if (c == 44) {
                        state = 1;
                    } else if (c == 41 || c == -1 || c == 1) {
                        return m;
                    }
                }
            }
            isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
        }
        if (state == 1) {
            throw new ParseException((ParserSession)this, "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException((ParserSession)this, "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException((ParserSession)this, "Dangling '=' found in object entry", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException((ParserSession)this, "Could not find ')' marking end of object.", new Object[0]);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <E> Collection<E> parseIntoCollection(UonReader r, Collection<E> l, ClassMeta<E> type, boolean isUrlParamValue, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        boolean isInParens;
        int c = r.readSkipWs();
        if (c == -1 || c == 1) {
            return null;
        }
        if (c == 110) {
            return (Collection)this.parseNull(r);
        }
        int argIndex = 0;
        boolean bl = isInParens = c == 64;
        if (!isInParens) {
            if (!isUrlParamValue) throw new ParseException((ParserSession)this, "Could not find '(' marking beginning of collection.", new Object[0]);
            r.unread();
        } else {
            r.read();
        }
        if (isInParens) {
            boolean S1 = true;
            int S2 = 2;
            int S3 = 3;
            int state = 1;
            while (c != -1 && c != 1) {
                c = r.read();
                if (state == 1 || state == 2) {
                    if (c == 41) {
                        if (state != 2) return l;
                        l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, false, pMeta));
                        r.read();
                        return l;
                    }
                    if (Character.isWhitespace(c)) {
                        UonParserSession.skipSpace(r);
                        continue;
                    }
                    l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, false, pMeta));
                    state = 3;
                    continue;
                }
                if (state != 3) continue;
                if (c == 44) {
                    state = 2;
                    continue;
                }
                if (c != 41) continue;
                return l;
            }
            if (state == 1 || state == 2) {
                throw new ParseException((ParserSession)this, "Could not find start of entry in array.", new Object[0]);
            }
            if (state != 3) return null;
            throw new ParseException((ParserSession)this, "Could not find end of entry in array.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int state = 1;
        while (c != -1 && c != 1) {
            c = r.read();
            if (state == 1) {
                if (Character.isWhitespace(c)) {
                    UonParserSession.skipSpace(r);
                    continue;
                }
                l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, false, pMeta));
                state = 2;
                continue;
            }
            if (state != 2) continue;
            if (c == 44) {
                state = 1;
                continue;
            }
            if (Character.isWhitespace(c)) {
                UonParserSession.skipSpace(r);
                continue;
            }
            if (c != 1 && c != -1) continue;
            r.unread();
            return l;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BeanMap<T> parseIntoBeanMap(UonReader r, BeanMap<T> m) throws IOException, ParseException, ExecutableException {
        int c = r.readSkipWs();
        if (c == -1 || c == 1) {
            return null;
        }
        if (c == 110) {
            return (BeanMap)this.parseNull(r);
        }
        if (c != 40) {
            throw new ParseException((ParserSession)this, "Expected '(' at beginning of object.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        String currAttr = "";
        this.mark();
        try {
            while (c != -1 && c != 1) {
                c = r.read();
                if (!isInEscape) {
                    BeanMap<T> beanMap;
                    if (state == 1) {
                        if (c == 41 || c == -1 || c == 1) {
                            beanMap = m;
                            return beanMap;
                        }
                        if (Character.isWhitespace(c)) {
                            UonParserSession.skipSpace(r);
                        } else {
                            r.unread();
                            this.mark();
                            currAttr = this.parseAttrName(r, this.decoding);
                            if (currAttr == null) {
                                beanMap = null;
                                return beanMap;
                            }
                            state = 2;
                        }
                    } else if (state == 2) {
                        if (c == 2 || c == 61) {
                            state = 3;
                        } else if (c == -1 || c == 44 || c == 41 || c == 1) {
                            m.put(currAttr, (Object)null);
                            if (c == 41 || c == -1 || c == 1) {
                                beanMap = m;
                                return beanMap;
                            }
                            state = 1;
                        }
                    } else if (state == 3) {
                        Object pMeta;
                        if (c == -1 || c == 44 || c == 41 || c == 1) {
                            if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                                pMeta = m.getPropertyMeta(currAttr);
                                if (pMeta == null) {
                                    this.onUnknownProperty(currAttr, m, null);
                                    this.unmark();
                                } else {
                                    this.unmark();
                                    Object value = this.convertToType((Object)"", ((BeanPropertyMeta)pMeta).getClassMeta());
                                    try {
                                        ((BeanPropertyMeta)pMeta).set(m, currAttr, value);
                                    }
                                    catch (BeanRuntimeException e) {
                                        this.onBeanSetterException((BeanPropertyMeta)pMeta, e);
                                        throw e;
                                    }
                                }
                            }
                            if (c == -1 || c == 41 || c == 1) {
                                pMeta = m;
                                return pMeta;
                            }
                            state = 1;
                        } else {
                            if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                                pMeta = m.getPropertyMeta(currAttr);
                                if (pMeta == null) {
                                    this.onUnknownProperty(currAttr, m, this.parseAnything(this.object(), r.unread(), m.getBean(false), false, null));
                                    this.unmark();
                                } else {
                                    this.unmark();
                                    this.setCurrentProperty((BeanPropertyMeta)pMeta);
                                    ClassMeta<?> cm = ((BeanPropertyMeta)pMeta).getClassMeta();
                                    T value = this.parseAnything(cm, r.unread(), m.getBean(false), false, (BeanPropertyMeta)pMeta);
                                    UonParserSession.setName(cm, value, currAttr);
                                    try {
                                        ((BeanPropertyMeta)pMeta).set(m, currAttr, value);
                                    }
                                    catch (BeanRuntimeException e) {
                                        this.onBeanSetterException((BeanPropertyMeta)pMeta, e);
                                        throw e;
                                    }
                                    this.setCurrentProperty(null);
                                }
                            }
                            state = 4;
                        }
                    } else if (state == 4) {
                        if (c == 44) {
                            state = 1;
                        } else if (c == 41 || c == -1 || c == 1) {
                            beanMap = m;
                            return beanMap;
                        }
                    }
                }
                isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
            }
            if (state == 1) {
                throw new ParseException((ParserSession)this, "Could not find attribute name on object.", new Object[0]);
            }
            if (state == 2) {
                throw new ParseException((ParserSession)this, "Could not find '=' following attribute name on object.", new Object[0]);
            }
            if (state == 3) {
                throw new ParseException((ParserSession)this, "Could not find value following '=' on object.", new Object[0]);
            }
            if (state == 4) {
                throw new ParseException((ParserSession)this, "Could not find ')' marking end of object.", new Object[0]);
            }
        }
        finally {
            this.unmark();
        }
        return null;
    }

    private Object parseNull(UonReader r) throws IOException, ParseException {
        String s = this.parseString(r, false);
        if ("ull".equals(s)) {
            return null;
        }
        throw new ParseException((ParserSession)this, "Unexpected character sequence: ''{0}''", s);
    }

    protected final Object parseAttr(UonReader r, boolean encoded) throws IOException, ParseException {
        String attr = this.parseAttrName(r, encoded);
        return attr;
    }

    protected final String parseAttrName(UonReader r, boolean encoded) throws IOException, ParseException {
        int c = r.peekSkipWs();
        if (c == 39) {
            return this.parsePString(r);
        }
        r.mark();
        boolean isInEscape = false;
        if (encoded) {
            while (c != -1) {
                c = r.read();
                if (!isInEscape) {
                    if (c == 1 || c == 2 || c == -1 || Character.isWhitespace(c)) {
                        String s;
                        if (c != -1) {
                            r.unread();
                        }
                        return "null".equals(s = r.getMarked()) ? null : s;
                    }
                } else if (c == 1) {
                    r.replace('&');
                } else if (c == 2) {
                    r.replace('=');
                }
                isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
            }
        } else {
            while (c != -1) {
                c = r.read();
                if (!isInEscape && (c == 61 || c == -1 || Character.isWhitespace(c))) {
                    String s;
                    if (c != -1) {
                        r.unread();
                    }
                    return "null".equals(s = r.getMarked()) ? null : this.trim(s);
                }
                isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
            }
        }
        throw new ParseException((ParserSession)this, "Unexpected condition.", new Object[0]);
    }

    private static final boolean isInEscape(int c, ParserReader r, boolean prevIsInEscape) throws IOException {
        if (c == 126 && !prevIsInEscape && escapedChars.contains(c = r.peek())) {
            r.delete();
            return true;
        }
        return false;
    }

    protected final String parseString(UonReader r, boolean isUrlParamValue) throws IOException, ParseException {
        AsciiSet endChars;
        int c = r.peekSkipWs();
        if (c == 39) {
            return this.parsePString(r);
        }
        r.mark();
        boolean isInEscape = false;
        String s = null;
        AsciiSet asciiSet = endChars = isUrlParamValue ? endCharsParam : endCharsNormal;
        while (c != -1) {
            c = r.read();
            if (!isInEscape && endChars.contains(c)) {
                r.unread();
                c = -1;
            }
            if (c == -1) {
                s = r.getMarked();
            } else if (c == 2) {
                r.replace('=');
            } else if (Character.isWhitespace(c) && !isUrlParamValue) {
                s = r.getMarked(0, -1);
                UonParserSession.skipSpace(r);
                c = -1;
            }
            isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
        }
        if (isUrlParamValue) {
            s = StringUtils.trim(s);
        }
        return "null".equals(s) ? null : this.trim(s);
    }

    private String parsePString(UonReader r) throws IOException, ParseException {
        r.read();
        r.mark();
        int c = 0;
        boolean isInEscape = false;
        while (c != -1) {
            c = r.read();
            if (!isInEscape && c == 39) {
                return this.trim(r.getMarked(0, -1));
            }
            if (c == 2) {
                r.replace('=');
            }
            isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
        }
        throw new ParseException((ParserSession)this, "Unmatched parenthesis", new Object[0]);
    }

    private Boolean parseBoolean(UonReader r) throws IOException, ParseException {
        String s = this.parseString(r, false);
        if (s == null || s.equals("null")) {
            return null;
        }
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ParseException((ParserSession)this, "Unrecognized syntax for boolean.  ''{0}''.", s);
    }

    private Number parseNumber(UonReader r, Class<? extends Number> c) throws IOException, ParseException {
        String s = this.parseString(r, false);
        if (s == null) {
            return null;
        }
        return StringUtils.parseNumber((String)s, c);
    }

    private void validateEnd(UonReader r) throws IOException, ParseException {
        int c;
        if (!this.isValidateEnd()) {
            return;
        }
        do {
            if ((c = r.read()) != -1) continue;
            return;
        } while (Character.isWhitespace(c));
        throw new ParseException((ParserSession)this, "Remainder after parse: ''{0}''.", Character.valueOf((char)c));
    }

    private static void skipSpace(ParserReader r) throws IOException {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (c > 2 && Character.isWhitespace(c)) continue;
            r.unread();
            return;
        }
    }

    public final UonReader getUonReader(ParserPipe pipe, boolean decodeChars) throws IOException {
        Reader r = pipe.getReader();
        if (r instanceof UonReader) {
            return (UonReader)r;
        }
        return new UonReader(pipe, decodeChars);
    }

    protected final boolean isDecoding() {
        return this.decoding;
    }

    protected final boolean isValidateEnd() {
        return this.ctx.isValidateEnd();
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap("decoding", this.decoding);
    }

    @FluentSetters
    public static class Builder
    extends ReaderParserSession.Builder {
        UonParser ctx;
        boolean decoding;

        protected Builder(UonParser ctx) {
            super(ctx);
            this.ctx = ctx;
            this.decoding = ctx.decoding;
        }

        @Override
        public UonParserSession build() {
            return new UonParserSession(this);
        }

        @FluentSetter
        public Builder decoding(boolean value) {
            this.decoding = value;
            return this;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder outer(Object value) {
            super.outer(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }
    }
}

