/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="title,description,version,contact,license,termsOfService,*")
@FluentSetters
public class Info
extends OpenApiElement {
    private String title;
    private String description;
    private String termsOfService;
    private String version;
    private Contact contact;
    private License license;

    public Info() {
    }

    public Info(Info copyFrom) {
        super(copyFrom);
        this.title = copyFrom.title;
        this.description = copyFrom.description;
        this.termsOfService = copyFrom.termsOfService;
        this.version = copyFrom.version;
        this.contact = copyFrom.contact == null ? null : copyFrom.contact.copy();
        this.license = copyFrom.license == null ? null : copyFrom.license.copy();
    }

    public Info copy() {
        return new Info(this);
    }

    public String getTitle() {
        return this.title;
    }

    public Info setTitle(String value) {
        this.title = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Info setDescription(String value) {
        this.description = value;
        return this;
    }

    public String getTermsOfService() {
        return this.termsOfService;
    }

    public Info setTermsOfService(String value) {
        this.termsOfService = value;
        return this;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Info setContact(Contact value) {
        this.contact = value;
        return this;
    }

    public License getLicense() {
        return this.license;
    }

    public Info setLicense(License value) {
        this.license = value;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Info setVersion(String value) {
        this.version = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "title": {
                return (T)ConverterUtils.toType((Object)this.getTitle(), type);
            }
            case "description": {
                return (T)ConverterUtils.toType((Object)this.getDescription(), type);
            }
            case "termsOfService": {
                return (T)ConverterUtils.toType((Object)this.getTermsOfService(), type);
            }
            case "contact": {
                return (T)ConverterUtils.toType((Object)this.getContact(), type);
            }
            case "license": {
                return (T)ConverterUtils.toType((Object)this.getLicense(), type);
            }
            case "version": {
                return (T)ConverterUtils.toType((Object)this.getVersion(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Info set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "title": {
                return this.setTitle(StringUtils.stringify((Object)value));
            }
            case "description": {
                return this.setDescription(StringUtils.stringify((Object)value));
            }
            case "termsOfService": {
                return this.setTermsOfService(StringUtils.stringify((Object)value));
            }
            case "contact": {
                return this.setContact((Contact)ConverterUtils.toType((Object)value, Contact.class));
            }
            case "license": {
                return this.setLicense((License)ConverterUtils.toType((Object)value, License.class));
            }
            case "version": {
                return this.setVersion(StringUtils.stringify((Object)value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).addIf(this.title != null, (Object)"title").addIf(this.description != null, (Object)"description").addIf(this.termsOfService != null, (Object)"termsOfService").addIf(this.contact != null, (Object)"contact").addIf(this.license != null, (Object)"license").addIf(this.version != null, (Object)"version").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }
}

