/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.Set;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.openapi3.OAuthFlow;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="in,name,type,description,scheme,bearerFormat,flows,*")
@FluentSetters
public class SecuritySchemeInfo
extends OpenApiElement {
    private static final String[] VALID_IN = new String[]{"query", "header", "cookie"};
    private static final String[] VALID_TYPES = new String[]{"apiKey", "http", "oauth2", "openIdConnect"};
    private String type;
    private String description;
    private String name;
    private String in;
    private String scheme;
    private String bearerFormat;
    private String openIdConnectUrl;
    private OAuthFlow flows;

    public SecuritySchemeInfo() {
    }

    public SecuritySchemeInfo(SecuritySchemeInfo copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.in = copyFrom.in;
        this.description = copyFrom.description;
        this.type = copyFrom.type;
        this.scheme = copyFrom.scheme;
        this.bearerFormat = copyFrom.bearerFormat;
        this.openIdConnectUrl = copyFrom.openIdConnectUrl;
        this.flows = copyFrom.flows;
    }

    public SecuritySchemeInfo copy() {
        return new SecuritySchemeInfo(this);
    }

    @Override
    protected SecuritySchemeInfo strict() {
        super.strict();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public SecuritySchemeInfo setName(String value) {
        this.name = value;
        return this;
    }

    public String getIn() {
        return this.in;
    }

    public SecuritySchemeInfo setIn(String value) {
        if (this.isStrict() && !ArrayUtils.contains(value, VALID_IN)) {
            throw new BasicRuntimeException("Invalid value passed in to setIn(String).  Value=''{0}'', valid values={1}", value, VALID_IN);
        }
        this.in = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SecuritySchemeInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public SecuritySchemeInfo setScheme(String value) {
        this.scheme = value;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SecuritySchemeInfo setType(String value) {
        if (this.isStrict() && !ArrayUtils.contains(value, VALID_TYPES)) {
            throw new BasicRuntimeException("Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", value, VALID_TYPES);
        }
        this.type = value;
        return this;
    }

    public String getBearerFormat() {
        return this.bearerFormat;
    }

    public SecuritySchemeInfo setBearerFormat(String value) {
        this.bearerFormat = value;
        return this;
    }

    public OAuthFlow getFlows() {
        return this.flows;
    }

    public SecuritySchemeInfo setFlows(OAuthFlow value) {
        this.flows = value;
        return this;
    }

    public String getOpenIdConnectUrl() {
        return this.openIdConnectUrl;
    }

    public SecuritySchemeInfo setOpenIdConnectUrl(String value) {
        this.openIdConnectUrl = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "name": {
                return ConverterUtils.toType(this.getName(), type);
            }
            case "in": {
                return ConverterUtils.toType(this.getIn(), type);
            }
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "scheme": {
                return ConverterUtils.toType(this.getScheme(), type);
            }
            case "flows": {
                return ConverterUtils.toType(this.getFlows(), type);
            }
            case "bearerFormat": {
                return ConverterUtils.toType(this.getBearerFormat(), type);
            }
            case "openIdConnectUrl": {
                return ConverterUtils.toType(this.getOpenIdConnectUrl(), type);
            }
            case "type": {
                return ConverterUtils.toType(this.getType(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public SecuritySchemeInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "name": {
                return this.setName(StringUtils.stringify(value));
            }
            case "in": {
                return this.setIn(StringUtils.stringify(value));
            }
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "scheme": {
                return this.setScheme(StringUtils.stringify(value));
            }
            case "bearerFormat": {
                return this.setBearerFormat(StringUtils.stringify(value));
            }
            case "type": {
                return this.setType(StringUtils.stringify(value));
            }
            case "flows": {
                return this.setFlows(ConverterUtils.toType(value, OAuthFlow.class));
            }
            case "openIdConnectUrl": {
                return this.setOpenIdConnectUrl(StringUtils.stringify(value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.name != null, "name").addIf(this.in != null, "in").addIf(this.description != null, "description").addIf(this.scheme != null, "scheme").addIf(this.bearerFormat != null, "bearerFormat").addIf(this.type != null, "type").addIf(this.flows != null, "flows").addIf(this.openIdConnectUrl != null, "openIdConnectUrl").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

