/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_orchestra.renderkit.html;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.shared_orchestra.config.MyfacesConfig;
import org.apache.myfaces.shared_orchestra.renderkit.RendererUtils;
import org.apache.myfaces.shared_orchestra.renderkit.html.HTML;
import org.apache.myfaces.shared_orchestra.renderkit.html.HtmlFormRendererBase;
import org.apache.myfaces.shared_orchestra.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_orchestra.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_orchestra.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_orchestra.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.shared_orchestra.renderkit.html.util.JavascriptUtils;

public abstract class HtmlLinkRendererBase
extends HtmlRenderer {
    public static final String URL_STATE_MARKER = "JSF_URL_STATE_MARKER=DUMMY";
    public static final int URL_STATE_MARKER_LEN = "JSF_URL_STATE_MARKER=DUMMY".length();

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        if (component instanceof UICommand) {
            String clientId = component.getClientId(facesContext);
            FormInfo formInfo = this.findNestingForm(component, facesContext);
            String reqValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName(formInfo));
            if (reqValue != null && reqValue.equals(clientId)) {
                component.queueEvent((FacesEvent)new ActionEvent(component));
                RendererUtils.initPartialValidationAndModelUpdate(component, facesContext);
            }
        } else if (!(component instanceof UIOutput)) {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeBegin(facesContext, component);
        if (component instanceof UICommand) {
            this.renderCommandLinkStart(facesContext, component, component.getClientId(facesContext), ((UICommand)component).getValue(), this.getStyle(facesContext, component), this.getStyleClass(facesContext, component));
        } else if (component instanceof UIOutput) {
            this.renderOutputLinkStart(facesContext, (UIOutput)component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected String getStyle(FacesContext facesContext, UIComponent link) {
        if (link instanceof HtmlCommandLink) {
            return ((HtmlCommandLink)link).getStyle();
        }
        return (String)link.getAttributes().get("style");
    }

    protected String getStyleClass(FacesContext facesContext, UIComponent link) {
        if (link instanceof HtmlCommandLink) {
            return ((HtmlCommandLink)link).getStyleClass();
        }
        return (String)link.getAttributes().get("styleClass");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.renderChildren(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        if (component instanceof UICommand) {
            this.renderCommandLinkEnd(facesContext, component);
            HtmlFormRendererBase.renderScrollHiddenInputIfNecessary(this.findNestingForm(component, facesContext).getForm(), facesContext, facesContext.getResponseWriter());
        } else if (component instanceof UIOutput) {
            this.renderOutputLinkEnd(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected void renderCommandLinkStart(FacesContext facesContext, UIComponent component, String clientId, Object value, String style, String styleClass) throws IOException {
        String[] anchorAttrsToRender;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            this.renderJavaScriptAnchorStart(facesContext, writer, component, clientId);
            anchorAttrsToRender = HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_ONCLICK_WITHOUT_STYLE;
        } else {
            this.renderNonJavaScriptAnchorStart(facesContext, writer, component, clientId);
            anchorAttrsToRender = HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_STYLE;
        }
        writer.writeAttribute("id", (Object)clientId, null);
        HtmlRendererUtils.renderHTMLAttributes(writer, component, anchorAttrsToRender);
        HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)style);
        HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)styleClass);
        if (value != null) {
            writer.writeText((Object)value.toString(), "value");
        }
    }

    protected void renderJavaScriptAnchorStart(FacesContext facesContext, ResponseWriter writer, UIComponent component, String clientId) throws IOException {
        FormInfo formInfo = this.findNestingForm(component, facesContext);
        if (formInfo == null) {
            String path = RendererUtils.getPathToComponent(component);
            String msg = "Link is not embedded in a form. Change component/tag '" + clientId + "' from javax.faces.*/<h:tagName /> " + "to org.apache.myfaces.*/<t:tagName />, or embed it in a form.  This is not a bug. " + "Please see: http://wiki.apache.org/myfaces/Upgrading_to_Tomahawk_1.1.3 " + "The path to this component is " + path + ". If you need to render a special form and a JSF-form's attributes are not enough," + "consider using the s:form tag of the MyFaces sandbox.";
            throw new IllegalArgumentException(msg);
        }
        UIComponent nestingForm = formInfo.getForm();
        String formName = formInfo.getFormName();
        StringBuffer onClick = new StringBuffer();
        String commandOnclick = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getOnclick() : (String)component.getAttributes().get("onclick");
        if (commandOnclick != null) {
            onClick.append(commandOnclick);
            onClick.append(';');
        }
        if (RendererUtils.isAdfOrTrinidadForm(formInfo.getForm())) {
            onClick.append("submitForm('");
            onClick.append(formInfo.getForm().getClientId(facesContext));
            onClick.append("',1,{source:'");
            onClick.append(component.getClientId(facesContext));
            onClick.append("'");
            onClick.append(this.getChildParametersTrinidad(component));
            onClick.append("});return false;");
        } else {
            HtmlRendererUtils.renderFormSubmitScript(facesContext);
            StringBuffer params = this.addChildParameters(component, nestingForm);
            String target = this.getTarget(component);
            onClick.append("return ").append("oamSubmitForm").append("('").append(formName).append("','").append(clientId).append("'");
            if (params.length() > 2 || target != null) {
                onClick.append(",").append(target == null ? "null" : "'" + target + "'").append(",").append(params);
            }
            onClick.append(");");
            String hiddenFieldName = HtmlRendererUtils.getHiddenCommandLinkFieldName(formInfo);
            this.addHiddenCommandParameter(facesContext, nestingForm, hiddenFieldName);
            String hiddenFieldNameMyFacesOld = HtmlRendererUtils.getHiddenCommandLinkFieldNameMyfacesOld(formInfo);
            this.addHiddenCommandParameter(facesContext, nestingForm, hiddenFieldNameMyFacesOld);
        }
        writer.startElement("a", component);
        writer.writeURIAttribute("href", (Object)"#", null);
        writer.writeAttribute("onclick", (Object)onClick.toString(), null);
    }

    private String getTarget(UIComponent component) {
        String target = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getTarget() : (String)component.getAttributes().get("target");
        return target;
    }

    private String getChildParametersTrinidad(UIComponent component) {
        StringBuffer params = new StringBuffer();
        for (UIComponent child : this.getChildren(component)) {
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            if (name == null) {
                throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
            }
            Object value = ((UIParameter)child).getValue();
            String strParamValue = value != null ? HTMLEncoder.encode(value.toString(), false, false) : "";
            params.append(",'");
            params.append(name);
            params.append("':'");
            params.append(strParamValue);
            params.append("'");
        }
        return params.toString();
    }

    private StringBuffer addChildParameters(UIComponent component, UIComponent nestingForm) {
        StringBuffer params = new StringBuffer();
        params.append("[");
        for (UIComponent child : this.getChildren(component)) {
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            if (name == null) {
                throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
            }
            this.addHiddenCommandParameter(FacesContext.getCurrentInstance(), nestingForm, name);
            Object value = ((UIParameter)child).getValue();
            String strParamValue = "";
            if (value != null) {
                strParamValue = value.toString();
                StringBuffer buff = null;
                for (int i = 0; i < strParamValue.length(); ++i) {
                    char c = strParamValue.charAt(i);
                    if (c == '\'' || c == '\\') {
                        if (buff == null) {
                            buff = new StringBuffer();
                            buff.append(strParamValue.substring(0, i));
                        }
                        buff.append('\\');
                        buff.append(c);
                        continue;
                    }
                    if (buff == null) continue;
                    buff.append(c);
                }
                if (buff != null) {
                    strParamValue = buff.toString();
                }
            }
            if (params.length() > 1) {
                params.append(",");
            }
            params.append("['");
            params.append(name);
            params.append("','");
            params.append(strParamValue);
            params.append("']");
        }
        params.append("]");
        return params;
    }

    protected FormInfo findNestingForm(UIComponent uiComponent, FacesContext facesContext) {
        return RendererUtils.findNestingForm(uiComponent, facesContext);
    }

    protected void addHiddenCommandParameter(FacesContext facesContext, UIComponent nestingForm, String hiddenFieldName) {
        if (nestingForm != null) {
            HtmlFormRendererBase.addHiddenCommandParameter(facesContext, nestingForm, hiddenFieldName);
        }
    }

    protected void renderNonJavaScriptAnchorStart(FacesContext facesContext, ResponseWriter writer, UIComponent component, String clientId) throws IOException {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String path = viewHandler.getActionURL(facesContext, viewId);
        boolean strictXhtmlLinks = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isStrictXhtmlLinks();
        StringBuffer hrefBuf = new StringBuffer(path);
        if (path.indexOf(63) == -1) {
            hrefBuf.append('?');
        } else if (strictXhtmlLinks) {
            hrefBuf.append("&amp;");
        } else {
            hrefBuf.append('&');
        }
        String hiddenFieldName = HtmlRendererUtils.getHiddenCommandLinkFieldName(this.findNestingForm(component, facesContext));
        hrefBuf.append(hiddenFieldName);
        hrefBuf.append('=');
        hrefBuf.append(clientId);
        if (this.getChildCount(component) > 0) {
            this.addChildParametersToHref(facesContext, component, hrefBuf, false, writer.getCharacterEncoding());
        }
        StateManager stateManager = facesContext.getApplication().getStateManager();
        if (strictXhtmlLinks) {
            hrefBuf.append("&amp;");
        } else {
            hrefBuf.append('&');
        }
        if (stateManager.isSavingStateInClient(facesContext)) {
            hrefBuf.append(URL_STATE_MARKER);
        }
        String href = facesContext.getExternalContext().encodeActionURL(hrefBuf.toString());
        writer.startElement("a", component);
        writer.writeURIAttribute("href", (Object)facesContext.getExternalContext().encodeActionURL(href), null);
    }

    private void addChildParametersToHref(FacesContext facesContext, UIComponent linkComponent, StringBuffer hrefBuf, boolean firstParameter, String charEncoding) throws IOException {
        boolean strictXhtmlLinks = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isStrictXhtmlLinks();
        for (UIComponent child : this.getChildren(linkComponent)) {
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            Object value = ((UIParameter)child).getValue();
            HtmlLinkRendererBase.addParameterToHref(name, value, hrefBuf, firstParameter, charEncoding, strictXhtmlLinks);
            firstParameter = false;
        }
    }

    protected void renderOutputLinkStart(FacesContext facesContext, UIOutput output) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String href = RendererUtils.getStringValue(facesContext, (UIComponent)output);
        int index = href.indexOf(35);
        String anchorString = null;
        if (index > -1) {
            anchorString = href.substring(index, href.length());
            href = href.substring(0, index);
        }
        if (this.getChildCount((UIComponent)output) > 0) {
            StringBuffer hrefBuf = new StringBuffer(href);
            this.addChildParametersToHref(facesContext, (UIComponent)output, hrefBuf, href.indexOf(63) == -1, writer.getCharacterEncoding());
            href = hrefBuf.toString();
        }
        if (index > -1) {
            href = href + anchorString;
        }
        href = facesContext.getExternalContext().encodeResourceURL(href);
        String clientId = output.getClientId(facesContext);
        writer.startElement("a", (UIComponent)output);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeURIAttribute("href", (Object)href, null);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
        writer.flush();
    }

    private static void addParameterToHref(String name, Object value, StringBuffer hrefBuf, boolean firstParameter, String charEncoding, boolean strictXhtmlLinks) throws UnsupportedEncodingException {
        if (name == null) {
            throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
        }
        if (firstParameter) {
            hrefBuf.append('?');
        } else if (strictXhtmlLinks) {
            hrefBuf.append("&amp;");
        } else {
            hrefBuf.append('&');
        }
        hrefBuf.append(URLEncoder.encode(name, charEncoding));
        hrefBuf.append('=');
        if (value != null) {
            hrefBuf.append(URLEncoder.encode(value.toString(), charEncoding));
        }
    }

    protected void renderOutputLinkEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.writeText((Object)"", null);
        writer.endElement("a");
    }

    protected void renderCommandLinkEnd(FacesContext facesContext, UIComponent component) throws IOException {
        this.renderOutputLinkEnd(facesContext, component);
    }
}

