/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.viewController.annotations;

import java.lang.annotation.Target;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Defines a class as ViewController to receive ViewController events for
 * the given viewId(s).
 * <p>
 * This requires that the Orchestra ViewController is active, and that the
 * AnnotationsViewControllerNameMapper is in use.
 * <p>
 * This annotation is an alternative to using the "bean name matches viewid"
 * approach of the DefaultViewControllerNameMapper.
 * <p>
 * Whether this is the best approach to pairing a view with a controller bean
 * depends upon the project. This does cause tight coupling between bean and
 * view; moving a view requires modifying the bean. This is not appropriate for
 * a project where "ui designer" and "code developer" roles are separated. However
 * for other projects where the same person plays both roles then using this
 * annotation reduces the amount of configuration required. 
 */
@Target(value = {ElementType.TYPE})
@Retention(value = RetentionPolicy.RUNTIME)
public @interface ViewController
{
    /**
     * the ViewIds the bean is responsible for
     */
    String[] viewIds() default {};
}
