/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.EncodeUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        RenderUtils.decodeScrollPosition(facesContext, component);
        AbstractUITree tree = (AbstractUITree)component;
        RenderUtils.decodedStateOfTreeData(facesContext, (AbstractUIData)tree);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUITree tree = (AbstractUITree)component;
        String clientId = tree.getClientId(facesContext);
        UIComponent root = ComponentUtils.findDescendant((UIComponent)tree, UITreeNode.class);
        if (root == null) {
            LOG.error("Can't find the tree root. This may occur while updating a tree from Tobago 1.0 to 1.5. Please refer the documentation to see how to use tree tags.");
            return;
        }
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("div", (UIComponent)tree);
        writer.writeClassAttribute(Classes.create((UIComponent)tree));
        Style style = new Style(facesContext, (LayoutBase)tree);
        writer.writeStyleAttribute(style);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)tree);
        writer.writeAttribute("data-tobago-scroll-panel", "true", true);
        Selectable selectable = tree.getSelectableAsEnum();
        if (selectable.isSupportedByTree()) {
            writer.writeAttribute("data-tobago-selectable", selectable.getValue(), false);
        }
        SelectedState selectedState = tree.getSelectedState();
        StringBuilder selectedValue = new StringBuilder(",");
        ExpandedState expandedState = tree.getExpandedState();
        StringBuilder expandedValue = new StringBuilder(",");
        int last = tree.isRowsUnlimited() ? Integer.MAX_VALUE : tree.getFirst() + tree.getRows();
        for (int rowIndex = tree.getFirst(); rowIndex < last; ++rowIndex) {
            tree.setRowIndex(rowIndex);
            if (!tree.isRowAvailable()) break;
            TreePath path = tree.getPath();
            if (selectedState.isSelected(path)) {
                selectedValue.append(rowIndex);
                selectedValue.append(",");
            }
            if (tree.isFolder() && expandedState.isExpanded(path)) {
                expandedValue.append(rowIndex);
                expandedValue.append(",");
            }
            for (UIComponent child : tree.getChildren()) {
                EncodeUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)child);
                RenderUtils.encode(facesContext, child);
            }
        }
        tree.setRowIndex(-1);
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        String selectedId = clientId + "::" + "selected";
        writer.writeNameAttribute(selectedId);
        writer.writeIdAttribute(selectedId);
        writer.writeClassAttribute(Classes.create((UIComponent)tree, (String)"selected"));
        writer.writeAttribute("value", selectedValue.toString(), false);
        writer.endElement("input");
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", "hidden", false);
        String expandedId = clientId + "::" + "expanded";
        writer.writeNameAttribute(expandedId);
        writer.writeIdAttribute(expandedId);
        writer.writeClassAttribute(Classes.create((UIComponent)tree, (String)"expanded"));
        writer.writeAttribute("value", expandedValue.toString(), false);
        writer.endElement("input");
        RenderUtils.writeScrollPosition(facesContext, writer, (UIComponent)tree);
        writer.endElement("div");
    }

    public boolean getPrepareRendersChildren() {
        return true;
    }
}

