/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.component.UIPanel;
import org.apache.myfaces.tobago.component.UIReload;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanel;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Position;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(PanelRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIPanel component = (UIPanel)uiComponent;
        for (UIComponent child : component.getChildren()) {
            RenderUtils.encode(facesContext, child);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIComponent facetReload;
        AbstractUIPanel panel = (AbstractUIPanel)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String clientId = panel.getClientId(facesContext);
        writer.startElement("div", (UIComponent)panel);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(Classes.create((UIComponent)panel));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)panel);
        Style style = new Style(facesContext, (LayoutBase)panel);
        if (style.getPosition() == null) {
            style.setPosition(Position.RELATIVE);
        }
        writer.writeStyleAttribute(style);
        if (panel instanceof UIPanel && ((UIPanel)panel).getTip() != null) {
            writer.writeAttribute("title", ((UIPanel)panel).getTip(), true);
        }
        if (!FacesContextUtils.isAjax((FacesContext)facesContext) && (facetReload = panel.getFacet("reload")) != null && facetReload instanceof UIReload && facetReload.isRendered()) {
            UIReload update = (UIReload)facetReload;
            writer.writeAttribute("data-tobago-reload", Integer.toString(update.getFrequency()), false);
        }
        HtmlRendererUtils.renderCommandFacet((UIComponent)panel, facesContext, writer);
        HtmlRendererUtils.encodeContextMenu(facesContext, writer, (UIComponent)panel);
        Measure borderLeft = panel.getBorderLeft();
        Measure borderRight = panel.getBorderRight();
        Measure borderTop = panel.getBorderTop();
        Measure borderBottom = panel.getBorderBottom();
        if (borderLeft.greaterThan(Measure.ZERO) || borderRight.greaterThan(Measure.ZERO) || borderTop.greaterThan(Measure.ZERO) || borderBottom.greaterThan(Measure.ZERO)) {
            writer.startElement("div", (UIComponent)panel);
            writer.writeClassAttribute(Classes.create((UIComponent)panel, (String)"content"));
            Style inner = new Style(facesContext, (LayoutBase)panel);
            if (inner.getWidth() != null) {
                inner.setWidth(inner.getWidth().subtract(borderLeft).subtract(borderRight));
            }
            if (inner.getHeight() != null) {
                inner.setHeight(inner.getHeight().subtract(borderTop).subtract(borderBottom));
            }
            inner.setLeft(borderLeft);
            inner.setTop(borderTop);
            writer.writeStyleAttribute(inner);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        AbstractUIPanel panel = (AbstractUIPanel)component;
        Measure borderLeft = panel.getBorderLeft();
        Measure borderRight = panel.getBorderRight();
        Measure borderTop = panel.getBorderTop();
        Measure borderBottom = panel.getBorderBottom();
        if (borderLeft.greaterThan(Measure.ZERO) || borderRight.greaterThan(Measure.ZERO) || borderTop.greaterThan(Measure.ZERO) || borderBottom.greaterThan(Measure.ZERO)) {
            writer.endElement("div");
        }
        writer.endElement("div");
    }
}

