/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISegmentLayout;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.layout.MarginTokens;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SegmentLayoutRenderer
extends RendererBase {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUISegmentLayout layout = (AbstractUISegmentLayout)component;
        Markup markup = layout.getMarkup();
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(layout.getClientId(facesContext));
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        writer.writeClassAttribute((CssItem)TobagoClass.SEGMENT_LAYOUT, TobagoClass.SEGMENT_LAYOUT.createMarkup(markup), new CssItem[]{BootstrapClass.ROW, markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUISegmentLayout segmentLayout = (AbstractUISegmentLayout)component;
        if (!segmentLayout.isRendered()) {
            return;
        }
        List<UIComponent> children = ComponentUtils.findLayoutChildren((UIComponent)segmentLayout);
        BootstrapClass.Generator generator = new BootstrapClass.Generator(segmentLayout.getExtraSmall(), segmentLayout.getSmall(), segmentLayout.getMedium(), segmentLayout.getLarge(), segmentLayout.getExtraLarge(), MarginTokens.parse(segmentLayout.getMarginExtraSmall()), MarginTokens.parse(segmentLayout.getMarginSmall()), MarginTokens.parse(segmentLayout.getMarginMedium()), MarginTokens.parse(segmentLayout.getMarginLarge()), MarginTokens.parse(segmentLayout.getMarginExtraLarge()));
        for (UIComponent child : children) {
            if (!child.isRendered()) continue;
            this.encodeChild(facesContext, writer, generator, child);
        }
    }

    private void encodeChild(FacesContext facesContext, TobagoResponseWriter writer, BootstrapClass.Generator generator, UIComponent child) throws IOException {
        if (child instanceof SupportsLabelLayout && LabelLayout.isSegment(((SupportsLabelLayout)child).getLabelLayout())) {
            LabelLayout.setSegment(facesContext, LabelLayout.segmentLeft);
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
            LabelLayout.setSegment(facesContext, LabelLayout.segmentRight);
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
            LabelLayout.removeSegment(facesContext);
        } else {
            this.encodeDiv(facesContext, writer, generator, child);
            generator.next();
        }
    }

    private void encodeDiv(FacesContext facesContext, TobagoResponseWriter writer, BootstrapClass.Generator generator, UIComponent child) throws IOException {
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute((CssItem)null, (CssItem[])null, (CssItem[])generator.generate(child));
        child.encodeAll(facesContext);
        writer.endElement(HtmlElements.DIV);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }
}

