/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateType
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String STRING_DATE = "date";
    public static final String STRING_DATETIME_LOCAL = "datetime-local";
    public static final String STRING_MONTH = "month";
    public static final String STRING_TIME = "time";
    public static final String STRING_WEEK = "week";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_DATETIME_LOCAL_MILLIS = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String PATTERN_DATETIME_LOCAL_SECONDS = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String PATTERN_DATETIME_LOCAL = "yyyy-MM-dd'T'HH:mm";
    public static final String PATTERN_TIME_MILLIS = "HH:mm:ss.SSS";
    public static final String PATTERN_TIME_SECONDS = "HH:mm:ss";
    public static final String PATTERN_TIME = "HH:mm";
    public static final String PATTERN_MONTH = "yyyy-MM";
    public static final String PATTERN_WEEK = "yyyy-'W'ww";
    public static final DateType DATE = new DateType("date", "yyyy-MM-dd");
    public static final DateType DATETIME_LOCAL = new DateType("datetime-local", "yyyy-MM-dd'T'HH:mm");
    public static final DateType MONTH = new DateType("month", "yyyy-MM");
    public static final DateType TIME = new DateType("time", "HH:mm");
    public static final DateType WEEK = new DateType("week", "yyyy-'W'ww");
    private String name;
    private String pattern;

    public DateType(String name, String pattern) {
        this.name = name;
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public static DateType valueOf(String text) {
        switch (text) {
            case "date": {
                return DATE;
            }
            case "datetime-local": {
                return DATETIME_LOCAL;
            }
            case "month": {
                return MONTH;
            }
            case "time": {
                return TIME;
            }
            case "week": {
                return WEEK;
            }
        }
        LOG.error("Unknown date type '{}'", (Object)text);
        return null;
    }
}

