/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.model;

import java.util.EnumSet;
import java.util.Set;

public enum Selectable {
    none,
    multi,
    single,
    singleOrNone,
    multiLeafOnly,
    singleLeafOnly,
    sibling,
    siblingLeafOnly,
    multiCascade;

    public static final String NONE = "none";
    public static final String MULTI = "multi";
    public static final String SINGLE = "single";
    public static final String SINGLE_OR_NONE = "singleOrNone";
    public static final String MULTI_LEAF_ONLY = "multiLeafOnly";
    public static final String SINGLE_LEAF_ONLY = "singleLeafOnly";
    public static final String SIBLING = "sibling";
    public static final String SIBLING_LEAF_ONLY = "siblingLeafOnly";
    public static final String MULTI_CASCADE = "multiCascade";
    private static final Set<Selectable> SHEET_VALUES;
    private static final Set<Selectable> TREE_VALUES;
    private static final Set<Selectable> TREE_LISTBOX_VALUES;

    public static Selectable parse(Object name) throws IllegalArgumentException {
        if (name == null) {
            return null;
        }
        if (name instanceof Selectable) {
            return (Selectable)((Object)name);
        }
        return Selectable.valueOf(name.toString());
    }

    public boolean isLeafOnly() {
        return this == singleLeafOnly || this == multiLeafOnly || this == siblingLeafOnly;
    }

    public boolean isSingle() {
        return this == single || this == singleOrNone || this == singleLeafOnly;
    }

    public boolean isMulti() {
        return this == multi || this == multiLeafOnly || this == multiCascade;
    }

    public boolean isSupportedBySheet() {
        return SHEET_VALUES.contains((Object)this);
    }

    public boolean isSupportedByTree() {
        return TREE_VALUES.contains((Object)this);
    }

    public boolean isSupportedByTreeListbox() {
        return TREE_LISTBOX_VALUES.contains((Object)this);
    }

    static {
        SHEET_VALUES = EnumSet.of(none, multi, single, singleOrNone);
        TREE_VALUES = EnumSet.of(none, new Selectable[]{multi, single, multiLeafOnly, singleLeafOnly, multiCascade});
        TREE_LISTBOX_VALUES = EnumSet.of(single, singleLeafOnly, multiLeafOnly);
    }
}

