/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CoreShowDetail;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ShowDetailItemRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class ShowDetailRenderer
extends ShowDetailItemRenderer {
    private PropertyKey _immediateKey;
    private PropertyKey _disclosedTextKey;
    private PropertyKey _undisclosedTextKey;
    private static final Object _SHOW_DETAIL_SUBMIT_JS_RENDERED = new Object();
    private static final String _DISCLOSED_KEY = "af_showDetail.DISCLOSED";
    private static final String _UNDISCLOSED_KEY = "af_showDetail.UNDISCLOSED";
    private static final String _DISCLOSED_TIP_KEY = "af_showDetail.DISCLOSED_TIP";
    private static final String _UNDISCLOSED_TIP_KEY = "af_showDetail.UNDISCLOSED_TIP";
    private static final String[] PROMPT_LINK_STYLE_CLASSES = new String[]{"OraLink", "af|showDetail::prompt-link"};
    private static final String[] DISCLOSURE_ICON_LINK_STYLE_CLASSES = new String[]{"OraLink", "af|showDetail::disclosure-icon-link"};
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ShowDetailRenderer.class);

    public ShowDetailRenderer() {
        this(CoreShowDetail.TYPE);
    }

    protected ShowDetailRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._immediateKey = type.findKey("immediate");
        this._disclosedTextKey = type.findKey("disclosedText");
        this._undisclosedTextKey = type.findKey("undisclosedText");
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        String text;
        UIComponent prompt;
        String parameterString;
        boolean javaScriptSupport = ShowDetailRenderer.supportsScripting(arc);
        boolean disclosed = this.getDisclosed(bean);
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("span", component);
        if (!this.isTableAllDisclosure() && !this.isTableDetailDisclosure()) {
            this.renderId(context, component);
        }
        this.renderPromptStart(context, arc, component, bean);
        String sourceValue = this.getClientId(context, component);
        String linkId = this.getLinkId(sourceValue, disclosed);
        if (javaScriptSupport) {
            this._renderScripts(context, arc, component);
            parameterString = this._generateOnClickString(context, arc, component, bean, disclosed);
        } else {
            parameterString = this._encodedParam(context, arc, component, bean, disclosed);
        }
        this._renderLinkStart(context, arc, parameterString);
        if (linkId != null) {
            rw.writeAttribute("id", (Object)linkId, null);
        }
        if (!this.isTableAllDisclosure()) {
            ShowDetailRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])this.getDisclosureIconLinkStyleClasses());
            this.renderDisclosureIcon(context, arc, disclosed);
            this._renderLinkEnd(context, arc);
        }
        if ((prompt = ShowDetailRenderer.getFacet((UIComponent)component, (String)"prompt")) == null && (text = this.getDisclosureText(arc, bean, disclosed)) != null) {
            if (!this.isTableAllDisclosure()) {
                this._renderLinkStart(context, arc, parameterString);
            }
            ShowDetailRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])this.getLinkStyleClasses());
            if (javaScriptSupport) {
                rw.writeText((Object)text, disclosed ? "disclosedText" : "undisclosedText");
            } else {
                rw.writeAttribute("value", (Object)text, disclosed ? "disclosedText" : "undisclosedText");
            }
            this._renderLinkEnd(context, arc);
        }
        if (this.isTableAllDisclosure() && prompt != null) {
            this._renderLinkEnd(context, arc);
        }
        if (prompt != null) {
            this.encodeChild(context, prompt);
        }
        this.renderPromptEnd(context);
        if (disclosed && !this.isTableAllDisclosure() && !this.isTableDetailDisclosure() && !this.renderAsInline()) {
            rw.startElement("div", null);
            this.encodeAllChildren(context, component);
            rw.endElement("div");
        }
        rw.endElement("span");
    }

    protected void renderPromptStart(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (this.renderAsInline()) {
            writer.startElement("span", component);
        } else {
            writer.startElement("div", component);
        }
        this.renderAllAttributes(context, arc, bean);
    }

    protected void renderPromptEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (this.renderAsInline()) {
            writer.endElement("span");
        } else {
            writer.endElement("div");
        }
    }

    public static void renderDisclosureIcon(FacesContext context, RenderingContext arc, boolean disclosed, String disclosedAltTextKey, String undisclosedAltTextKey) throws IOException {
        String key = disclosed ? disclosedAltTextKey : undisclosedAltTextKey;
        String altText = arc.getTranslatedString(key);
        if (!ShowDetailRenderer.supportsScripting(arc)) {
            ResponseWriter rw = context.getResponseWriter();
            String icon = disclosed ? "-" : "+";
            rw.writeAttribute("title", (Object)altText, null);
            rw.writeAttribute("value", (Object)icon, null);
            String linkConverter = "border: none; background: inherit;";
            rw.writeAttribute("style", (Object)linkConverter, null);
        } else {
            Icon icon = ShowDetailRenderer._getDisclosureIcon(arc, disclosed);
            if (icon != null) {
                String align = OutputUtils.getMiddleIconAlignment(arc);
                OutputUtils.renderIcon(context, arc, icon, altText, align);
            }
        }
    }

    protected void renderDisclosureIcon(FacesContext context, RenderingContext arc, boolean disclosed) throws IOException {
        ShowDetailRenderer.renderDisclosureIcon(context, arc, disclosed, _DISCLOSED_TIP_KEY, _UNDISCLOSED_TIP_KEY);
    }

    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    private static Icon _getDisclosureIcon(RenderingContext arc, boolean disclosed) {
        String iconName = disclosed ? "af|showDetail::disclosed-icon" : "af|showDetail::undisclosed-icon";
        return arc.getIcon(iconName);
    }

    protected String getDisclosureText(RenderingContext arc, FacesBean bean, boolean disclosed) {
        String text;
        if (disclosed) {
            text = this.getDisclosedText(bean);
            if (text == null && (text = this.getUndisclosedText(bean)) == null) {
                text = arc.getTranslatedString(_DISCLOSED_KEY);
            }
        } else {
            text = this.getUndisclosedText(bean);
            if (text == null && (text = this.getDisclosedText(bean)) == null) {
                text = arc.getTranslatedString(_UNDISCLOSED_KEY);
            }
        }
        return text;
    }

    private void _renderScripts(FacesContext context, RenderingContext arc, UIComponent component) throws IOException {
        if (!ShowDetailRenderer.supportsNavigation(arc)) {
            return;
        }
        FormData fData = arc.getFormData();
        if (fData == null) {
            _LOG.warning("SHOWDETAIL_NOT_IN_FORM_WILLNOT_FUNCTION_PROPERLY");
            return;
        }
        String valueValue = this.getValueParameter(component);
        ResponseWriter rw = context.getResponseWriter();
        boolean partial = PartialPageUtils.isPPRActive(context);
        if (arc.getProperties().get(_SHOW_DETAIL_SUBMIT_JS_RENDERED) == null) {
            arc.getProperties().put(_SHOW_DETAIL_SUBMIT_JS_RENDERED, Boolean.TRUE);
            String js = partial ? "function _submitHideShow(a,v,b,c,l,d) {var o = {event:b,source:c};if (d!=(void 0)) o.value=d;_setRequestedFocusNode(document,l,false,window);_submitPartialChange(a,v,o);return false;}" : "function _submitHideShow(a,v,b,c,l,d) {var o={event:b,source:c};if (d!=(void 0)) o.value=d;submitForm(a,v,o);return false;}";
            rw.startElement("script", null);
            ShowDetailRenderer.renderScriptDeferAttribute(context, arc);
            ShowDetailRenderer.renderScriptTypeAttribute(context, arc);
            rw.writeText((Object)js, null);
            rw.endElement("script");
            fData.addNeededValue("event");
            fData.addNeededValue("source");
            if (partial) {
                fData.addNeededValue("partial");
            }
        }
        if (valueValue != null) {
            fData.addNeededValue("value");
        }
    }

    private void _renderLinkStart(FacesContext context, RenderingContext arc, String parameterString) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        if (!ShowDetailRenderer.supportsNavigation(arc)) {
            rw.startElement("span", null);
        } else if (ShowDetailRenderer.supportsScripting(arc)) {
            rw.startElement("a", null);
            rw.writeAttribute("onclick", (Object)parameterString, null);
            rw.writeURIAttribute("href", (Object)"#", null);
        } else {
            rw.startElement("input", null);
            rw.writeAttribute("type", (Object)"submit", null);
            rw.writeURIAttribute("name", (Object)parameterString, null);
        }
    }

    private String _generateOnClickString(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, boolean disclosed) {
        FormData fData = arc.getFormData();
        if (fData == null) {
            return null;
        }
        String sourceValue = this.getClientId(context, component);
        String formName = fData.getName();
        String eventValue = disclosed ? "hide" : "show";
        String valueValue = this.getValueParameter(component);
        String linkId = this.getLinkId(sourceValue, disclosed);
        int linkBufferLen = 41 + formName.length() + eventValue.length() + sourceValue.length();
        linkBufferLen = valueValue != null ? (linkBufferLen += valueValue.length()) : (linkBufferLen += 4);
        StringBuffer linkBuffer = new StringBuffer(linkBufferLen);
        linkBuffer.append("return _submitHideShow('");
        linkBuffer.append(formName);
        linkBuffer.append("',");
        linkBuffer.append(this.getImmediate(bean) ? (char)'0' : '1');
        linkBuffer.append(",'");
        linkBuffer.append(eventValue);
        linkBuffer.append("','");
        linkBuffer.append(sourceValue);
        linkBuffer.append("',");
        if (linkId != null) {
            linkBuffer.append("'").append(linkId).append("'");
        } else {
            linkBuffer.append("null");
        }
        if (valueValue != null) {
            linkBuffer.append(",'").append(valueValue).append("'");
        }
        linkBuffer.append(")");
        return linkBuffer.toString();
    }

    private void _renderLinkEnd(FacesContext context, RenderingContext arc) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        if (!ShowDetailRenderer.supportsNavigation(arc)) {
            rw.endElement("span");
        } else if (ShowDetailRenderer.supportsScripting(arc)) {
            rw.endElement("a");
        } else {
            rw.endElement("input");
        }
    }

    private String _encodedParam(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, boolean disclosed) {
        FormData fData = arc.getFormData();
        if (fData == null) {
            return null;
        }
        String sourceValue = this.getClientId(context, component);
        String eventValue = disclosed ? "hide" : "show";
        String valueValue = this.getValueParameter(component);
        String linkId = this.getLinkId(sourceValue, disclosed);
        String nameAttri = XhtmlUtils.getEncodedParameter("source") + XhtmlUtils.getEncodedParameter(sourceValue) + XhtmlUtils.getEncodedParameter("event") + XhtmlUtils.getEncodedParameter(eventValue) + XhtmlUtils.getEncodedParameter("value") + valueValue;
        return nameAttri;
    }

    protected boolean isTableDetailDisclosure() {
        return false;
    }

    protected boolean isTableAllDisclosure() {
        return false;
    }

    protected boolean renderAsInline() {
        return false;
    }

    protected String getValueParameter(UIComponent component) {
        return null;
    }

    protected String[] getLinkStyleClasses() {
        return PROMPT_LINK_STYLE_CLASSES;
    }

    protected String getLinkId(String rootId, boolean disclosed) {
        return XhtmlUtils.getCompositeId(rootId, null);
    }

    protected boolean getImmediate(FacesBean bean) {
        Object o = bean.getProperty(this._immediateKey);
        if (o == null) {
            o = this._immediateKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getDisclosedText(FacesBean bean) {
        if (this._disclosedTextKey == null) {
            return null;
        }
        return ShowDetailRenderer.toString((Object)bean.getProperty(this._disclosedTextKey));
    }

    protected String getUndisclosedText(FacesBean bean) {
        if (this._undisclosedTextKey == null) {
            return null;
        }
        return ShowDetailRenderer.toString((Object)bean.getProperty(this._undisclosedTextKey));
    }

    protected String[] getDisclosureIconLinkStyleClasses() {
        return DISCLOSURE_ICON_LINK_STYLE_CLASSES;
    }

    protected String getPromptStyleClass(boolean disclosed) {
        return disclosed ? "af|showDetail::prompt-disclosed" : "af|showDetail::prompt-undisclosed";
    }

    protected String getDefaultStyleClass(FacesBean bean) {
        return this.getPromptStyleClass(this.getDisclosed(bean));
    }
}

