/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean.util;

import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.component.PartialStateHolder;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.bean.PropertyMap;
import org.apache.myfaces.trinidad.bean.util.PropertyTracker;
import org.apache.myfaces.trinidad.bean.util.StateUtils;
import org.apache.myfaces.trinidad.util.ArrayMap;

public class PropertyArrayMap
extends ArrayMap<PropertyKey, Object>
implements PropertyMap {
    private transient boolean _initialStateMarked;
    private transient PropertyMap _deltas;
    private boolean _useStateHolder;
    private FacesBean.Type _type;
    private PropertyTracker _tracker;
    private transient PropertyTracker _mutableTracker;

    public PropertyArrayMap(int initialCapacity) {
        super(initialCapacity);
    }

    public PropertyArrayMap() {
    }

    public Object get(PropertyKey pKey) {
        if (pKey.getIndex() < 0) {
            return this.get(pKey);
        }
        return this.getByIdentity(pKey);
    }

    @Override
    public Object put(PropertyKey key, Object value) {
        Object retValue = super.put(key, value);
        if (this._createDeltas()) {
            if (key.getMutable().isAtLeastSometimesMutable() || !PropertyArrayMap._equals(value, retValue)) {
                this._deltas.put(key, value);
            }
        } else if (key.getMutable().isAtLeastSometimesMutable() && !(value instanceof ValueExpression)) {
            this._getMutableTracker(true).addProperty(key);
        }
        if (key.isPartialStateHolder()) {
            this._getPartialStateHolderTracker(true).addProperty(key);
        }
        return retValue;
    }

    @Override
    public Object remove(Object key) {
        boolean useDeltas = this._createDeltas();
        if (useDeltas) {
            if (!super.containsKey(key)) {
                return null;
            }
            assert (key instanceof PropertyKey);
            this._deltas.put((PropertyKey)key, null);
        }
        if (key instanceof PropertyKey) {
            PropertyTracker mutableTracker;
            PropertyKey propKey = (PropertyKey)key;
            if (propKey.isPartialStateHolder()) {
                this._getPartialStateHolderTracker(true).removeProperty(propKey);
            }
            if (!useDeltas && propKey.getMutable().isAtLeastSometimesMutable() && (mutableTracker = this._getMutableTracker(false)) != null) {
                mutableTracker.removeProperty(propKey);
            }
        }
        return super.remove(key);
    }

    @Override
    public void putAll(Map<? extends PropertyKey, ? extends Object> t) {
        boolean useDeltas = this._createDeltas();
        if (useDeltas) {
            this._deltas.putAll(t);
        }
        Set<? extends PropertyKey> keys = t.keySet();
        for (PropertyKey propertyKey : keys) {
            Object value;
            if (propertyKey.isPartialStateHolder()) {
                this._getPartialStateHolderTracker(true).addProperty(propertyKey);
            }
            if (useDeltas || !propertyKey.getMutable().isAtLeastSometimesMutable() || (value = t.get(propertyKey)) instanceof ValueExpression) continue;
            this._getMutableTracker(true).addProperty(propertyKey);
        }
        super.putAll(t);
    }

    @Override
    public Object saveState(FacesContext context) {
        if (this._initialStateMarked) {
            if (this._deltas == null) {
                return null;
            }
            return StateUtils.saveState(this._deltas, context, this.getUseStateHolder());
        }
        return StateUtils.saveState(this, context, this.getUseStateHolder());
    }

    @Override
    public void restoreState(FacesContext context, FacesBean.Type type, Object state) {
        StateUtils.restoreState(this, context, type, state, this.getUseStateHolder());
    }

    protected PropertyMap createDeltaPropertyMap() {
        PropertyArrayMap map = new PropertyArrayMap(2);
        map.setUseStateHolder(this.getUseStateHolder());
        map.setType(this._type);
        PropertyTracker tracker = this._getMutableTracker(false);
        if (tracker != null) {
            for (PropertyKey key : tracker) {
                Object val = this.get(key);
                if (val == null) continue;
                map.put(key, val);
            }
            this._mutableTracker = null;
        }
        return map;
    }

    public boolean getUseStateHolder() {
        return this._useStateHolder;
    }

    public void setUseStateHolder(boolean useStateHolder) {
        this._useStateHolder = useStateHolder;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
        PropertyTracker tracker = this._getPartialStateHolderTracker(false);
        if (tracker != null) {
            for (PropertyKey key : tracker) {
                Object val = this.get(key);
                if (val == null) continue;
                ((PartialStateHolder)val).markInitialState();
            }
        }
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
        this._deltas = null;
        PropertyTracker tracker = this._getPartialStateHolderTracker(false);
        if (tracker != null) {
            for (PropertyKey key : tracker) {
                Object val = this.get(key);
                if (val == null) continue;
                ((PartialStateHolder)val).clearInitialState();
            }
        }
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    public void setType(FacesBean.Type type) {
        this._type = type;
    }

    private boolean _createDeltas() {
        if (this._initialStateMarked) {
            if (this._deltas == null) {
                this._deltas = this.createDeltaPropertyMap();
            }
            return true;
        }
        return false;
    }

    private static boolean _equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    private PropertyTracker _getPartialStateHolderTracker(boolean create) {
        if (this._tracker == null && create) {
            if (this._type == null) {
                throw new IllegalStateException("FacesBean.TYPE is required to track properties");
            }
            this._tracker = new PropertyTracker(this._type);
        }
        return this._tracker;
    }

    private PropertyTracker _getMutableTracker(boolean create) {
        if (this._mutableTracker == null && create) {
            if (this._type == null) {
                throw new IllegalStateException("FacesBean.TYPE is required to track properties");
            }
            this._mutableTracker = new PropertyTracker(this._type);
        }
        return this._mutableTracker;
    }
}

