/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent.parse;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.parse.CapabilitiesNode;
import org.apache.myfaces.trinidadinternal.agent.parse.IncludeNode;
import org.apache.myfaces.trinidadinternal.agent.parse.IncludeNodeParser;
import org.apache.myfaces.trinidadinternal.agent.parse.NameVersion;
import org.apache.myfaces.trinidadinternal.agent.parse.XMLConstants;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

class CapabilitiesNodeParser
extends BaseNodeParser
implements XMLConstants {
    private String _id;
    private boolean _isDefault;
    private NameVersion _agent;
    private NameVersion _platform;
    private List<IncludeNode> _includeNodes = new ArrayList<IncludeNode>();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CapabilitiesNodeParser.class);

    CapabilitiesNodeParser() {
    }

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        String platform;
        String agent;
        if (!"http://myfaces.apache.org/trinidad/agent/capabilities".equals(namespaceURI)) {
            throw new SAXParseException(_LOG.getMessage("INVALID_NAMESPACE", (Object)namespaceURI), context.getLocator());
        }
        this._id = attrs.getValue("id");
        String isDefault = attrs.getValue("default");
        if ("true".equals(isDefault)) {
            this._isDefault = true;
        }
        if ((agent = attrs.getValue("agents")) != null) {
            try {
                this._agent = new NameVersion(agent);
            }
            catch (ParseException pe) {
                _LOG.warning("UNABLE_PARSE_AGENT_STRING");
            }
        }
        if ((platform = attrs.getValue("platforms")) != null) {
            try {
                this._platform = new NameVersion(platform);
            }
            catch (ParseException pe) {
                _LOG.warning("UNABLE_PARSE_AGENT_STRING");
            }
        }
        if (this._id == null && this._agent == null) {
            _LOG.warning("ELEMENT_MISSING_ATTRIBUTES", (Object)"capabilities");
        }
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if ("include".equals(localName)) {
            return new IncludeNodeParser();
        }
        return null;
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
        if (child == null) {
            return;
        }
        if ("include".equals(localName)) {
            this._includeNodes.add((IncludeNode)child);
        }
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        if (this._id == null && this._agent == null) {
            return null;
        }
        ArrayList<IncludeNode> nodesWithRefList = new ArrayList<IncludeNode>(this._includeNodes.size());
        ArrayList<IncludeNode> nodesWithSrcList = new ArrayList<IncludeNode>(this._includeNodes.size());
        for (int i = 0; i < this._includeNodes.size(); ++i) {
            IncludeNode node = this._includeNodes.get(i);
            if (node.__getRefId() != null) {
                nodesWithRefList.add(node);
                continue;
            }
            nodesWithSrcList.add(node);
        }
        IncludeNode[] nodesWithRef = nodesWithRefList.toArray(new IncludeNode[nodesWithRefList.size()]);
        IncludeNode[] nodesWithSrc = nodesWithSrcList.toArray(new IncludeNode[nodesWithSrcList.size()]);
        return new CapabilitiesNode(this._id, this._isDefault, this._agent, this._platform, nodesWithRef, nodesWithSrc);
    }
}

