/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtil {
    private static final int BUFFER_SIZE = 1024;

    public static InputStream createInputStream(Object source) throws IOException {
        InputStream is;
        if (source instanceof String) {
            byte[] content = ((String)source).getBytes("utf-8");
            is = new ByteArrayInputStream(content);
        } else if (source instanceof File) {
            is = new FileInputStream((File)source);
        } else if (source instanceof byte[]) {
            is = new ByteArrayInputStream((byte[])source);
        } else if (source instanceof char[]) {
            byte[] content = new String((char[])source).getBytes("utf-8");
            is = new ByteArrayInputStream(content);
        } else if (source instanceof ByteArrayOutputStream) {
            byte[] content = ((ByteArrayOutputStream)source).toByteArray();
            is = new ByteArrayInputStream(content);
        } else if (source instanceof InputStream) {
            is = (InputStream)source;
        } else {
            throw new IllegalArgumentException("Don't know hot to handle " + source.getClass().getName());
        }
        return is;
    }

    public static OutputStream createOutputStream(Object target) throws IOException {
        OutputStream os;
        if (target instanceof File) {
            File currFile = (File)target;
            StreamUtil.createParentFile(currFile);
            os = new FileOutputStream(currFile);
        } else if (target instanceof String) {
            File currFile = new File((String)target);
            StreamUtil.createParentFile(currFile);
            os = new FileOutputStream(currFile);
        } else if (target instanceof OutputStream) {
            os = (OutputStream)target;
        } else {
            throw new IllegalArgumentException("Don't know hot to handle " + target.getClass().getName());
        }
        return os;
    }

    public static long copy(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int n = 0;
        long total = 0L;
        while ((n = is.read(buf)) > 0) {
            os.write(buf, 0, n);
            total += (long)n;
        }
        is.close();
        os.flush();
        os.close();
        return total;
    }

    private static void createParentFile(File currFile) {
        boolean success;
        File parentFile = currFile.getParentFile();
        if (parentFile != null && !parentFile.exists() && !(success = parentFile.mkdirs())) {
            System.err.println("Error, could not create directory to write parent file");
        }
    }
}

