/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messenger.SessionFactory;

public class JNDISessionFactory
extends SessionFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messenger$JNDISessionFactory == null ? (class$org$apache$commons$messenger$JNDISessionFactory = JNDISessionFactory.class$("org.apache.commons.messenger.JNDISessionFactory")) : class$org$apache$commons$messenger$JNDISessionFactory));
    public Context context;
    private String lookupName = "TopicConnectionFactory";
    static /* synthetic */ Class class$org$apache$commons$messenger$JNDISessionFactory;

    public String getLookupName() {
        return this.lookupName;
    }

    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    public Context getContext() throws NamingException {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    protected ConnectionFactory createConnectionFactory() throws JMSException {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Looking up: " + this.getLookupName() + " in JNDI"));
            }
            return (ConnectionFactory)this.getContext().lookup(this.getLookupName());
        }
        catch (NamingException e) {
            JMSException jmsException = new JMSException("Failed to lookup: " + this.getLookupName() + " using JNDI. " + e);
            jmsException.setLinkedException((Exception)e);
            throw jmsException;
        }
    }

    public Connection createConnection() throws JMSException {
        ConnectionFactory factory = this.getConnectionFactory();
        if (factory == null) {
            throw new JMSException("No ConnectionFactory configured. Cannot create a JMS Session");
        }
        if (this.isTopic()) {
            return this.createTopicConnection((TopicConnectionFactory)factory);
        }
        return this.createQueueConnection((QueueConnectionFactory)factory);
    }

    public Session createSession(Connection connection) throws JMSException {
        if (this.isTopic()) {
            TopicConnection topicConnection = (TopicConnection)connection;
            return topicConnection.createTopicSession(this.isTransacted(), this.getAcknowledgeMode());
        }
        QueueConnection queueConnection = (QueueConnection)connection;
        return queueConnection.createQueueSession(this.isTransacted(), this.getAcknowledgeMode());
    }

    protected Context createContext() throws NamingException {
        if (this.properties != null) {
            return new InitialContext(this.properties);
        }
        return new InitialContext();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

