/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueRequestor;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicRequestor;
import javax.jms.TopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messenger.MessengerSupport;
import org.apache.commons.messenger.SessionFactory;

public class MessengerSession {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messenger$MessengerSupport == null ? (class$org$apache$commons$messenger$MessengerSupport = MessengerSession.class$("org.apache.commons.messenger.MessengerSupport")) : class$org$apache$commons$messenger$MessengerSupport));
    private Session session;
    private Session listenerSession;
    private MessageConsumer replyToConsumer;
    private SessionFactory sessionFactory;
    private Map requestorsMap;
    private Destination replyToDestination;
    private MessengerSupport messenger;
    private MessageProducer producer;
    static /* synthetic */ Class class$org$apache$commons$messenger$MessengerSupport;

    public MessengerSession(MessengerSupport messenger, SessionFactory sessionFactory) {
        this.messenger = messenger;
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void close() throws JMSException {
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.listenerSession != null) {
            this.listenerSession.close();
            this.listenerSession = null;
        }
    }

    public Session getSession() throws JMSException {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public Session getListenerSession() throws JMSException {
        if (this.listenerSession == null) {
            this.listenerSession = this.createSession();
        }
        return this.listenerSession;
    }

    public MessageConsumer getReplyToConsumer() throws JMSException {
        return this.replyToConsumer;
    }

    public void setReplyToConsumer(MessageConsumer replyToConsumer) {
        this.replyToConsumer = replyToConsumer;
    }

    public MessageProducer getMessageProducer(Destination destination) throws JMSException {
        if (this.producer == null) {
            this.producer = this.messenger.createMessageProducer(this, null);
        }
        return this.producer;
    }

    protected Destination getReplyToDestination() throws JMSException {
        if (this.replyToDestination == null) {
            this.replyToDestination = this.createTemporaryDestination();
        }
        return this.replyToDestination;
    }

    protected void setReplyToDestination(Destination replyToDestination) throws JMSException {
        this.replyToDestination = replyToDestination;
    }

    public TopicRequestor getTopicRequestor(TopicSession session, Topic destination) throws JMSException {
        if (this.messenger.isCacheRequestors()) {
            TopicRequestor requestor = (TopicRequestor)this.getRequestorsMap().get(destination);
            if (requestor == null) {
                requestor = new TopicRequestor(session, destination);
                this.getRequestorsMap().put(destination, requestor);
            }
            return requestor;
        }
        return new TopicRequestor(session, destination);
    }

    public QueueRequestor getQueueRequestor(QueueSession session, Queue destination) throws JMSException {
        if (this.messenger.isCacheRequestors()) {
            QueueRequestor requestor = (QueueRequestor)this.getRequestorsMap().get(destination);
            if (requestor == null) {
                requestor = new QueueRequestor(session, destination);
                this.getRequestorsMap().put(destination, requestor);
            }
            return requestor;
        }
        return new QueueRequestor(session, destination);
    }

    public boolean isTopic() throws JMSException {
        return this.getSessionFactory().isTopic();
    }

    protected Session createSession() throws JMSException {
        Session answer = this.getSessionFactory().createSession(this.messenger.getConnection());
        log.info((Object)("Created JMS session: " + answer));
        return answer;
    }

    protected Destination createTemporaryDestination() throws JMSException {
        if (this.isTopic()) {
            TopicSession topicSession = (TopicSession)this.session;
            return topicSession.createTemporaryTopic();
        }
        QueueSession queueSession = (QueueSession)this.session;
        return queueSession.createTemporaryQueue();
    }

    protected Map getRequestorsMap() {
        if (this.requestorsMap == null) {
            this.requestorsMap = new HashMap();
        }
        return this.requestorsMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

