/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.FileConfiguration;

public abstract class AbstractFileConfiguration
extends BaseConfiguration
implements FileConfiguration {
    protected String fileName;
    protected String basePath;
    protected URL url;

    public void load() throws ConfigurationException {
        if (this.url == null) {
            this.load(this.fileName);
        } else {
            this.load(this.url);
        }
    }

    public void load(String fileName) throws ConfigurationException {
        try {
            URL url = ConfigurationUtils.locate(this.basePath, fileName);
            this.load(url);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public void load(File file) throws ConfigurationException {
        try {
            this.load(file.toURL());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     */
    public void load(URL url) throws ConfigurationException {
        block9: {
            InputStream in = null;
            in = url.openStream();
            this.load(in);
            Object var5_3 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block9;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block9;
            {
                catch (Exception e) {
                    throw new ConfigurationException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void load(InputStream in) throws ConfigurationException {
        this.load(in, null);
    }

    public void load(InputStream in, String encoding) throws ConfigurationException {
        InputStreamReader reader = null;
        if (encoding != null) {
            try {
                reader = new InputStreamReader(in, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException("The requested encoding is not supported, try the default encoding.", e);
            }
        }
        if (reader == null) {
            reader = new InputStreamReader(in);
        }
        this.load(reader);
    }

    public void save() throws ConfigurationException {
        this.save(this.fileName);
    }

    public void save(String fileName) throws ConfigurationException {
        try {
            this.save(ConfigurationUtils.constructFile(this.basePath, fileName));
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public void save(URL url) throws ConfigurationException {
        if ("file".equals(url.getProtocol())) {
            this.save(new File(url.getFile()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save(File file) throws ConfigurationException {
        block11: {
            FileOutputStream out = null;
            out = new FileOutputStream(file);
            this.save(out);
            Object var5_3 = null;
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                break block11;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            break block11;
            {
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    Object var5_4 = null;
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                        break block11;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void save(OutputStream out) throws ConfigurationException {
        this.save(out, null);
    }

    public void save(OutputStream out, String encoding) throws ConfigurationException {
        OutputStreamWriter writer = null;
        if (encoding != null) {
            try {
                writer = new OutputStreamWriter(out, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException("The requested encoding is not supported, try the default encoding.", e);
            }
        }
        if (writer == null) {
            writer = new OutputStreamWriter(out);
        }
        this.save(writer);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.url = ConfigurationUtils.locate(this.basePath, fileName);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public File getFile() {
        if (this.url != null && "file".equals(this.url.getProtocol())) {
            return new File(this.url.getFile());
        }
        return ConfigurationUtils.constructFile(this.getBasePath(), this.getFileName());
    }

    public void setFile(File file) {
        if (file != null) {
            try {
                this.setURL(file.toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            this.url = null;
        }
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
        this.basePath = ConfigurationUtils.getBasePath(url);
        if (this.basePath != null && this.basePath.startsWith("file:")) {
            this.basePath = this.basePath.substring(5);
        }
        this.fileName = ConfigurationUtils.getFileName(url);
    }

    public abstract /* synthetic */ void save(Writer var1) throws ConfigurationException;

    public abstract /* synthetic */ void load(Reader var1) throws ConfigurationException;
}

