/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.list;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class UntypedListExpression
extends ListExpression<Object> {
    private List<IRutaExpression> list;

    public UntypedListExpression(List<IRutaExpression> list) {
        this.list = list;
    }

    @Override
    public List<Object> getList(MatchContext context, RutaStream stream) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (IRutaExpression each : this.list) {
            if (each instanceof IBooleanExpression) {
                result.add(((IBooleanExpression)each).getBooleanValue(context, stream));
                continue;
            }
            if (each instanceof INumberExpression) {
                result.add(((INumberExpression)each).getDoubleValue(context, stream));
                continue;
            }
            if (each instanceof ITypeExpression) {
                result.add(((ITypeExpression)each).getType(context, stream));
                continue;
            }
            if (each instanceof IAnnotationExpression) {
                result.add(((IAnnotationExpression)each).getAnnotation(context, stream));
                continue;
            }
            if (each instanceof ListExpression) {
                result.add(((ListExpression)each).getList(context, stream));
                continue;
            }
            if (!(each instanceof IStringExpression)) continue;
            result.add(((IStringExpression)each).getStringValue(context, stream));
        }
        return result;
    }

    public List<IRutaExpression> getList() {
        return this.list;
    }
}

