/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;
import org.apache.uima.util.CasCopier;

public class SplitAction
extends AbstractRutaAction {
    private final ITypeExpression splitOnType;
    private final IBooleanExpression complete;
    private final IBooleanExpression appendToBegin;
    private final IBooleanExpression appendToEnd;

    public SplitAction(ITypeExpression splitOnType, IBooleanExpression complete, IBooleanExpression appendToBegin, IBooleanExpression appendToEnd) {
        this.splitOnType = splitOnType;
        this.complete = complete == null ? new SimpleBooleanExpression(true) : complete;
        this.appendToBegin = appendToBegin == null ? new SimpleBooleanExpression(false) : appendToBegin;
        this.appendToEnd = appendToEnd == null ? new SimpleBooleanExpression(false) : appendToEnd;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        List<AnnotationFS> matchedAnnotationsOf = match.getMatchedAnnotationsOfElement(element);
        element.getParent();
        Type typeToSplit = this.splitOnType.getType(context, stream);
        if (typeToSplit == null) {
            return;
        }
        boolean splitOnCompleteAnnotation = this.complete.getBooleanValue(context, stream);
        boolean addToBegin = this.appendToBegin.getBooleanValue(context, stream);
        boolean addToEnd = this.appendToEnd.getBooleanValue(context, stream);
        for (AnnotationFS annotation : matchedAnnotationsOf) {
            this.splitAnnotation(annotation, typeToSplit, splitOnCompleteAnnotation, addToBegin, addToEnd, match, stream);
        }
    }

    private void splitAnnotation(AnnotationFS annotation, Type typeToSplit, boolean splitOnCompleteAnnotation, boolean addToBegin, boolean addToEnd, RuleMatch match, RutaStream stream) {
        if (annotation instanceof Annotation) {
            if (splitOnCompleteAnnotation) {
                this.splitAnnotationOnComplete((Annotation)annotation, typeToSplit, addToBegin, addToEnd, match, stream);
            } else {
                this.splitAnnotationOnBoundary((Annotation)annotation, typeToSplit, addToBegin, addToEnd, match, stream);
            }
        }
    }

    private void splitAnnotationOnComplete(Annotation annotation, Type typeToSplit, boolean addToBegin, boolean addToEnd, RuleMatch match, RutaStream stream) {
        List<AnnotationFS> annotationsInWindow = stream.getAnnotationsInWindow((AnnotationFS)annotation, typeToSplit);
        if (annotationsInWindow == null || annotationsInWindow.isEmpty()) {
            return;
        }
        CAS cas = annotation.getCAS();
        CasCopier cc = new CasCopier(cas, cas);
        cas.removeFsFromIndexes((FeatureStructure)annotation);
        int overallEnd = annotation.getEnd();
        Annotation current = annotation;
        for (AnnotationFS each : annotationsInWindow) {
            int currentEnd = addToEnd ? each.getEnd() : each.getBegin();
            current.setEnd(currentEnd);
            boolean valid = this.trimInvisible(current, stream);
            if (valid) {
                stream.addAnnotation((AnnotationFS)current, true, true, match);
            }
            Annotation next = (Annotation)cc.copyFs((FeatureStructure)current);
            int nextBegin = addToBegin ? each.getBegin() : each.getEnd();
            next.setBegin(nextBegin);
            next.setEnd(overallEnd);
            current = next;
        }
        if (this.trimInvisible(current, stream)) {
            stream.addAnnotation((AnnotationFS)current, true, true, match);
        }
    }

    private void splitAnnotationOnBoundary(Annotation annotation, Type typeToSplit, boolean addToBegin, boolean addToEnd, RuleMatch match, RutaStream stream) {
        Collection<RutaBasic> basics = stream.getAllBasicsInWindow((AnnotationFS)annotation);
        CAS cas = annotation.getCAS();
        CasCopier cc = new CasCopier(cas, cas);
        cas.removeFsFromIndexes((FeatureStructure)annotation);
        int overallEnd = annotation.getEnd();
        Annotation first = annotation;
        for (RutaBasic eachBasic : basics) {
            if (!stream.isVisible((AnnotationFS)eachBasic)) continue;
            boolean beginsWith = eachBasic.beginsWith(typeToSplit);
            boolean endsWith = eachBasic.endsWith(typeToSplit);
            if (!beginsWith && !endsWith) continue;
            int firstEnd = beginsWith ? eachBasic.getBegin() : eachBasic.getEnd();
            first.setEnd(firstEnd);
            boolean valid = this.trimInvisible(first, stream);
            if (valid) {
                stream.addAnnotation((AnnotationFS)first, true, true, match);
            }
            Annotation second = (Annotation)cc.copyFs((FeatureStructure)first);
            int secondBegin = endsWith ? eachBasic.getEnd() : eachBasic.getBegin();
            second.setBegin(secondBegin);
            second.setEnd(overallEnd);
            valid = this.trimInvisible(second, stream);
            if (valid) {
                stream.addAnnotation((AnnotationFS)second, true, true, match);
            }
            first = second;
        }
    }

    private boolean trimInvisible(Annotation annotation, RutaStream stream) {
        int max;
        int min = annotation.getEnd();
        if (min <= (max = annotation.getBegin())) {
            return false;
        }
        ArrayList<RutaBasic> basics = new ArrayList<RutaBasic>(stream.getAllBasicsInWindow((AnnotationFS)annotation));
        for (RutaBasic each : basics) {
            if (!stream.isVisible((AnnotationFS)each)) continue;
            min = Math.min(min, each.getBegin());
            break;
        }
        Collections.reverse(basics);
        for (RutaBasic each : basics) {
            if (!stream.isVisible((AnnotationFS)each)) continue;
            max = Math.max(max, each.getEnd());
            break;
        }
        if (min < max) {
            annotation.setBegin(min);
            annotation.setEnd(max);
            return true;
        }
        return false;
    }

    public ITypeExpression getSplitOnType() {
        return this.splitOnType;
    }

    public IBooleanExpression getComplete() {
        return this.complete;
    }

    public IBooleanExpression getAppendToBegin() {
        return this.appendToBegin;
    }

    public IBooleanExpression getAppendToEnd() {
        return this.appendToEnd;
    }
}

