/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.Test;
import org.apache.batik.test.TestReport;

public class TestErrorConditionException
extends Exception {
    protected String errorCode;

    protected TestErrorConditionException() {
    }

    public TestErrorConditionException(String errorCode) {
        this.errorCode = errorCode;
    }

    public TestReport getTestReport(Test test) {
        DefaultTestReport report = new DefaultTestReport(test);
        if (this.errorCode != null) {
            report.setErrorCode(this.errorCode);
        } else {
            report.setErrorCode("TestReport.error.test.failed");
        }
        report.setPassed(false);
        this.addStackTraceDescription(report);
        return report;
    }

    public void addStackTraceDescription(TestReport report) {
        StringWriter trace = new StringWriter();
        this.printStackTrace(new PrintWriter(trace));
        report.addDescriptionEntry("TestReport.entry.key.error.condition.stack.trace", trace.toString());
    }
}

