# Garmin Aera660 Simulation by D-ECHO based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)
#######################################

var aera660_mainmenu = nil;
var aera660_map = nil;
var aera660_start = nil;
var aera660_display = nil;


var groupMain = nil;

var base = "/instrumentation/aera660/";


var page = "main_menu";

var qnh_hpa = "instrumentation/altimeter/setting-hpa";


var start_prop = base~"start";
var volt_prop = "/systems/electrical/outputs/eis";
var brightness_prop = base~"brightness";




#roundToNearest function used for alt tape, thanks @Soitanen (737-800)!
var roundToNearest = func(n, m) {
	var x = int(n/m)*m;
	if((math.mod(n,m)) > (m/2) and n > 0)
			x = x + m;
	if((m - (math.mod(n,m))) > (m/2) and n < 0)
			x = x - m;
	return x;
}


var canvas_aera660_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}
		
		if(me["horizon"]!=nil) {
			me.h_trans = me["horizon"].createTransform();
			me.h_rot = me["horizon"].createTransform();
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volts = getprop(volt_prop) or 0;
		var start = getprop(start_prop) or 0;
		if ( volts > 10 and start == 1) {
			aera660_start.page.hide();
			if(page=="main_menu"){
				aera660_mainmenu.page.show();
				aera660_map.page.hide();
			}else if(page=="map"){
				aera660_map.page.show();
				aera660_mainmenu.page.hide();
			}else{
				aera660_mainmenu.page.hide();
				aera660_map.page.hide();
			}
		} else if ( volts > 10 and start != 0 and start != 1 ){
			aera660_mainmenu.page.hide();
			aera660_map.page.hide();
			aera660_start.page.show();
		} else {
			aera660_mainmenu.page.hide();
			aera660_map.page.hide();
			aera660_start.page.hide();
		}
		
		settimer(func me.update(), 0.02);
	},
};
	
	
var canvas_aera660_mainmenu = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_aera660_mainmenu , canvas_aera660_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		
		settimer(func me.update(), 0.02);
	}
	
};
	
var canvas_aera660_map = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_aera660_map , canvas_aera660_base] };
		m.init(canvas_group, file);

		
		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		
		settimer(func me.update(), 0.02);
	}
	
};



var canvas_aera660_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_aera660_start , canvas_aera660_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};



setlistener("sim/signals/fdm-initialized", func {
	aera660_display = canvas.new({
		"name": "Aera660",
		"size": [800, 480],
		"view": [800, 480],
		"mipmapping": 1
	});
	aera660_display.addPlacement({"node": "aera660.screen"});
	var groupMainMenu = aera660_display.createGroup();
	var groupMap = aera660_display.createGroup();
	var groupStart = aera660_display.createGroup();


	aera660_mainmenu = canvas_aera660_mainmenu.new(groupMainMenu, "Aircraft/AlphaElectro/Models/Instruments/Aera660/aera660.main_menu.svg");
	aera660_map = canvas_aera660_map.new(groupMap, "Aircraft/AlphaElectro/Models/Instruments/Aera660/aera660.map.svg");
	aera660_start = canvas_aera660_start.new(groupStart, "Aircraft/AlphaElectro/Models/Instruments/Aera660/aera660.start.svg");
	aera660_mainmenu.update();
	aera660_map.update();
	canvas_aera660_base.update();
});


var showAera660 = func {
	var dlg = canvas.Window.new([320, 243], "dialog").set("resize", 1);
	dlg.setCanvas(aera660_display);
}

#Touchscreen

var click1 = func () {
	if(page=="main_menu"){
		page="map";
	}
}

#End Touchscreen
	

var not_yet_started=1;

var power_btn = func (){
	page="main_menu";
	if(not_yet_started==1 and getprop(volt_prop)>10){
		not_yet_started=0;
		interpolate(start_prop, 1, 3);
	}else if(getprop(volt_prop)<10){
		not_yet_started=1;
		setprop(start_prop, 0);
	}
}

setlistener(volt_prop, func(i){
	if(i.getValue() < 10){
		#reset
		not_yet_started=1;
		setprop(start_prop, 0);
	}
});
