
var index = 0;

var lx8080_controller = {
	parents: [canvas.Map.Controller],

	new: func(map) {
		var m = { parents: [lx8080_controller],
			map: map,
			};
		m.index = index;

		return m;
	}
};

var canvas_nd = {
	new: func(canvasGroup, page)
	{
		var m = { parents: [canvas_nd] };
		m.group = canvasGroup;
		m.map = canvasGroup.createChild('map');
		m.index = index;
		m.Tmp = 0;
		m.oldHeading = 0;
		m.range = 25;
		m.pg = page;

		var font_mapper = func(family, weight) {
			if ( weight == "bold" ) {
				return "LiberationFonts/LiberationSans-Bold.ttf";
			} else {
				return "LiberationFonts/LiberationSans-Regular.ttf";
			}
		};
		
		if( m.pg == 1 ){
			canvas.parsesvg(canvasGroup, instrument_path~"LX8080_nav_1.svg", {'font-mapper': font_mapper});
		} elsif( m.pg == 2 ){
			canvas.parsesvg(canvasGroup, instrument_path~"LX8080_nav_2.svg", {'font-mapper': font_mapper});
		} else {
			die( "LX8080: Canvas ND: Invalid Page Number!");
		}

		var svg_keys = ["time.text","ac.symbol","wind.needle","wind.text","thermal.ms","alt.m","zoom.text"];
		
		# Additionally on nav page 2:
		if( m.pg == 2 ){
			append( svg_keys, "netto.ms" );
			append( svg_keys, "trk.deg" );
			append( svg_keys, "gs.kmh" );
			append( svg_keys, "agl.m" );
		}
		
		foreach(var key; svg_keys) {
			m[key] = canvasGroup.getElementById(key);
		}

		### NavDisplay ###
		m.map.setRange(m.range);
		m.map.setTranslation(160,120);
		m.map.setPos(lat.getValue(),lon.getValue(), 0.0);
		m.map.addLayer( factory: canvas.OverlayLayer, type_arg: 'STAMEN', visible: 1, priority: 1 );
		m.map.addLayer( factory: canvas.SymbolLayer, type_arg: 'APT', visible: 1, priority: 0 );
		m.map.setController(lx8080_controller);
		index+=1;

		m.timer = maketimer(0.2, m, m.update);
		return m;
	},
	update: func()
	{
		me["time.text"].setText(sprintf("%02d", time_hr.getValue()) ~ ":" ~ sprintf("%02d", time_min.getValue()));
		
		# Map part
		var nose_heading = hdg_true.getValue();
		me["ac.symbol"].setRotation(nose_heading*D2R);
		var wind_hdg = wind_deg.getValue();
		me["wind.needle"].setRotation(-(nose_heading-wind_hdg)*D2R);
		me["wind.text"].setText(sprintf("%3d", math.round(wind_hdg)) ~ "/" ~ sprintf("%2d", math.round(wind_kt.getValue())));
		
		# Text Infos
		me["thermal.ms"].setText(sprintf("%2.1f", vario_av.getValue()));
		
		me["alt.m"].setText(sprintf("%4d", math.round(alt_gps.getValue()*FT2M)));
		
		# Additionally on nav page 2:
		if( me.pg == 2 ){
			me["netto.ms"].setText(sprintf("%2.1f", vario_te.getDoubleValue()-0.5));	#TODO calculate netto vario value correct
			me["trk.deg"].setText(sprintf("%3d", math.round(hdg_trk.getValue())));
			me["gs.kmh"].setText(sprintf("%3d", math.round(gs_kt.getValue() * KT2MPS * 3.6 )));
			me["agl.m"].setText(sprintf("%4d", math.round(alt_agl.getValue()*FT2M)));
		}
		
		me.map.setPos(lat.getValue(), lon.getValue(), 0.0);
		me.map.update();
	},
	show: func()
	{
		me.update();
		me.timer.start();
		me.group.show();
	},
	hide: func()
	{
		me.timer.stop();
		me.group.hide();
	}
};
