/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ColorPatternPanel
extends JPanel {
    private JPanel patternView;
    private JPanel patternIcon;
    private Info currentLI;
    private boolean dataChanging = false;
    private boolean showPrinter;
    private static final int[] preDefinedPatterns = new int[]{34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 52428, 52428, 13107, 13107, 52428, 52428, 13107, 13107, 52428, 52428, 13107, 13107, 52428, 52428, 13107, 13107, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 24672, 37008, 37008, 24672, 1542, 2313, 2313, 1542, 24672, 37008, 37008, 24672, 1542, 2313, 2313, 1542, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 17476, 4369, 17476, 4369, 17476, 4369, 17476, 4369, 17476, 4369, 17476, 4369, 17476, 4369, 17476, 4369, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 2056, 1028, 514, 257, 32896, 16448, 8224, 4112, 2056, 1028, 514, 257, 32896, 16448, 8224, 4112, 16448, 32896, 257, 514, 257, 32896, 16448, 8224, 16448, 32896, 257, 514, 257, 32896, 16448, 8224, 8224, 0, 32896, 0, 514, 0, 2056, 0, 8224, 0, 32896, 0, 514, 0, 2056, 0, 2056, 0, 514, 0, 32896, 0, 8224, 0, 2056, 0, 514, 0, 32896, 0, 8224, 0, 0, 771, 18504, 771, 0, 12336, 33924, 12336, 0, 771, 18504, 771, 0, 12336, 33924, 12336, 7196, 15934, 13878, 15934, 7196, 0, 0, 0, 7196, 15934, 13878, 15934, 7196, 0, 0, 0, 0, 52428, 0, 52428, 0, 0, 0, 0, 0, 52428, 0, 52428, 0, 0, 0, 0, 0, 0, 8738, 34952, 0, 0, 8738, 34952, 0, 0, 8738, 34952, 0, 0, 8738, 34952, 0, 0, 4369, 0, 0, 0, 4369, 0, 0, 0, 4369, 0, 0, 0, 4369, 0, 0, 8738, 17476, 34952, 0, 8738, 17476, 34952, 0, 8738, 17476, 34952, 0, 8738, 17476, 34952, 0, 8738, 21845, 8738, 0, 8738, 21845, 8738, 0, 8738, 21845, 8738, 0, 8738, 21845, 8738, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535};
    private JPanel appearance;
    private JPanel forDisplay;
    private JPanel forPrinter;
    private JLabel jLabel40;
    private JLabel jLabel50;
    private JTextField layerBlue;
    private JLabel layerBlueLabel;
    private JTextField layerGreen;
    private JLabel layerGreenLabel;
    private JTextField layerRed;
    private JLabel layerRedLabel;
    private JTextField opacity;
    private JLabel opacityExplanation;
    private JLabel opacityLabel;
    private JButton pick;
    private JComboBox transparentLayer;
    private JCheckBox useOutlinePatternDisplay;
    private JCheckBox useOutlinePatternPrinter;
    private JCheckBox useStipplePatternDisplay;
    private JCheckBox useStipplePatternPrinter;

    public ColorPatternPanel(boolean showPrinter) {
        this.initComponents();
        this.showPrinter = showPrinter;
        int[] colors = EGraphics.getTransparentColorIndices();
        this.transparentLayer.addItem("Not Transparent");
        for (int i = 0; i < colors.length; ++i) {
            this.transparentLayer.addItem(EGraphics.getColorIndexName(colors[i]));
        }
        this.useStipplePatternDisplay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPatternPanel.this.layerInfoChanged();
            }
        });
        this.useOutlinePatternDisplay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPatternPanel.this.layerInfoChanged();
            }
        });
        this.transparentLayer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPatternPanel.this.layerInfoChanged();
            }
        });
        this.pick.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPatternPanel.this.colorPick();
            }
        });
        this.layerRed.getDocument().addDocumentListener(new LayerColorDocumentListener());
        this.layerGreen.getDocument().addDocumentListener(new LayerColorDocumentListener());
        this.layerBlue.getDocument().addDocumentListener(new LayerColorDocumentListener());
        this.patternView = new PatternView();
        this.patternView.setMaximumSize(new Dimension(257, 257));
        this.patternView.setMinimumSize(new Dimension(257, 257));
        this.patternView.setPreferredSize(new Dimension(257, 257));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 8;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 4, 4, 4);
        this.appearance.add((Component)this.patternView, gbc);
        this.patternIcon = new PatternChoices();
        this.patternIcon.setMaximumSize(new Dimension(352, 16));
        this.patternIcon.setMinimumSize(new Dimension(352, 16));
        this.patternIcon.setPreferredSize(new Dimension(352, 16));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 8;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 4, 2, 4);
        this.appearance.add((Component)this.patternIcon, gbc);
        if (showPrinter) {
            this.useOutlinePatternPrinter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ColorPatternPanel.this.layerInfoChanged();
                }
            });
            this.useStipplePatternPrinter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ColorPatternPanel.this.layerInfoChanged();
                }
            });
            this.opacity.getDocument().addDocumentListener(new LayerColorDocumentListener());
        } else {
            this.remove(this.forPrinter);
        }
    }

    public void setColorPattern(Info li) {
        this.currentLI = li;
        this.dataChanging = true;
        this.useStipplePatternDisplay.setSelected(li.useStippleDisplay);
        this.useOutlinePatternDisplay.setSelected(li.outlinePatternDisplay);
        if (this.showPrinter) {
            this.useStipplePatternPrinter.setSelected(li.useStipplePrinter);
            this.useOutlinePatternPrinter.setSelected(li.outlinePatternPrinter);
            this.opacity.setText(TextUtils.formatDouble(li.opacity));
        }
        this.transparentLayer.setSelectedIndex(li.transparentLayer);
        this.layerRed.setText(Integer.toString(li.red));
        this.layerGreen.setText(Integer.toString(li.green));
        this.layerBlue.setText(Integer.toString(li.blue));
        if (li.transparentLayer == 0) {
            this.pick.setEnabled(true);
            this.layerRedLabel.setEnabled(true);
            this.layerRed.setEnabled(true);
            this.layerGreenLabel.setEnabled(true);
            this.layerGreen.setEnabled(true);
            this.layerBlueLabel.setEnabled(true);
            this.layerBlue.setEnabled(true);
        } else {
            this.layerRedLabel.setEnabled(false);
            this.layerRed.setEnabled(false);
            this.layerGreenLabel.setEnabled(false);
            this.layerGreen.setEnabled(false);
            this.layerBlueLabel.setEnabled(false);
            this.layerBlue.setEnabled(false);
            this.pick.setEnabled(false);
        }
        this.patternView.repaint();
        this.dataChanging = false;
    }

    private void colorPick() {
        Color newColor = JColorChooser.showDialog(this, "Pick color", new Color(this.currentLI.red, this.currentLI.green, this.currentLI.blue));
        if (newColor == null) {
            return;
        }
        this.currentLI.red = newColor.getRed();
        this.currentLI.green = newColor.getGreen();
        this.currentLI.blue = newColor.getBlue();
        this.setColorPattern(this.currentLI);
    }

    private void layerInfoChanged() {
        if (this.dataChanging) {
            return;
        }
        if (this.currentLI == null) {
            return;
        }
        this.currentLI.useStippleDisplay = this.useStipplePatternDisplay.isSelected();
        this.currentLI.outlinePatternDisplay = this.useOutlinePatternDisplay.isSelected();
        if (this.showPrinter) {
            this.currentLI.useStipplePrinter = this.useStipplePatternPrinter.isSelected();
            this.currentLI.outlinePatternPrinter = this.useOutlinePatternPrinter.isSelected();
        }
        this.currentLI.transparentLayer = this.transparentLayer.getSelectedIndex();
        boolean colorsEnabled = this.currentLI.transparentLayer == 0;
        this.pick.setEnabled(colorsEnabled);
        this.layerRedLabel.setEnabled(colorsEnabled);
        this.layerRed.setEnabled(colorsEnabled);
        this.layerGreenLabel.setEnabled(colorsEnabled);
        this.layerGreen.setEnabled(colorsEnabled);
        this.layerBlueLabel.setEnabled(colorsEnabled);
        this.layerBlue.setEnabled(colorsEnabled);
        this.currentLI.red = TextUtils.atoi(this.layerRed.getText());
        this.currentLI.green = TextUtils.atoi(this.layerGreen.getText());
        this.currentLI.blue = TextUtils.atoi(this.layerBlue.getText());
        this.currentLI.opacity = TextUtils.atof(this.opacity.getText());
    }

    private void initComponents() {
        this.forDisplay = new JPanel();
        this.jLabel40 = new JLabel();
        this.transparentLayer = new JComboBox();
        this.useStipplePatternDisplay = new JCheckBox();
        this.useOutlinePatternDisplay = new JCheckBox();
        this.forPrinter = new JPanel();
        this.useStipplePatternPrinter = new JCheckBox();
        this.useOutlinePatternPrinter = new JCheckBox();
        this.opacityLabel = new JLabel();
        this.opacity = new JTextField();
        this.opacityExplanation = new JLabel();
        this.appearance = new JPanel();
        this.layerGreenLabel = new JLabel();
        this.layerBlueLabel = new JLabel();
        this.layerGreen = new JTextField();
        this.layerRed = new JTextField();
        this.layerRedLabel = new JLabel();
        this.layerBlue = new JTextField();
        this.jLabel50 = new JLabel();
        this.pick = new JButton();
        this.setLayout(new GridBagLayout());
        this.forDisplay.setLayout(new GridBagLayout());
        this.forDisplay.setBorder(new TitledBorder("When Displayed"));
        this.jLabel40.setText("Transparent layer:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.forDisplay.add((Component)this.jLabel40, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.forDisplay.add((Component)this.transparentLayer, gridBagConstraints);
        this.useStipplePatternDisplay.setText("Use Stipple Pattern");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 0, 4);
        this.forDisplay.add((Component)this.useStipplePatternDisplay, gridBagConstraints);
        this.useOutlinePatternDisplay.setText("Outline Pattern");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(2, 4, 0, 4);
        this.forDisplay.add((Component)this.useOutlinePatternDisplay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.forDisplay, gridBagConstraints);
        this.forPrinter.setLayout(new GridBagLayout());
        this.forPrinter.setBorder(new TitledBorder("When Printed"));
        this.useStipplePatternPrinter.setText("Use Stipple Pattern");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 4, 0, 4);
        gridBagConstraints.anchor = 17;
        this.forPrinter.add((Component)this.useStipplePatternPrinter, gridBagConstraints);
        this.useOutlinePatternPrinter.setText("Outline Pattern");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 4, 0, 4);
        this.forPrinter.add((Component)this.useOutlinePatternPrinter, gridBagConstraints);
        this.opacityLabel.setText("Opacity:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.forPrinter.add((Component)this.opacityLabel, gridBagConstraints);
        this.opacity.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints.weightx = 1.0;
        this.forPrinter.add((Component)this.opacity, gridBagConstraints);
        this.opacityExplanation.setText("(0 is Transparent; 1 is Opaque)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.forPrinter.add((Component)this.opacityExplanation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.forPrinter, gridBagConstraints);
        this.appearance.setLayout(new GridBagLayout());
        this.appearance.setBorder(new TitledBorder("Color and Pattern"));
        this.layerGreenLabel.setText("Green:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        gridBagConstraints.anchor = 13;
        this.appearance.add((Component)this.layerGreenLabel, gridBagConstraints);
        this.layerBlueLabel.setText("Blue:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        gridBagConstraints.anchor = 13;
        this.appearance.add((Component)this.layerBlueLabel, gridBagConstraints);
        this.layerGreen.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        this.appearance.add((Component)this.layerGreen, gridBagConstraints);
        this.layerRed.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        this.appearance.add((Component)this.layerRed, gridBagConstraints);
        this.layerRedLabel.setText("Red:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        gridBagConstraints.anchor = 13;
        this.appearance.add((Component)this.layerRedLabel, gridBagConstraints);
        this.layerBlue.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        this.appearance.add((Component)this.layerBlue, gridBagConstraints);
        this.jLabel50.setText("Click on a pattern below  to use it above::");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints.anchor = 17;
        this.appearance.add((Component)this.jLabel50, gridBagConstraints);
        this.pick.setText("Pick");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.appearance.add((Component)this.pick, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.appearance, gridBagConstraints);
    }

    private class PatternChoices
    extends JPanel
    implements MouseListener {
        PatternChoices() {
            this.addMouseListener(this);
        }

        public void paint(Graphics g) {
            ImageIcon icon = Resources.getResource(this.getClass(), "IconLayerPatterns.gif");
            g.drawImage(icon.getImage(), 0, 0, null);
        }

        public void mousePressed(MouseEvent evt) {
            int iconIndex = evt.getX() / 16;
            for (int i = 0; i < 16; ++i) {
                ((ColorPatternPanel)ColorPatternPanel.this).currentLI.pattern[i] = preDefinedPatterns[iconIndex * 16 + i];
            }
            ColorPatternPanel.this.patternView.repaint();
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }
    }

    private class PatternView
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        boolean newState;

        PatternView() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void paint(Graphics g) {
            Dimension dim = this.getSize();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, dim.width, dim.height);
            g.setColor(Color.GRAY);
            for (int i = 0; i <= 256; i += 16) {
                g.drawLine(i, 0, i, 256);
                g.drawLine(0, i, 256, i);
            }
            g.setColor(Color.BLACK);
            for (int y = 0; y < 16; ++y) {
                int bits = ((ColorPatternPanel)ColorPatternPanel.this).currentLI.pattern[y];
                for (int x = 0; x < 16; ++x) {
                    if ((bits & 1 << 15 - x) == 0) continue;
                    g.fillRect(x * 16 + 1, y * 16 + 1, 15, 15);
                }
            }
        }

        public void mousePressed(MouseEvent evt) {
            int xIndex = evt.getX() / 16;
            int yIndex = evt.getY() / 16;
            int curWord = ((ColorPatternPanel)ColorPatternPanel.this).currentLI.pattern[yIndex];
            this.newState = (curWord & 1 << 15 - xIndex) == 0;
            this.mouseDragged(evt);
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
            int xIndex = evt.getX() / 16;
            int yIndex = evt.getY() / 16;
            int curWord = ((ColorPatternPanel)ColorPatternPanel.this).currentLI.pattern[yIndex];
            if ((curWord & 1 << 15 - xIndex) != 0) {
                if (this.newState) {
                    return;
                }
                curWord &= ~(1 << 15 - xIndex);
            } else {
                if (!this.newState) {
                    return;
                }
                curWord |= 1 << 15 - xIndex;
            }
            ((ColorPatternPanel)ColorPatternPanel.this).currentLI.pattern[yIndex] = curWord;
            this.repaint();
        }
    }

    private class LayerColorDocumentListener
    implements DocumentListener {
        LayerColorDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            ColorPatternPanel.this.layerInfoChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            ColorPatternPanel.this.layerInfoChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            ColorPatternPanel.this.layerInfoChanged();
        }
    }

    public static class Info {
        public EGraphics graphics;
        public int[] pattern;
        public boolean useStippleDisplay;
        public boolean outlinePatternDisplay;
        public boolean useStipplePrinter;
        public boolean outlinePatternPrinter;
        public int transparentLayer;
        public int red;
        public int green;
        public int blue;
        public double opacity;

        public Info(EGraphics graphics) {
            this.graphics = graphics;
            this.pattern = new int[16];
            int[] pattern = graphics.getPattern();
            for (int i = 0; i < 16; ++i) {
                this.pattern[i] = pattern[i];
            }
            this.useStippleDisplay = graphics.isPatternedOnDisplay();
            this.outlinePatternDisplay = graphics.isOutlinedOnDisplay();
            this.useStipplePrinter = graphics.isPatternedOnPrinter();
            this.outlinePatternPrinter = graphics.isOutlinedOnPrinter();
            this.transparentLayer = graphics.getTransparentLayer();
            int color = graphics.getColor().getRGB();
            this.red = color >> 16 & 0xFF;
            this.green = color >> 8 & 0xFF;
            this.blue = color & 0xFF;
            this.opacity = graphics.getOpacity();
        }

        public boolean updateGraphics() {
            int color;
            boolean changed = false;
            int[] origPattern = this.graphics.getPattern();
            for (int i = 0; i < 16; ++i) {
                if (this.pattern[i] == origPattern[i]) continue;
                changed = true;
            }
            if (changed) {
                this.graphics.setPattern(this.pattern);
            }
            if (this.useStippleDisplay != this.graphics.isPatternedOnDisplay()) {
                this.graphics.setPatternedOnDisplay(this.useStippleDisplay);
                changed = true;
            }
            if (this.outlinePatternDisplay != this.graphics.isOutlinedOnDisplay()) {
                this.graphics.setOutlinedOnDisplay(this.outlinePatternDisplay);
                changed = true;
            }
            if (this.useStipplePrinter != this.graphics.isPatternedOnPrinter()) {
                this.graphics.setPatternedOnPrinter(this.useStipplePrinter);
                changed = true;
            }
            if (this.outlinePatternPrinter != this.graphics.isOutlinedOnPrinter()) {
                this.graphics.setOutlinedOnPrinter(this.outlinePatternPrinter);
                changed = true;
            }
            if ((color = this.red << 16 | this.green << 8 | this.blue) != (this.graphics.getColor().getRGB() & 0xFFFFFF)) {
                this.graphics.setColor(new Color(color));
                changed = true;
            }
            if (this.opacity != this.graphics.getOpacity()) {
                this.graphics.setOpacity(this.opacity);
                changed = true;
            }
            if (this.transparentLayer != this.graphics.getTransparentLayer()) {
                this.graphics.setTransparentLayer(this.transparentLayer);
                changed = true;
            }
            return changed;
        }
    }
}

