/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.dialogs.ChangeCellGroup;
import com.sun.electric.tool.user.dialogs.NewCell;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ExplorerTree
extends JTree
implements DragGestureListener,
DragSourceListener {
    private TreeHandler handler = null;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private static final int SHOWALPHABETICALLY = 1;
    private static final int SHOWBYCELLGROUP = 2;
    private static final int SHOWBYHIERARCHY = 3;
    private static int howToShow = 2;
    private static ImageIcon iconLibrary = null;
    private static ImageIcon iconGroup = null;
    private static ImageIcon iconJobs = null;
    private static ImageIcon iconLibraries = null;
    private static ImageIcon iconErrors = null;
    private static ImageIcon iconSignals = null;
    private static ImageIcon iconViewIcon = null;
    private static ImageIcon iconViewOldIcon = null;
    private static ImageIcon iconViewLayout = null;
    private static ImageIcon iconViewOldLayout = null;
    private static ImageIcon iconViewSchematics = null;
    private static ImageIcon iconViewOldSchematics = null;
    private static ImageIcon iconViewMisc = null;
    private static ImageIcon iconViewOldMisc = null;
    private static ImageIcon iconViewText = null;
    private static ImageIcon iconViewOldText = null;
    private static String libraryNode = "LIBRARIES";
    private DragSource dragSource = null;
    private DefaultMutableTreeNode selectedNode;

    public static ExplorerTree CreateExplorerTree(DefaultMutableTreeNode rootNode, DefaultTreeModel treeModel) {
        ExplorerTree tree = new ExplorerTree(rootNode, treeModel);
        tree.handler = new TreeHandler(tree);
        tree.addMouseListener(tree.handler);
        return tree;
    }

    private ExplorerTree(DefaultMutableTreeNode rootNode, DefaultTreeModel treeModel) {
        super(treeModel);
        this.rootNode = rootNode;
        this.treeModel = treeModel;
        this.initDND();
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setToggleClickCount(3);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new MyRenderer());
    }

    public Object getCurrentlySelectedObject() {
        return this.handler.currentSelectedObject;
    }

    public static DefaultMutableTreeNode makeLibraryTree() {
        DefaultMutableTreeNode libraryExplorerTree = new DefaultMutableTreeNode(libraryNode);
        switch (howToShow) {
            case 1: {
                ExplorerTree.rebuildExplorerTreeByName(libraryExplorerTree);
                break;
            }
            case 2: {
                ExplorerTree.rebuildExplorerTreeByGroups(libraryExplorerTree);
                break;
            }
            case 3: {
                ExplorerTree.rebuildExplorerTreeByHierarchy(libraryExplorerTree);
            }
        }
        return libraryExplorerTree;
    }

    private static synchronized void rebuildExplorerTreeByName(DefaultMutableTreeNode libraryExplorerTree) {
        List sortedList = Library.getVisibleLibrariesSortedByName();
        Iterator it = sortedList.iterator();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            DefaultMutableTreeNode libTree = new DefaultMutableTreeNode(lib);
            Iterator eit = lib.getCellsSortedByName().iterator();
            while (eit.hasNext()) {
                Cell cell = (Cell)eit.next();
                DefaultMutableTreeNode cellTree = new DefaultMutableTreeNode(cell);
                libTree.add(cellTree);
            }
            libraryExplorerTree.add(libTree);
        }
    }

    private static synchronized void rebuildExplorerTreeByHierarchy(DefaultMutableTreeNode libraryExplorerTree) {
        List sortedList = Library.getVisibleLibrariesSortedByName();
        Iterator it = sortedList.iterator();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            DefaultMutableTreeNode libTree = new DefaultMutableTreeNode(lib);
            Iterator eit = lib.getCellsSortedByName().iterator();
            while (eit.hasNext()) {
                Cell cell = (Cell)eit.next();
                if (cell.getView() == View.ICON || cell.getView().isTextView()) continue;
                Iterator vIt = cell.getVersions();
                while (vIt.hasNext()) {
                    Cell cellVersion = (Cell)vIt.next();
                    Iterator insts = cellVersion.getInstancesOf();
                    if (insts.hasNext()) continue;
                    DefaultMutableTreeNode cellTree = new DefaultMutableTreeNode(cellVersion);
                    libTree.add(cellTree);
                    ExplorerTree.createHierarchicalExplorerTree(cellVersion, cellTree);
                }
            }
            libraryExplorerTree.add(libTree);
        }
    }

    private static void createHierarchicalExplorerTree(Cell cell, DefaultMutableTreeNode cellTree) {
        HashMap<Cell, GenMath.MutableInteger> cellCount = new HashMap<Cell, GenMath.MutableInteger>();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            Cell subCell;
            NodeInst ni = (NodeInst)it.next();
            if (!(ni.getProto() instanceof Cell) || (subCell = (Cell)ni.getProto()).getView() == View.ICON && (ni.isIconOfParent() || (subCell = subCell.contentsView()) == null)) continue;
            GenMath.MutableInteger mi = (GenMath.MutableInteger)cellCount.get(subCell);
            if (mi == null) {
                mi = new GenMath.MutableInteger(0);
                cellCount.put(subCell, mi);
            }
            mi.setValue(mi.intValue() + 1);
        }
        it = cellCount.keySet().iterator();
        while (it.hasNext()) {
            Cell subCell = (Cell)it.next();
            GenMath.MutableInteger mi = (GenMath.MutableInteger)cellCount.get(subCell);
            if (mi == null) continue;
            CellAndCount cc = new CellAndCount(subCell, mi.intValue());
            DefaultMutableTreeNode subCellTree = new DefaultMutableTreeNode(cc);
            cellTree.add(subCellTree);
            ExplorerTree.createHierarchicalExplorerTree(subCell, subCellTree);
        }
    }

    private static synchronized void rebuildExplorerTreeByGroups(DefaultMutableTreeNode libraryExplorerTree) {
        List sortedList = Library.getVisibleLibrariesSortedByName();
        FlagSet cellFlag = NodeProto.getFlagSet(1);
        Iterator it = sortedList.iterator();
        while (it.hasNext()) {
            Cell cell;
            Library lib = (Library)it.next();
            DefaultMutableTreeNode libTree = new DefaultMutableTreeNode(lib);
            List cells = lib.getCellsSortedByName();
            Iterator eit = cells.iterator();
            while (eit.hasNext()) {
                cell = (Cell)eit.next();
                cell.clearBit(cellFlag);
            }
            eit = cells.iterator();
            while (eit.hasNext()) {
                cell = (Cell)eit.next();
                if (cell.getNewestVersion() != cell) continue;
                Cell.CellGroup group = cell.getCellGroup();
                if (group.getNumCells() == 1) {
                    DefaultMutableTreeNode cellTree = new DefaultMutableTreeNode(cell);
                    libTree.add(cellTree);
                    if (cell.getNumVersions() <= 1) continue;
                    Iterator vIt = cell.getVersions();
                    while (vIt.hasNext()) {
                        Cell oldVersion = (Cell)vIt.next();
                        if (oldVersion == cell) continue;
                        DefaultMutableTreeNode oldCellTree = new DefaultMutableTreeNode(oldVersion);
                        cellTree.add(oldCellTree);
                    }
                    continue;
                }
                List cellsInGroup = group.getCellsSortedByView();
                DefaultMutableTreeNode groupTree = null;
                Iterator gIt = cellsInGroup.iterator();
                while (gIt.hasNext()) {
                    Cell cellInGroup = (Cell)gIt.next();
                    if (cellInGroup.isBit(cellFlag)) continue;
                    if (groupTree == null) {
                        groupTree = new DefaultMutableTreeNode(group);
                    }
                    DefaultMutableTreeNode cellTree = new DefaultMutableTreeNode(cellInGroup);
                    groupTree.add(cellTree);
                    cellInGroup.setBit(cellFlag);
                    if (cellInGroup.getNumVersions() <= 1) continue;
                    Iterator vIt = cellInGroup.getVersions();
                    while (vIt.hasNext()) {
                        Cell oldVersion = (Cell)vIt.next();
                        if (oldVersion == cellInGroup) continue;
                        DefaultMutableTreeNode oldCellTree = new DefaultMutableTreeNode(oldVersion);
                        cellTree.add(oldCellTree);
                    }
                }
                if (groupTree == null) continue;
                libTree.add(groupTree);
            }
            libraryExplorerTree.add(libTree);
        }
        cellFlag.freeFlagSet();
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object nodeInfo = ((DefaultMutableTreeNode)value).getUserObject();
        if (nodeInfo instanceof Cell) {
            Cell cell = (Cell)nodeInfo;
            if (cell.getView() == View.SCHEMATIC || cell.getView().isMultiPageView()) {
                Cell.CellGroup group = cell.getCellGroup();
                Cell mainSchematic = group.getMainSchematics();
                int numSchematics = 0;
                Iterator gIt = group.getCells();
                while (gIt.hasNext()) {
                    Cell cellInGroup = (Cell)gIt.next();
                    if (cellInGroup.getView() != View.SCHEMATIC && !cellInGroup.getView().isMultiPageView()) continue;
                    ++numSchematics;
                }
                if (numSchematics > 1 && cell == mainSchematic) {
                    return cell.noLibDescribe() + " **";
                }
            }
            return cell.noLibDescribe();
        }
        if (nodeInfo instanceof Library) {
            Library lib = (Library)nodeInfo;
            String nodeName = lib.getName();
            if (lib == Library.getCurrent() && Library.getNumLibraries() > 1) {
                nodeName = nodeName + " [Current]";
                iconLibrary = Resources.getResource(this.getClass(), "IconLibraryCheck.gif");
            } else {
                iconLibrary = Resources.getResource(this.getClass(), "IconLibrary.gif");
            }
            return nodeName;
        }
        if (nodeInfo instanceof CellAndCount) {
            CellAndCount cc = (CellAndCount)nodeInfo;
            return cc.getCell().noLibDescribe() + " (" + cc.getCount() + ")";
        }
        if (nodeInfo instanceof Cell.CellGroup) {
            Cell.CellGroup group = (Cell.CellGroup)nodeInfo;
            return group.getName();
        }
        if (nodeInfo instanceof ErrorLogger) {
            ErrorLogger el = (ErrorLogger)nodeInfo;
            return el.describe();
        }
        if (nodeInfo instanceof ErrorLogger.ErrorLog) {
            ErrorLogger.ErrorLog el = (ErrorLogger.ErrorLog)nodeInfo;
            return el.describeError();
        }
        if (nodeInfo instanceof Simulation.SimSignal) {
            Simulation.SimSignal sig = (Simulation.SimSignal)nodeInfo;
            return sig.getSignalName();
        }
        if (nodeInfo == null) {
            return "";
        }
        return nodeInfo.toString();
    }

    private void initDND() {
        this.dragSource = DragSource.getDefaultDragSource();
        DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 0x40000000, this);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        if (this.selectedNode == null) {
            return;
        }
        if (this.selectedNode.getUserObject() instanceof Simulation.SimSignal) {
            Simulation.SimSignal sSig = (Simulation.SimSignal)this.selectedNode.getUserObject();
            String sigName = sSig.getSignalContext();
            sigName = sigName == null ? sSig.getSignalName() : sigName + sSig.getSignalName();
            StringSelection transferable = new StringSelection(sigName);
            this.dragSource.startDrag(e, DragSource.DefaultLinkDrop, transferable, this);
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    private static class TreeHandler
    implements MouseListener,
    MouseMotionListener {
        private ExplorerTree tree;
        private Object currentSelectedObject;
        private Cell originalCell;
        private boolean draggingCell;
        private MouseEvent currentMouseEvent;
        private TreePath currentPath;
        private TreePath originalPath;

        TreeHandler(ExplorerTree tree) {
            this.tree = tree;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.draggingCell = false;
            this.cacheEvent(e);
            if (e.isPopupTrigger()) {
                this.doContextMenu();
                return;
            }
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (e.getClickCount() == 2) {
                Cell cell;
                if (this.currentSelectedObject instanceof CellAndCount) {
                    CellAndCount cc = (CellAndCount)this.currentSelectedObject;
                    wf.setCellWindow(cc.getCell());
                    WindowFrame.setCurrentWindowFrame(wf);
                    return;
                }
                if (this.currentSelectedObject instanceof Cell) {
                    Cell cell2 = (Cell)this.currentSelectedObject;
                    wf.setCellWindow(cell2);
                    WindowFrame.setCurrentWindowFrame(wf);
                    return;
                }
                if (this.currentSelectedObject instanceof Library || this.currentSelectedObject instanceof Cell.CellGroup || this.currentSelectedObject instanceof String) {
                    if (this.tree.isExpanded(this.currentPath)) {
                        this.tree.collapsePath(this.currentPath);
                    } else {
                        this.tree.expandPath(this.currentPath);
                    }
                    return;
                }
                if (this.currentSelectedObject instanceof Simulation.SimSignal) {
                    Simulation.SimSignal sig = (Simulation.SimSignal)this.currentSelectedObject;
                    if (wf.getContent() instanceof WaveformWindow) {
                        WaveformWindow ww = (WaveformWindow)wf.getContent();
                        ww.addSignal(sig);
                    }
                    return;
                }
                if (this.currentSelectedObject instanceof Job) {
                    Job job = (Job)this.currentSelectedObject;
                    System.out.println(job.getInfo());
                    return;
                }
                if (this.currentSelectedObject instanceof ErrorLogger.ErrorLog) {
                    ErrorLogger.ErrorLog el = (ErrorLogger.ErrorLog)this.currentSelectedObject;
                    String msg = el.reportError(true, null);
                    System.out.println(msg);
                    return;
                }
                if (this.currentSelectedObject instanceof Cell && (cell = (Cell)this.currentSelectedObject).getNewestVersion() == cell) {
                    this.originalCell = cell;
                    this.originalPath = new TreePath(this.currentPath.getPath());
                    this.draggingCell = true;
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.cacheEvent(e);
            if (e.isPopupTrigger()) {
                this.doContextMenu();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.draggingCell) {
                return;
            }
            this.cacheEvent(e);
            this.tree.clearSelection();
            this.tree.addSelectionPath(this.originalPath);
            this.tree.addSelectionPath(this.currentPath);
            this.tree.updateUI();
        }

        private void cacheEvent(MouseEvent e) {
            this.currentPath = this.tree.getPathForLocation(e.getX(), e.getY());
            if (this.currentPath == null) {
                this.currentSelectedObject = null;
                return;
            }
            this.tree.setSelectionPath(this.currentPath);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.currentPath.getLastPathComponent();
            this.tree.selectedNode = node;
            this.currentSelectedObject = node.getUserObject();
            this.currentMouseEvent = e;
        }

        private void doContextMenu() {
            String msg;
            if (this.currentSelectedObject instanceof Job) {
                Job job = (Job)this.currentSelectedObject;
                JPopupMenu popup = job.getPopupStatus();
                popup.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof CellAndCount) {
                CellAndCount cc = (CellAndCount)this.currentSelectedObject;
                this.currentSelectedObject = cc.getCell();
            }
            if (this.currentSelectedObject instanceof Cell) {
                Cell cell = (Cell)this.currentSelectedObject;
                JPopupMenu menu = new JPopupMenu("Cell");
                JMenuItem menuItem = new JMenuItem("Edit");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$1800(this.this$0, false);
                    }
                });
                menuItem = new JMenuItem("Edit in New Window");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$1800(this.this$0, true);
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Place Instance of Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$1900(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Create New Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2000(this.this$0);
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Create New Version of Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2100(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Duplicate Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2200(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Delete Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2300(this.this$0);
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Rename Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2400(this.this$0);
                    }
                });
                JMenu subMenu = new JMenu("Change View");
                menu.add(subMenu);
                Iterator it = View.getOrderedViews().iterator();
                while (it.hasNext()) {
                    View view = (View)it.next();
                    if (cell.getView() == view) continue;
                    JMenuItem subMenuItem = new JMenuItem(view.getFullName());
                    subMenu.add(subMenuItem);
                    subMenuItem.addActionListener(new ActionListener(this){
                        private final /* synthetic */ TreeHandler this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.access$2500(this.this$0, e);
                        }
                    });
                }
                menu.addSeparator();
                menuItem = new JMenuItem("Change Cell Group...");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2600(this.this$0);
                    }
                });
                menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof Library) {
                Library lib = (Library)this.currentSelectedObject;
                JPopupMenu menu = new JPopupMenu("Library");
                JMenuItem menuItem = new JMenuItem("Open");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2700(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Open all below here");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2800(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Close all below here");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2900(this.this$0);
                    }
                });
                if (lib != Library.getCurrent()) {
                    menu.addSeparator();
                    menuItem = new JMenuItem("Make This the Current Library");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(this){
                        private final /* synthetic */ TreeHandler this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.access$3000(this.this$0);
                        }
                    });
                }
                menu.addSeparator();
                menuItem = new JMenuItem("Create New Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2000(this.this$0);
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Rename Library");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$3100(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Delete Library");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$3200(this.this$0);
                    }
                });
                menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof Cell.CellGroup) {
                JPopupMenu menu = new JPopupMenu("CellGroup");
                JMenuItem menuItem = new JMenuItem("Open");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2700(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Open all below here");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2800(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Close all below here");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2900(this.this$0);
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Create New Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2000(this.this$0);
                    }
                });
                menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof String && (msg = (String)this.currentSelectedObject).equalsIgnoreCase("libraries")) {
                JPopupMenu menu = new JPopupMenu("Libraries");
                JMenuItem menuItem = new JMenuItem("Open");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2700(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Open all below here");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2800(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Close all below here");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2900(this.this$0);
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Create New Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$2000(this.this$0);
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Show Cells Alphabetically");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$3300(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Show Cells by Group");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$3400(this.this$0);
                    }
                });
                menuItem = new JMenuItem("Show Cells by Hierarchy");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ TreeHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.access$3500(this.this$0);
                    }
                });
                menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof ErrorLogger) {
                ErrorLogger logger = (ErrorLogger)this.currentSelectedObject;
                JPopupMenu p = logger.getPopupMenu();
                if (p != null) {
                    p.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                }
                return;
            }
        }

        private void openAction() {
            this.tree.expandPath(this.currentPath);
        }

        private void recursiveOpenAction() {
            this.recursivelyOpen(this.currentPath);
        }

        private void recursivelyOpen(TreePath path) {
            this.tree.expandPath(path);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            int numChildren = node.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                TreePath descentPath = path.pathByAddingChild(child);
                this.recursivelyOpen(descentPath);
            }
        }

        private void recursiveCloseAction() {
            this.recursivelyClose(this.currentPath);
        }

        private void recursivelyClose(TreePath path) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            int numChildren = node.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                TreePath descentPath = path.pathByAddingChild(child);
                this.recursivelyClose(descentPath);
            }
            this.tree.collapsePath(path);
        }

        private void setCurLibAction() {
            Library lib = (Library)this.currentSelectedObject;
            lib.setCurrent();
            WindowFrame.wantToRedoLibraryTree();
            WindowFrame.wantToRedoTitleNames();
            EditWindow.repaintAll();
        }

        private void renameLibraryAction() {
            Library lib = (Library)this.currentSelectedObject;
            CircuitChanges.renameLibrary(lib);
        }

        private void deleteLibraryAction() {
            Library lib = (Library)this.currentSelectedObject;
            FileMenu.closeLibraryCommand(lib);
        }

        private void editCellAction(boolean newWindow) {
            Cell cell = (Cell)this.currentSelectedObject;
            if (newWindow) {
                WindowFrame wf = WindowFrame.createEditWindow(cell);
            } else {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                wf.setCellWindow(cell);
                WindowFrame.setCurrentWindowFrame(wf);
            }
        }

        private void newCellInstanceAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            if (cell == null) {
                return;
            }
            PaletteFrame.placeInstance(cell, null, false);
        }

        private void newCellAction() {
            TopLevel jf = TopLevel.getCurrentJFrame();
            NewCell dialog = new NewCell((Frame)jf, true);
            dialog.show();
        }

        private void newCellVersionAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            CircuitChanges.newVersionOfCell(cell);
        }

        private void duplicateCellAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            String newName = JOptionPane.showInputDialog(this.tree, "Name of duplicated cell", cell.getName() + "NEW");
            if (newName == null) {
                return;
            }
            CircuitChanges.duplicateCell(cell, newName);
        }

        private void deleteCellAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            CircuitChanges.deleteCell(cell, true);
        }

        private void renameCellAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            String response = JOptionPane.showInputDialog(this.tree, "New name for cell " + cell.describe(), cell.getName());
            if (response == null) {
                return;
            }
            CircuitChanges.renameCellInJob(cell, response);
        }

        private void reViewCellAction(ActionEvent e) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            String viewName = menuItem.getText();
            View newView = View.findView(viewName);
            if (newView != null) {
                Cell cell = (Cell)this.currentSelectedObject;
                CircuitChanges.changeCellView(cell, newView);
            }
        }

        private void changeCellGroupAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            ChangeCellGroup dialog = new ChangeCellGroup((Frame)TopLevel.getCurrentJFrame(), true, cell, cell.getLibrary());
            dialog.show();
        }

        private void showAlphabeticallyAction() {
            howToShow = 1;
            WindowFrame.wantToRedoLibraryTree();
        }

        private void showByGroupAction() {
            howToShow = 2;
            WindowFrame.wantToRedoLibraryTree();
        }

        private void showByHierarchyAction() {
            howToShow = 3;
            WindowFrame.wantToRedoLibraryTree();
        }

        static /* synthetic */ void access$1800(TreeHandler x0, boolean x1) {
            x0.editCellAction(x1);
        }

        static /* synthetic */ void access$1900(TreeHandler x0) {
            x0.newCellInstanceAction();
        }

        static /* synthetic */ void access$2000(TreeHandler x0) {
            x0.newCellAction();
        }

        static /* synthetic */ void access$2100(TreeHandler x0) {
            x0.newCellVersionAction();
        }

        static /* synthetic */ void access$2200(TreeHandler x0) {
            x0.duplicateCellAction();
        }

        static /* synthetic */ void access$2300(TreeHandler x0) {
            x0.deleteCellAction();
        }

        static /* synthetic */ void access$2400(TreeHandler x0) {
            x0.renameCellAction();
        }

        static /* synthetic */ void access$2500(TreeHandler x0, ActionEvent x1) {
            x0.reViewCellAction(x1);
        }

        static /* synthetic */ void access$2600(TreeHandler x0) {
            x0.changeCellGroupAction();
        }

        static /* synthetic */ void access$2700(TreeHandler x0) {
            x0.openAction();
        }

        static /* synthetic */ void access$2800(TreeHandler x0) {
            x0.recursiveOpenAction();
        }

        static /* synthetic */ void access$2900(TreeHandler x0) {
            x0.recursiveCloseAction();
        }

        static /* synthetic */ void access$3000(TreeHandler x0) {
            x0.setCurLibAction();
        }

        static /* synthetic */ void access$3100(TreeHandler x0) {
            x0.renameLibraryAction();
        }

        static /* synthetic */ void access$3200(TreeHandler x0) {
            x0.deleteLibraryAction();
        }

        static /* synthetic */ void access$3300(TreeHandler x0) {
            x0.showAlphabeticallyAction();
        }

        static /* synthetic */ void access$3400(TreeHandler x0) {
            x0.showByGroupAction();
        }

        static /* synthetic */ void access$3500(TreeHandler x0) {
            x0.showByHierarchyAction();
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof Library) {
                if (iconLibrary == null) {
                    iconLibrary = Resources.getResource(this.getClass(), "IconLibrary.gif");
                }
                this.setIcon(iconLibrary);
            }
            if (nodeInfo instanceof CellAndCount) {
                CellAndCount cc = (CellAndCount)nodeInfo;
                nodeInfo = cc.getCell();
            }
            if (nodeInfo instanceof Cell) {
                Cell cell = (Cell)nodeInfo;
                if (cell.getView() == View.ICON) {
                    if (iconViewIcon == null) {
                        iconViewIcon = Resources.getResource(this.getClass(), "IconViewIcon.gif");
                    }
                    if (iconViewOldIcon == null) {
                        iconViewOldIcon = Resources.getResource(this.getClass(), "IconViewOldIcon.gif");
                    }
                    if (cell.getNewestVersion() == cell) {
                        this.setIcon(iconViewIcon);
                    } else {
                        this.setIcon(iconViewOldIcon);
                    }
                } else if (cell.getView() == View.LAYOUT) {
                    if (iconViewLayout == null) {
                        iconViewLayout = Resources.getResource(this.getClass(), "IconViewLayout.gif");
                    }
                    if (iconViewOldLayout == null) {
                        iconViewOldLayout = Resources.getResource(this.getClass(), "IconViewOldLayout.gif");
                    }
                    if (cell.getNewestVersion() == cell) {
                        this.setIcon(iconViewLayout);
                    } else {
                        this.setIcon(iconViewOldLayout);
                    }
                } else if (cell.getView() == View.SCHEMATIC || cell.getView().isMultiPageView()) {
                    if (iconViewSchematics == null) {
                        iconViewSchematics = Resources.getResource(this.getClass(), "IconViewSchematics.gif");
                    }
                    if (iconViewOldSchematics == null) {
                        iconViewOldSchematics = Resources.getResource(this.getClass(), "IconViewOldSchematics.gif");
                    }
                    if (cell.getNewestVersion() == cell) {
                        this.setIcon(iconViewSchematics);
                    } else {
                        this.setIcon(iconViewOldSchematics);
                    }
                } else if (cell.getView().isTextView()) {
                    if (iconViewText == null) {
                        iconViewText = Resources.getResource(this.getClass(), "IconViewText.gif");
                    }
                    if (iconViewOldText == null) {
                        iconViewOldText = Resources.getResource(this.getClass(), "IconViewOldText.gif");
                    }
                    if (cell.getNewestVersion() == cell) {
                        this.setIcon(iconViewText);
                    } else {
                        this.setIcon(iconViewOldText);
                    }
                } else {
                    if (iconViewMisc == null) {
                        iconViewMisc = Resources.getResource(this.getClass(), "IconViewMisc.gif");
                    }
                    if (iconViewOldMisc == null) {
                        iconViewOldMisc = Resources.getResource(this.getClass(), "IconViewOldMisc.gif");
                    }
                    if (cell.getNewestVersion() == cell) {
                        this.setIcon(iconViewMisc);
                    } else {
                        this.setIcon(iconViewOldMisc);
                    }
                }
            }
            if (nodeInfo instanceof Cell.CellGroup) {
                if (iconGroup == null) {
                    iconGroup = Resources.getResource(this.getClass(), "IconGroup.gif");
                }
                this.setIcon(iconGroup);
            }
            if (nodeInfo instanceof String) {
                String theString = (String)nodeInfo;
                if (theString.equalsIgnoreCase("jobs")) {
                    if (iconJobs == null) {
                        iconJobs = Resources.getResource(this.getClass(), "IconJobs.gif");
                    }
                    this.setIcon(iconJobs);
                } else if (theString.equalsIgnoreCase("libraries")) {
                    if (iconLibraries == null) {
                        iconLibraries = Resources.getResource(this.getClass(), "IconLibraries.gif");
                    }
                    this.setIcon(iconLibraries);
                } else if (theString.equalsIgnoreCase("errors")) {
                    if (iconErrors == null) {
                        iconErrors = Resources.getResource(this.getClass(), "IconErrors.gif");
                    }
                    this.setIcon(iconErrors);
                } else if (theString.equalsIgnoreCase("signals")) {
                    if (iconSignals == null) {
                        iconSignals = Resources.getResource(this.getClass(), "IconSignals.gif");
                    }
                    this.setIcon(iconSignals);
                }
            }
            if (nodeInfo instanceof Job) {
                Job j = (Job)nodeInfo;
            }
            return this;
        }
    }

    private static class CellAndCount {
        private Cell cell;
        private int count;

        public CellAndCount(Cell cell, int count) {
            this.cell = cell;
            this.count = count;
        }

        public Cell getCell() {
            return this.cell;
        }

        public int getCount() {
            return this.count;
        }
    }
}

