/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.Main;
import java.net.URL;
import javax.swing.ImageIcon;

public class Resources {
    private static final String resourceLocation = "resources/";
    private static final String plugin3D = "com.sun.electric.plugins.j3d";
    private static final String pluginJMFJ3D = "com.sun.electric.plugins.Java3D";

    public static ImageIcon getResource(Class theClass, String iconName) {
        return new ImageIcon(Resources.getURLResource(theClass, iconName));
    }

    public static URL getURLResource(Class theClass, String resourceName) {
        return theClass.getResource(resourceLocation + resourceName);
    }

    public static Class getJMFJ3DClass(String name) {
        return Resources.getClass(name, pluginJMFJ3D);
    }

    public static Class get3DClass(String name) {
        Class java3DClass = Resources.getClass("SimpleUniverse", "com.sun.j3d.utils.universe");
        if (java3DClass == null) {
            return null;
        }
        return Resources.getClass(name, plugin3D);
    }

    private static Class getClass(String name, String plugin) {
        Class<?> theClass = null;
        try {
            theClass = Class.forName(plugin + "." + name);
        }
        catch (ClassNotFoundException e) {
            if (Main.getDebug()) {
                System.out.println("Can't find class '" + name + "' from " + plugin + " plugin: " + e.getMessage());
            }
        }
        catch (Error e) {
            System.out.println(plugin + " not installed: " + e.getMessage());
        }
        return theClass;
    }
}

