/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.cvspm;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.cvspm.State;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.DELIB;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Update {
    public static final int UPDATE = 0;
    public static final int STATUS = 1;
    public static final int ROLLBACK = 2;
    public static final int ROLLFORWARD = 3;

    public static void updateProject(int type) {
        ArrayList<Library> allLibs = new ArrayList<Library>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isFromDisk() || lib.getName().equals("spiceparts")) continue;
            allLibs.add(lib);
        }
        Update.update(allLibs, null, type, true);
    }

    public static void updateOpenLibraries(int type) {
        ArrayList<Library> allLibs = new ArrayList<Library>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isFromDisk() || lib.getName().equals("spiceparts")) continue;
            allLibs.add(lib);
        }
        Update.update(allLibs, null, type, false);
    }

    public static void updateLibrary(Library lib, int type) {
        ArrayList<Library> libsToUpdate = new ArrayList<Library>();
        libsToUpdate.add(lib);
        Update.update(libsToUpdate, null, type, false);
    }

    public static void updateCell(Cell cell, int type) {
        ArrayList<Cell> cellsToUpdate = new ArrayList<Cell>();
        cellsToUpdate.add(cell);
        Update.update(null, cellsToUpdate, type, false);
    }

    public static void update(List<Library> libs, List<Cell> cells, int type, boolean updateProject) {
        int choice;
        String[] choices;
        if (libs == null) {
            libs = new ArrayList<Library>();
        }
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        CVSLibrary.LibsCells bad = CVSLibrary.notFromDELIB(cells);
        if (type == 1) {
            for (Cell cell : bad.cells) {
                cells.remove(cell);
            }
        } else if (bad.cells.size() > 0) {
            CVS.showError("Error: the following Cells are not part of a DELIB library and cannot be acted upon individually", "CVS " + Update.getMessage(type) + " Error", bad.libs, bad.cells);
            return;
        }
        bad = CVSLibrary.getNotInCVS(libs, cells);
        if (type == 1) {
            for (Library lib : bad.libs) {
                libs.remove(lib);
                CVSLibrary.setState(lib, State.UNKNOWN);
            }
            for (Cell cell : bad.cells) {
                cells.remove(cell);
                CVSLibrary.setState(cell, State.UNKNOWN);
            }
        } else if (bad.libs.size() > 0 || bad.cells.size() > 0) {
            CVS.showError("Error: the following Libraries or Cells are not in CVS", "CVS " + Update.getMessage(type) + " Error", bad.libs, bad.cells);
            return;
        }
        CVSLibrary.LibsCells good = CVSLibrary.consolidate(libs, cells);
        if (type == 0) {
            bad = CVSLibrary.getModified(libs, cells);
            if (bad.libs.size() > 0 || bad.cells.size() > 0) {
                choices = new String[]{"Continue Anyway", "Cancel"};
                choice = CVS.askForChoice("Warning: Unsaved changes may be lost!  For:", "CVS " + Update.getMessage(type) + " Warning!", bad.libs, bad.cells, choices, choices[1]);
                if (choice == 1) {
                    return;
                }
            }
        }
        if (type == 2) {
            choices = new String[]{"Continue Anyway", "Cancel"};
            choice = CVS.askForChoice("Warning: Saved and Unsaved changes will be lost!  For:", "CVS " + Update.getMessage(type) + " Warning!", good.libs, good.cells, choices, choices[1]);
            if (choice == 1) {
                return;
            }
        }
        new UpdateJob(good.cells, good.libs, type, updateProject).startJob();
    }

    static void statusNoJob(List<Library> libs, List<Cell> cells, boolean updateProject) {
        UpdateJob job = new UpdateJob(cells, libs, 1, updateProject);
        job.inJob = false;
        job.doIt();
    }

    protected static StatusResult update(String file, String dir, int type) {
        String command = "-q update -d -P ";
        String message = "Running CVS Update";
        if (type == 1) {
            command = "-nq update -d -P ";
            message = "Running CVS Status";
        }
        if (type == 2) {
            command = "-q update -C -P ";
            message = "Rollback from CVS";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitVal = CVS.runCVSCommand(command + file, message, dir, out);
        LineNumberReader result = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        return Update.parseOutput(result, exitVal);
    }

    private static String getMessage(int type) {
        switch (type) {
            case 0: {
                return "Update";
            }
            case 1: {
                return "Status";
            }
            case 2: {
                return "Roll Back";
            }
            case 3: {
                return "Roll Forward";
            }
        }
        return "";
    }

    private static void updateStates(StatusResult result, int type) {
        for (Cell cell : result.getCells(State.ADDED)) {
            CVSLibrary.setState(cell, State.ADDED);
        }
        for (Cell cell : result.getCells(State.REMOVED)) {
            CVSLibrary.setState(cell, State.REMOVED);
        }
        for (Cell cell : result.getCells(State.MODIFIED)) {
            CVSLibrary.setState(cell, State.MODIFIED);
        }
        for (Cell cell : result.getCells(State.CONFLICT)) {
            CVSLibrary.setState(cell, State.CONFLICT);
        }
        for (Cell cell : result.getCells(State.UPDATE)) {
            if (type == 1) {
                CVSLibrary.setState(cell, State.UPDATE);
                continue;
            }
            CVSLibrary.setState(cell, State.NONE);
        }
        for (Cell cell : result.getCells(State.UNKNOWN)) {
            CVSLibrary.setState(cell, State.UNKNOWN);
        }
    }

    public static void rollback(Cell cell) {
        int ret = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "WARNING! Disk file for Cell " + cell.libDescribe() + " will revert to latest CVS version!\n" + "All uncommited changes will be lost!!!  Continue anyway?", "Rollback Cell", 0, 2);
        if (ret == 1) {
            return;
        }
        Update.updateCell(cell, 2);
    }

    public static void rollback(Library lib) {
        int ret = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "WARNING! Disk file(s) for Library" + lib.getName() + " will revert to latest CVS version!\n" + "All uncommited changes will be lost!!!  Continue anyway?", "Rollback Library", 0, 2);
        if (ret == 1) {
            return;
        }
        Update.updateLibrary(lib, 2);
    }

    private static StatusResult parseOutput(LineNumberReader reader, int exitVal) {
        StatusResult result = new StatusResult(exitVal);
        while (true) {
            Cell cell;
            Library lib;
            State state;
            String[] parts;
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                return result;
            }
            if (line == null) break;
            if (line.equals("") || (parts = line.split("\\s+")).length != 2 || (state = State.getState(parts[0])) == null) continue;
            if (state == State.PATCHED) {
                state = State.UPDATE;
            }
            String filename = parts[1];
            File file = new File(filename);
            if (filename.toLowerCase().endsWith(".jelib")) {
                String endfile = file.getName();
                lib = Library.findLibrary(endfile.substring(0, endfile.length() - 6));
                if (lib == null) continue;
                CVSLibrary.setState(lib, state);
            }
            if ((cell = CVS.getCellFromPath(filename)) != null) {
                result.addCell(state, cell);
                continue;
            }
            lib = CVS.getLibraryFromHeader(filename);
            if (lib != null) {
                result.addLibraryHeaderFile(state, lib);
                continue;
            }
            result.addUnknownFile(state, filename);
        }
        return result;
    }

    public static void commentStatusResult(StatusResult result, int type) {
        boolean allFilesUpToDate = true;
        for (Cell cell : result.getCells(State.ADDED)) {
            System.out.println("Added\t" + cell.libDescribe());
            allFilesUpToDate = false;
        }
        for (Cell cell : result.getCells(State.REMOVED)) {
            System.out.println("Removed\t" + cell.libDescribe());
            allFilesUpToDate = false;
        }
        for (Cell cell : result.getCells(State.MODIFIED)) {
            System.out.println("Modified\t" + cell.libDescribe());
            allFilesUpToDate = false;
        }
        for (String file : result.getUnknownFiles(State.MODIFIED)) {
            System.out.println("Modified\t" + file);
            allFilesUpToDate = false;
        }
        for (Cell cell : result.getCells(State.CONFLICT)) {
            System.out.println("Conflicts\t" + cell.libDescribe());
            allFilesUpToDate = false;
        }
        for (String file : result.getUnknownFiles(State.CONFLICT)) {
            System.out.println("Conflicts\t" + file);
            allFilesUpToDate = false;
        }
        for (Cell cell : result.getCells(State.UPDATE)) {
            if (type == 1) {
                System.out.println("NeedsUpdate\t" + cell.libDescribe());
            }
            if (type == 0) {
                System.out.println("Updated\t" + cell.libDescribe());
            }
            allFilesUpToDate = false;
        }
        for (String file : result.getUnknownFiles(State.UPDATE)) {
            if (type == 1) {
                System.out.println("NeedsUpdate\t" + file);
            }
            if (type == 0) {
                System.out.println("Updated\t" + file);
            }
            allFilesUpToDate = false;
        }
        if (type == 1) {
            if (allFilesUpToDate) {
                System.out.println("All files up-to-date");
            } else {
                System.out.println("All other files up-to-date");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatusResult {
        private Map<State, List<Cell>> cells = new HashMap<State, List<Cell>>();
        private Map<State, List<String>> unknownFiles;
        private Map<State, List<Library>> headerFiles = new HashMap<State, List<Library>>();
        private int exitVal;

        private StatusResult(int exitVal) {
            this.unknownFiles = new HashMap<State, List<String>>();
            this.exitVal = exitVal;
        }

        private void addCell(State state, Cell cell) {
            List<Cell> statecells = this.cells.get(state);
            if (statecells == null) {
                statecells = new ArrayList<Cell>();
                this.cells.put(state, statecells);
            }
            statecells.add(cell);
        }

        public List<Cell> getCells(State state) {
            List<Cell> statecells = this.cells.get(state);
            if (statecells == null) {
                statecells = new ArrayList<Cell>();
            }
            return statecells;
        }

        public void addLibraryHeaderFile(State state, Library lib) {
            List<Library> statelibs = this.headerFiles.get(state);
            if (statelibs == null) {
                statelibs = new ArrayList<Library>();
                this.headerFiles.put(state, statelibs);
            }
            statelibs.add(lib);
        }

        public List<Library> getLibraryHeaderFiles(State state) {
            List<Library> statelibs = this.headerFiles.get(state);
            if (statelibs == null) {
                statelibs = new ArrayList<Library>();
            }
            return statelibs;
        }

        public void addUnknownFile(State state, String file) {
            List<String> list = this.unknownFiles.get(state);
            if (list == null) {
                list = new ArrayList<String>();
                this.unknownFiles.put(state, list);
            }
            list.add(file);
        }

        public List<String> getUnknownFiles(State state) {
            List<String> list = this.unknownFiles.get(state);
            if (list == null) {
                list = new ArrayList<String>();
            }
            return list;
        }

        public int getExitVal() {
            return this.exitVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateJob
    extends Job {
        private List<Cell> cellsToUpdate;
        private List<Library> librariesToUpdate;
        private int type;
        private List<Library> libsToReload;
        private boolean updateProject;
        private int exitVal;
        private boolean inJob;

        private UpdateJob(List<Cell> cellsToUpdate, List<Library> librariesToUpdate, int type, boolean updateProject) {
            super("CVS Update Library", User.getUserTool(), type == 1 ? Job.Type.EXAMINE : Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cellsToUpdate = cellsToUpdate;
            this.librariesToUpdate = librariesToUpdate;
            this.type = type;
            this.updateProject = updateProject;
            this.exitVal = -1;
            this.inJob = true;
            if (this.cellsToUpdate == null) {
                this.cellsToUpdate = new ArrayList<Cell>();
            }
            if (this.librariesToUpdate == null) {
                this.librariesToUpdate = new ArrayList<Library>();
            }
        }

        @Override
        public boolean doIt() {
            String updateFiles;
            String useDir = CVS.getUseDir(this.librariesToUpdate, this.cellsToUpdate);
            StringBuffer libs = CVS.getLibraryFiles(this.librariesToUpdate, useDir);
            StringBuffer cells = CVS.getCellFiles(this.cellsToUpdate, useDir);
            ArrayList<File> backupFiles = new ArrayList<File>();
            if (this.type == 3) {
                for (Library lib : this.librariesToUpdate) {
                    File libFile = TextUtils.getFile(lib.getLibFile());
                    if (libFile == null) continue;
                    if (CVS.isDELIB(lib)) {
                        Iterator<Cell> it = lib.getCells();
                        while (it.hasNext()) {
                            backupFiles.add(CVS.getCellFile(it.next()));
                        }
                        backupFiles.add(new File(libFile, DELIB.getHeaderFile()));
                        continue;
                    }
                    backupFiles.add(libFile);
                }
                for (Cell cell : this.cellsToUpdate) {
                    backupFiles.add(CVS.getCellFile(cell));
                }
                for (File f : backupFiles) {
                    File newf = new File(f.getAbsolutePath() + ".ecvstemp");
                    if (!f.exists()) continue;
                    if (!f.renameTo(newf)) {
                        System.out.println("Could not rename file " + f + " to " + newf);
                        continue;
                    }
                    System.out.println("Renamed " + f + " to " + newf);
                }
            }
            if ((updateFiles = libs.toString() + " " + cells.toString()).trim().equals("") && !this.updateProject) {
                this.exitVal = 0;
                if (this.inJob) {
                    this.fieldVariableChanged("exitVal");
                }
                System.out.println("Nothing to " + Update.getMessage(this.type));
                return true;
            }
            if (this.updateProject && (this.type == 0 || this.type == 1)) {
                updateFiles = "";
            }
            StatusResult result = Update.update(updateFiles, useDir, this.type);
            Update.commentStatusResult(result, this.type);
            this.exitVal = result.getExitVal();
            if (this.type == 3) {
                for (File f : backupFiles) {
                    File newf = new File(f.getAbsolutePath() + ".ecvstemp");
                    if (!newf.exists()) continue;
                    if (!newf.renameTo(f)) {
                        System.out.println("Error: unabled to rename " + newf + " to " + f);
                        continue;
                    }
                    System.out.println("Renamed " + newf + " to " + f);
                }
                result = Update.update(updateFiles, useDir, 1);
                Update.commentStatusResult(result, this.type);
            }
            if (this.inJob) {
                this.fieldVariableChanged("exitVal");
            }
            if (this.exitVal != 0 && this.exitVal != 1) {
                return true;
            }
            this.libsToReload = new ArrayList<Library>();
            if (this.type != 1 && this.type != 3) {
                for (Cell cell : result.getCells(State.UPDATE)) {
                    Library lib = cell.getLibrary();
                    if (this.libsToReload.contains(lib)) continue;
                    this.libsToReload.add(lib);
                }
                for (int i = 0; i < this.libsToReload.size(); ++i) {
                    Library lib = this.libsToReload.get(i);
                    String libName = lib.getName();
                    LibraryFiles.reloadLibrary(lib);
                    this.libsToReload.set(i, Library.findLibrary(libName));
                }
            }
            if (this.type == 2) {
                for (Cell cell : result.getCells(State.UPDATE)) {
                    CVSLibrary.setEditing(cell, false);
                }
            }
            Update.updateStates(result, this.type);
            System.out.println(Update.getMessage(this.type) + " complete.");
            if (this.inJob) {
                this.fieldVariableChanged("libsToReload");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.exitVal != 0 && this.exitVal != 1) {
                Job.getUserInterface().showErrorMessage("CVS " + Update.getMessage(this.type) + " Failed (exit status " + this.exitVal + ")!  Please see messages window", "CVS " + Update.getMessage(this.type) + " Failed!");
                return;
            }
            WindowFrame.wantToRedoLibraryTree();
            CVS.fixStaleCellReferences(this.libsToReload);
        }
    }
}

