/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.TimedSignal;
import java.awt.geom.Rectangle2D;

public class AnalogSignal
extends TimedSignal {
    private double[] values;

    public AnalogSignal(Analysis an) {
        super(an);
    }

    public void finished() {
        this.values = null;
    }

    public void buildValues(int numEvents) {
        this.values = new double[numEvents];
    }

    public void setValue(int index, double value) {
        this.values[index] = value;
        this.bounds = null;
    }

    public void getEvent(int sweep, int index, double[] result) {
        if (sweep != 0) {
            throw new IndexOutOfBoundsException();
        }
        result[0] = this.getTime(index);
        result[1] = result[2] = this.values[index];
    }

    public int getNumEvents() {
        return this.getNumEvents(0);
    }

    public int getNumEvents(int sweep) {
        if (sweep != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.values.length;
    }

    public int getNumSweeps() {
        return 1;
    }

    protected void calcBounds() {
        double lowTime = 0.0;
        double highTime = 0.0;
        double lowValue = 0.0;
        double highValue = 0.0;
        boolean first = true;
        double[] result = new double[3];
        int numSweeps = this.getNumSweeps();
        for (int sweep = 0; sweep < numSweeps; ++sweep) {
            int numEvents = this.getNumEvents(sweep);
            for (int i = 0; i < numEvents; ++i) {
                this.getEvent(sweep, i, result);
                double time = result[0];
                double lowVal = result[1];
                double highVal = result[2];
                if (first) {
                    first = false;
                    lowTime = highTime = time;
                    lowValue = lowVal;
                    highValue = highVal;
                    continue;
                }
                if (time < lowTime) {
                    lowTime = time;
                }
                if (time > highTime) {
                    highTime = time;
                }
                if (lowVal < lowValue) {
                    lowValue = lowVal;
                }
                if (!(highVal > highValue)) continue;
                highValue = highVal;
            }
        }
        this.bounds = new Rectangle2D.Double(lowTime, lowValue, highTime - lowTime, highValue - lowValue);
    }
}

