/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.io.output.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Pads
extends Output {
    public static final Variable.Key REF_DES_KEY = Variable.newKey("ATTR_ref_des");
    public static final Variable.Key PKG_TYPE_KEY = Variable.newKey("ATTR_pkg_type");
    public static final Variable.Key PIN_KEY = Variable.newKey("ATTR_pin");
    private List<Output.NetNames> networks;

    private Pads() {
    }

    public static void writePadsFile(Cell cell, VarContext context, String filePath) {
        Pads out = new Pads();
        out.writeNetlist(cell, context, filePath);
    }

    private void writeNetlist(Cell cell, VarContext context, String filePath) {
        if (this.openTextOutputStream(filePath)) {
            return;
        }
        this.printWriter.println("!PADS-POWERPCB-V2");
        this.printWriter.println("");
        this.printWriter.println("*CLUSTER* ITEM");
        this.printWriter.println("");
        this.printWriter.println("*PART*");
        this.networks = new ArrayList<Output.NetNames>();
        PadsNetlister netlister = new PadsNetlister();
        HierarchyEnumerator.enumerateCell(cell, context, netlister, true);
        this.printWriter.println("");
        this.printWriter.println("*NET*");
        if (this.networks.size() == 0) {
            System.out.println("ERROR: no output produced.  Packages need attribute 'ref_des' and ports need attribute 'pin'");
        }
        Collections.sort(this.networks, new Output.NetNamesSort());
        for (int i = 0; i < this.networks.size(); ++i) {
            Output.NetNames oNn;
            Output.NetNames nn = this.networks.get(i);
            String baseName = nn.netName;
            int endPos = i;
            int j = i + 1;
            while (j < this.networks.size()) {
                oNn = this.networks.get(j);
                if (!oNn.netName.equals(baseName)) break;
                endPos = j++;
            }
            if (endPos == i) continue;
            this.printWriter.println("*SIGNAL* " + baseName);
            for (j = i; j <= endPos; ++j) {
                oNn = this.networks.get(j);
                this.printWriter.println(oNn.nodeName + "." + oNn.portName);
            }
            this.printWriter.println("");
        }
        this.printWriter.println("*END*");
        if (this.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    private class PadsNetlister
    extends HierarchyEnumerator.Visitor {
        private PadsNetlister() {
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            if (!no.isCellInstance()) {
                return false;
            }
            Variable var = no.getVar(REF_DES_KEY);
            if (var == null) {
                return true;
            }
            String context = "";
            Nodable pNo = info.getParentInst();
            HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
            if (parentInfo != null && pNo != null) {
                context = parentInfo.getUniqueNodableName(pNo, ".") + ".";
            }
            String nodeName = context + var.getPureValue(-1);
            String pkgType = no.getProto().getName();
            Variable pkgName = no.getVar(PKG_TYPE_KEY);
            if (pkgName != null) {
                pkgType = pkgName.getPureValue(-1);
            }
            Pads.this.printWriter.println(nodeName + "  " + pkgType + "@" + pkgType);
            Iterator<PortProto> it = no.getProto().getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                String pName = null;
                PortInst pi = no.getNodeInst().findPortInstFromProto(pp);
                Variable pVar = pi.getVar(PIN_KEY);
                if (pVar != null) {
                    pName = pVar.getPureValue(-1);
                } else {
                    pVar = pp.getVar(PIN_KEY);
                    if (pVar != null) {
                        pName = pVar.getPureValue(-1);
                    }
                }
                if (pName == null) continue;
                int[] ids = info.getPortNetIDs(no, pp);
                for (int i = 0; i < ids.length; ++i) {
                    Output.NetNames nn = new Output.NetNames();
                    nn.netName = info.getUniqueNetName(ids[i], ".");
                    nn.nodeName = nodeName;
                    nn.portName = pName;
                    Pads.this.networks.add(nn);
                }
            }
            return false;
        }
    }
}

