/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NetworkHighlighter
extends HierarchyEnumerator.Visitor {
    private static final boolean TRIMMEDDISPLAY = false;
    private Cell cell;
    private Netlist netlist;
    private Set<Network> nets;
    private BitSet netIDs;
    private int startDepth;
    private int endDepth;
    private int currentDepth;
    private Highlighter highlighter;

    private NetworkHighlighter(Cell cell, Netlist netlist, Set<Network> nets, int startDepth, int endDepth) {
        this.cell = cell;
        this.netlist = netlist;
        this.nets = nets;
        this.startDepth = startDepth;
        this.endDepth = endDepth;
        this.currentDepth = 0;
        this.highlighter = new Highlighter(0, null);
    }

    public static synchronized List<Highlight2> getHighlights(Cell cell, Netlist netlist, Set<Network> nets, int startDepth, int endDepth) {
        NetworkHighlighter networkHighlighter = new NetworkHighlighter(cell, netlist, nets, startDepth, endDepth);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, networkHighlighter);
        return networkHighlighter.highlighter.getHighlights();
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        if (this.currentDepth == 0) {
            this.netIDs = new BitSet();
            for (Network net : this.nets) {
                this.netIDs.set(info.getNetID(net));
            }
        }
        if (this.cell.isSchematic() && this.currentDepth > 0) {
            return false;
        }
        if (this.currentDepth >= this.startDepth) {
            if (this.currentDepth > this.endDepth) {
                return false;
            }
            if (this.currentDepth == 0) {
                this.addNetworkObjects();
            } else {
                this.addNetworkPolys(info);
            }
        }
        ++this.currentDepth;
        return true;
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
        --this.currentDepth;
    }

    @Override
    public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
        return true;
    }

    private static HashSet<ElectricObject> getNetworkObjects(Cell cell, Netlist netlist, Set<Network> nets) {
        HashSet<ElectricObject> objs = new HashSet<ElectricObject>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.getNameKey().isBus()) continue;
            Iterator<PortInst> pit = ni.getPortInsts();
            while (pit.hasNext()) {
                PortInst pi = pit.next();
                PortProto portProto = pi.getPortProto();
                if (portProto.getNameKey().isBus() || !nets.contains(netlist.getNetwork(pi))) continue;
                objs.add(pi);
            }
        }
        Iterator<ArcInst> aIt = cell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = aIt.next();
            int width = netlist.getBusWidth(ai);
            for (int i = 0; i < width; ++i) {
                if (!nets.contains(netlist.getNetwork(ai, i))) continue;
                objs.add(ai);
                PortInst pi = ai.getHeadPortInst();
                if (!pi.getNodeInst().isCellInstance() && pi.getNodeInst().getProto().getFunction() != PrimitiveNode.Function.PIN) {
                    objs.add(pi);
                }
                if ((pi = ai.getTailPortInst()).getNodeInst().isCellInstance() || pi.getNodeInst().getProto().getFunction() == PrimitiveNode.Function.PIN) continue;
                objs.add(pi);
            }
        }
        Iterator<PortProto> pIt = cell.getPorts();
        while (pIt.hasNext()) {
            Export pp = (Export)pIt.next();
            int width = netlist.getBusWidth(pp);
            for (int i = 0; i < width; ++i) {
                if (!nets.contains(netlist.getNetwork(pp, i))) continue;
                objs.add(pp);
            }
        }
        return objs;
    }

    private void addNetworkObjects() {
        HashSet<ElectricObject> objs = NetworkHighlighter.getNetworkObjects(this.cell, this.netlist, this.nets);
        for (ElectricObject eObj : objs) {
            this.highlighter.addElectricObject(eObj, this.cell, false);
        }
    }

    private void addNetworkPolys(HierarchyEnumerator.CellInfo info) {
        Netlist netlist = info.getNetlist();
        HashSet<Network> localNets = new HashSet<Network>();
        Iterator<Network> it = netlist.getNetworks();
        while (it.hasNext()) {
            Network aNet = it.next();
            if (!this.netIDs.get(info.getNetID(aNet))) continue;
            localNets.add(aNet);
        }
        this.addNetworkPolys(localNets, info);
    }

    private void addNetworkPolys(HashSet<Network> localNets, HierarchyEnumerator.CellInfo info) {
        Netlist netlist = info.getNetlist();
        if (localNets.size() == 0) {
            return;
        }
        Cell currentCell = info.getCell();
        HashSet<ElectricObject> objs = NetworkHighlighter.getNetworkObjects(currentCell, netlist, localNets);
        AffineTransform trans = info.getTransformToRoot();
        for (ElectricObject o : objs) {
            Color color = null;
            Poly poly = null;
            if (o instanceof ArcInst) {
                ArcInst ai = (ArcInst)o;
                poly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.CLOSED);
            } else if (o instanceof PortInst) {
                PortInst pi = (PortInst)o;
                NodeInst ni = pi.getNodeInst();
                poly = Highlight2.getNodeInstOutline(ni);
            } else if (o instanceof Export) {
                Export ep = (Export)o;
                PortInst pi = ep.getOriginalPort();
                NodeInst ni = pi.getNodeInst();
                poly = ni.getShapeOfPort(pi.getPortProto());
                color = Color.YELLOW;
            }
            poly.transform(trans);
            this.highlighter.addPoly(poly, this.cell, color);
        }
    }
}

