/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.id;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Tool;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class IdWriter {
    public final IdManager idManager;
    private final DataOutputStream out;
    private TechCounts[] techCounts = new TechCounts[0];
    private int libCount;
    private int[] exportCounts = new int[0];
    private HashMap<Variable.Key, Integer> varKeys = new HashMap();
    private HashMap<TextDescriptor, Integer> textDescriptors = new HashMap();
    private HashMap<Tool, Integer> tools = new HashMap();
    private HashMap<Orientation, Integer> orients = new HashMap();

    public IdWriter(IdManager idManager, DataOutputStream out) {
        this.idManager = idManager;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDiffs() throws IOException {
        CellId[] cellIdsArray;
        LibId[] libIdsArray;
        TechId[] techIdsArray;
        IdManager idManager = this.idManager;
        synchronized (idManager) {
            techIdsArray = this.idManager.techIds.toArray(TechId.NULL_ARRAY);
            libIdsArray = this.idManager.libIds.toArray(LibId.NULL_ARRAY);
            cellIdsArray = this.idManager.cellIds.toArray(CellId.NULL_ARRAY);
        }
        this.writeInt(techIdsArray.length);
        if (techIdsArray.length != this.techCounts.length) {
            TechCounts[] newTechCounts = new TechCounts[techIdsArray.length];
            System.arraycopy(this.techCounts, 0, newTechCounts, 0, this.techCounts.length);
            for (int techIndex = this.techCounts.length; techIndex < techIdsArray.length; ++techIndex) {
                TechId techId = techIdsArray[techIndex];
                this.writeString(techId.techName);
                newTechCounts[techIndex] = new TechCounts();
            }
            this.techCounts = newTechCounts;
        }
        this.writeInt(libIdsArray.length);
        for (int libIndex = this.libCount; libIndex < libIdsArray.length; ++libIndex) {
            LibId libId = libIdsArray[libIndex];
            this.writeString(libId.libName);
        }
        this.libCount = libIdsArray.length;
        this.writeInt(cellIdsArray.length);
        if (cellIdsArray.length != this.exportCounts.length) {
            int[] newExportCounts = new int[cellIdsArray.length];
            System.arraycopy(this.exportCounts, 0, newExportCounts, 0, this.exportCounts.length);
            for (int cellIndex = this.exportCounts.length; cellIndex < cellIdsArray.length; ++cellIndex) {
                CellId cellId = cellIdsArray[cellIndex];
                this.writeLibId(cellId.libId);
                this.writeString(cellId.cellName.toString());
            }
            this.exportCounts = newExportCounts;
        }
        for (int techIndex = 0; techIndex < techIdsArray.length; ++techIndex) {
            TechId techId = techIdsArray[techIndex];
            TechCounts techCount = this.techCounts[techIndex];
            int modCount = techId.modCount;
            if (modCount == techCount.modCount) continue;
            this.writeInt(techIndex);
            int numArcProtoIds = techId.numArcProtoIds();
            int numNewArcProtoIds = numArcProtoIds - techCount.arcCount;
            assert (numNewArcProtoIds >= 0);
            this.writeInt(numNewArcProtoIds);
            for (int i = 0; i < numNewArcProtoIds; ++i) {
                this.writeString(techId.getArcProtoId((int)(techCount.arcCount + i)).name);
            }
            techCount.arcCount = numArcProtoIds;
            int numPrimitiveNodeIds = techId.numPrimitiveNodeIds();
            int numNewPrimitiveNodeIds = numPrimitiveNodeIds - techCount.portCounts.length;
            assert (numNewPrimitiveNodeIds >= 0);
            this.writeInt(numNewPrimitiveNodeIds);
            if (numNewPrimitiveNodeIds > 0) {
                for (int i = 0; i < numNewPrimitiveNodeIds; ++i) {
                    this.writeString(techId.getPrimitiveNodeId((int)(techCount.portCounts.length + i)).name);
                }
                int[] newPortCounts = new int[numPrimitiveNodeIds];
                System.arraycopy(techCount.portCounts, 0, newPortCounts, 0, techCount.portCounts.length);
                techCount.portCounts = newPortCounts;
            }
            for (int primIndex = 0; primIndex < numPrimitiveNodeIds; ++primIndex) {
                PrimitiveNodeId primitiveNodeId = techId.getPrimitiveNodeId(primIndex);
                int numPrimitivePortIds = primitiveNodeId.numPrimitivePortIds();
                int numNewPrimitivePortIds = numPrimitivePortIds - techCount.portCounts[primIndex];
                assert (numNewPrimitivePortIds >= 0);
                if (numNewPrimitivePortIds == 0) continue;
                this.writeInt(primIndex);
                this.writeInt(numNewPrimitivePortIds);
                for (int i = 0; i < numNewPrimitivePortIds; ++i) {
                    this.writeString(primitiveNodeId.getPortId((int)(techCount.portCounts[primIndex] + i)).externalId);
                }
                techCount.portCounts[primIndex] = numPrimitivePortIds;
            }
            this.writeInt(-1);
            techCount.modCount = modCount;
        }
        this.writeInt(-1);
        for (int cellIndex = 0; cellIndex < cellIdsArray.length; ++cellIndex) {
            int exportCount;
            CellId cellId = cellIdsArray[cellIndex];
            int numExportIds = cellId.numExportIds();
            if (numExportIds == (exportCount = this.exportCounts[cellIndex])) continue;
            this.writeInt(cellIndex);
            int numNewExportIds = numExportIds - exportCount;
            assert (numNewExportIds > 0);
            this.writeInt(numNewExportIds);
            for (int i = 0; i < numNewExportIds; ++i) {
                this.writeString(cellId.getPortId((int)(exportCount + i)).externalId);
            }
            this.exportCounts[cellIndex] = numExportIds;
        }
        this.writeInt(-1);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    public void writeByte(byte v) throws IOException {
        this.out.writeByte(v);
    }

    public void writeShort(short v) throws IOException {
        this.out.writeShort(v);
    }

    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    public void writeBytes(byte[] v) throws IOException {
        this.out.writeInt(v.length);
        this.out.write(v);
    }

    public void writeString(String s) throws IOException {
        this.out.writeUTF(s);
    }

    public void writeVariableKey(Variable.Key key) throws IOException {
        Integer i = this.varKeys.get(key);
        if (i != null) {
            this.out.writeInt(i);
        } else {
            i = new Integer(this.varKeys.size());
            this.varKeys.put(key, i);
            this.out.writeInt(i);
            this.out.writeUTF(key.toString());
        }
    }

    public void writeTextDescriptor(TextDescriptor td) throws IOException {
        if (td == null) {
            this.out.writeInt(-1);
            return;
        }
        Integer i = this.textDescriptors.get(td);
        if (i != null) {
            this.out.writeInt(i);
        } else {
            i = new Integer(this.textDescriptors.size());
            this.textDescriptors.put(td, i);
            this.out.writeInt(i);
            this.out.writeLong(td.lowLevelGet());
            this.out.writeInt(td.getColorIndex());
            this.out.writeBoolean(td.isDisplay());
            int face = td.getFace();
            String fontName = face != 0 ? AbstractTextDescriptor.ActiveFont.findActiveFont(face).getName() : "";
            this.out.writeUTF(fontName);
        }
    }

    public void writeTool(Tool tool) throws IOException {
        Integer i = this.tools.get(tool);
        if (i != null) {
            this.out.writeInt(i);
        } else {
            i = new Integer(this.tools.size());
            this.tools.put(tool, i);
            this.out.writeInt(i);
            this.out.writeUTF(tool.getName());
        }
    }

    public void writeTechId(TechId techId) throws IOException {
        assert (techId.idManager == this.idManager);
        this.out.writeInt(techId.techIndex);
    }

    public void writeArcProtoId(ArcProtoId arcProtoId) throws IOException {
        this.writeTechId(arcProtoId.techId);
        this.writeInt(arcProtoId.chronIndex);
    }

    public void writeLibId(LibId libId) throws IOException {
        this.out.writeInt(libId.libIndex);
    }

    public void writeNodeProtoId(NodeProtoId nodeProtoId) throws IOException {
        if (nodeProtoId instanceof CellId) {
            CellId cellId = (CellId)nodeProtoId;
            assert (cellId.idManager == this.idManager);
            this.out.writeInt(cellId.cellIndex);
            return;
        }
        PrimitiveNodeId pnId = (PrimitiveNodeId)nodeProtoId;
        this.out.writeInt(~pnId.chronIndex);
        this.writeTechId(pnId.techId);
    }

    public void writePortProtoId(PortProtoId portProtoId) throws IOException {
        this.writeNodeProtoId(portProtoId.getParentId());
        this.out.writeInt(portProtoId.getChronIndex());
    }

    public void writeNodeId(int nodeId) throws IOException {
        this.out.writeInt(nodeId);
    }

    public void writeArcId(int arcId) throws IOException {
        this.out.writeInt(arcId);
    }

    public void writeNameKey(Name nameKey) throws IOException {
        this.out.writeUTF(nameKey.toString());
    }

    public void writeOrientation(Orientation orient) throws IOException {
        Integer i = this.orients.get(orient);
        if (i != null) {
            this.out.writeInt(i);
        } else {
            i = new Integer(this.orients.size());
            this.orients.put(orient, i);
            this.out.writeInt(i);
            this.out.writeShort(orient.getAngle());
            this.out.writeBoolean(orient.isXMirrored());
            this.out.writeBoolean(orient.isYMirrored());
        }
    }

    public void writeCoord(long v) throws IOException {
        this.out.writeLong(v);
    }

    public void writePoint(EPoint p) throws IOException {
        this.writeCoord(p.getGridX());
        this.writeCoord(p.getGridY());
    }

    public void writeRectangle(ERectangle r) throws IOException {
        this.writeCoord(r.getGridX());
        this.writeCoord(r.getGridY());
        this.writeCoord(r.getGridWidth());
        this.writeCoord(r.getGridHeight());
    }

    private static class TechCounts {
        int modCount;
        int arcCount;
        int[] portCounts = new int[0];

        private TechCounts() {
        }
    }
}

